/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import io.confluent.common.security.jetty.OAuthRequestData;
import io.confluent.common.security.jetty.OAuthRequestDataFactory;
import io.confluent.common.security.util.AuthUtils;
import io.confluent.ksql.api.auth.AuthenticationPlugin;
import io.confluent.ksql.util.VertxCompletableFuture;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpVersion;
import io.vertx.ext.web.RoutingContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.security.AuthenticationState;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Components;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.server.internal.HttpChannelState;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VertxAuthenticationPlugin
implements AuthenticationPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(VertxAuthenticationPlugin.class);
    protected static final String IMPERSONATE_TOKEN_KEY = "impersonate-token";
    protected Authenticator authenticator;

    public CompletableFuture<Principal> handleAuth(RoutingContext routingContext, WorkerExecutor workerExecutor) {
        VertxCompletableFuture cf = new VertxCompletableFuture();
        workerExecutor.executeBlocking(promise -> this.handleAuthBlocking(routingContext, (Promise<Principal>)promise), (Handler)cf);
        return cf;
    }

    public String getAuthHeader(RoutingContext routingContext) {
        String tokenToUse;
        String rawAuthHeader = routingContext.request().getHeader(HttpHeader.AUTHORIZATION.asString());
        if (rawAuthHeader != null) {
            return rawAuthHeader;
        }
        OAuthRequestDataFactory oAuthRequestDataFactory = OAuthRequestDataFactory.getInstance();
        OAuthRequestData authRequestData = oAuthRequestDataFactory.getOAuthRequestData(VertxAuthenticationPlugin.toRequest(routingContext));
        String tokenFromCookie = authRequestData.tokenFromCookie();
        String tokenFromQueryParam = authRequestData.tokenFromQueryParam();
        String string = tokenToUse = tokenFromCookie != null ? tokenFromCookie : tokenFromQueryParam;
        if (tokenToUse == null) {
            tokenToUse = (String)routingContext.get(IMPERSONATE_TOKEN_KEY);
        }
        return "Bearer " + tokenToUse;
    }

    public abstract void configure(Map<String, ?> var1);

    protected void configure(String realm, Authenticator authenticator, LoginService loginService) {
        this.authenticator = authenticator;
        AuthUtils.configureAuthenticatorForNonJettyUsage((Authenticator)authenticator, (String)realm, (LoginService)loginService);
    }

    protected abstract boolean validateUser(UserIdentity var1);

    private void handleAuthBlocking(RoutingContext routingContext, Promise<Principal> promise) {
        if (this.authenticator == null) {
            throw new IllegalStateException("Not configured");
        }
        try {
            AuthenticationState authenticationState = this.authenticator.validateRequest(VertxAuthenticationPlugin.toRequest(routingContext), VertxAuthenticationPlugin.toResponse(routingContext), Callback.NOOP);
            if (authenticationState instanceof LoginAuthenticator.UserAuthenticationSucceeded) {
                LoginAuthenticator.UserAuthenticationSucceeded userAuthentication = (LoginAuthenticator.UserAuthenticationSucceeded)authenticationState;
                UserIdentity userIdentity = userAuthentication.getUserIdentity();
                if (!this.validateUser(userIdentity)) {
                    routingContext.fail(HttpStatus.Code.FORBIDDEN.getCode());
                    promise.fail((Throwable)new AuthorizationException("You are not allowed to access this resource"));
                } else {
                    promise.complete((Object)this.getPrincipalFromUserIdentity(userIdentity, routingContext));
                }
            } else {
                routingContext.fail(HttpStatus.Code.UNAUTHORIZED.getCode());
                promise.fail((Throwable)new AuthenticationException("Please authenticate"));
            }
        }
        catch (ServerAuthException e) {
            promise.fail((Throwable)e);
        }
    }

    protected abstract Principal getPrincipalFromUserIdentity(UserIdentity var1, RoutingContext var2);

    private static Request toRequest(RoutingContext routingContext) {
        return new WrappedRequest(routingContext);
    }

    private static Response toResponse(RoutingContext routingContext) {
        return new WrappedResponse(routingContext);
    }

    public static HttpCookie convertVertxCookieToJettyCookie(final Cookie vertxCookie) {
        return new HttpCookie(){

            public String getName() {
                return vertxCookie.getName();
            }

            public String getValue() {
                return vertxCookie.getValue();
            }

            public int getVersion() {
                return 0;
            }

            public Map<String, String> getAttributes() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class WrappedRequest
    implements Request {
        private final RoutingContext routingContext;
        private final Map<String, Object> attributes = new HashMap<String, Object>();

        public WrappedRequest(RoutingContext routingContext) {
            this.routingContext = routingContext;
            try {
                X509Certificate[] certs;
                if (routingContext.request().connection().sslSession() != null && (certs = (X509Certificate[])routingContext.request().connection().sslSession().getPeerCertificates()) != null && certs.length > 0) {
                    this.attributes.put("jakarta.servlet.request.X509Certificate", certs);
                }
            }
            catch (Exception e) {
                LOG.error("Failed to get peer certificates, error - {}", (Object)e.getMessage());
            }
            if (!routingContext.request().cookies().isEmpty()) {
                List<HttpCookie> cookieList = routingContext.request().cookies().stream().map(VertxAuthenticationPlugin::convertVertxCookieToJettyCookie).toList();
                this.attributes.put(Request.COOKIE_ATTRIBUTE, cookieList);
            }
        }

        public Object removeAttribute(String s) {
            this.attributes.remove(s);
            return this.routingContext.remove(s);
        }

        public Object setAttribute(String s, Object o) {
            this.routingContext.put(s, o);
            this.attributes.put(s, o);
            return o;
        }

        public synchronized Object getAttribute(String attributeName) {
            return this.attributes.get(attributeName);
        }

        public Set<String> getAttributeNameSet() {
            return this.attributes.keySet();
        }

        public boolean isSecure() {
            return this.routingContext.request().isSSL();
        }

        public Content.Chunk read() {
            throw new UnsupportedOperationException();
        }

        public boolean consumeAvailable() {
            return false;
        }

        public void addIdleTimeoutListener(Predicate<TimeoutException> predicate) {
            throw new UnsupportedOperationException();
        }

        public void addFailureListener(Consumer<Throwable> consumer) {
            throw new UnsupportedOperationException();
        }

        public TunnelSupport getTunnelSupport() {
            throw new UnsupportedOperationException();
        }

        public void addHttpStreamWrapper(Function<HttpStream, HttpStream> function) {
            throw new UnsupportedOperationException();
        }

        public Session getSession(boolean b) {
            throw new UnsupportedOperationException();
        }

        public String getId() {
            return "";
        }

        public Components getComponents() {
            return new HttpChannelState(this.getConnectionMetaData());
        }

        public ConnectionMetaData getConnectionMetaData() {
            return new ConnectionMetaData(){

                public Object removeAttribute(String s) {
                    attributes.remove(s);
                    routingContext.remove(s);
                    return attributes;
                }

                public Object setAttribute(String s, Object o) {
                    attributes.put(s, o);
                    routingContext.put(s, o);
                    return attributes;
                }

                public Object getAttribute(String s) {
                    return attributes.get(s);
                }

                public Set<String> getAttributeNameSet() {
                    return attributes.keySet();
                }

                public String getId() {
                    return "";
                }

                public HttpConfiguration getHttpConfiguration() {
                    return new HttpConfiguration();
                }

                public org.eclipse.jetty.http.HttpVersion getHttpVersion() {
                    HttpVersion version = routingContext.request().version();
                    return switch (version) {
                        default -> throw new IncompatibleClassChangeError();
                        case HttpVersion.HTTP_1_0 -> org.eclipse.jetty.http.HttpVersion.HTTP_1_0;
                        case HttpVersion.HTTP_1_1 -> org.eclipse.jetty.http.HttpVersion.HTTP_1_1;
                        case HttpVersion.HTTP_2 -> org.eclipse.jetty.http.HttpVersion.HTTP_2;
                    };
                }

                public String getProtocol() {
                    return this.getHttpVersion().toString();
                }

                public Connection getConnection() {
                    throw new UnsupportedOperationException();
                }

                public Connector getConnector() {
                    return new LocalConnector(new Server());
                }

                public boolean isPersistent() {
                    return false;
                }

                public SocketAddress getRemoteSocketAddress() {
                    return new InetSocketAddress(routingContext.request().remoteAddress().host(), routingContext.request().remoteAddress().port());
                }

                public SocketAddress getLocalSocketAddress() {
                    return new InetSocketAddress(routingContext.request().localAddress().host(), routingContext.request().remoteAddress().port());
                }
            };
        }

        public String getMethod() {
            return this.routingContext.request().method().name();
        }

        public HttpURI getHttpURI() {
            return HttpURI.build((String)this.routingContext.request().absoluteURI());
        }

        public Context getContext() {
            return new Server().getContext();
        }

        public HttpFields getHeaders() {
            HttpFields.Mutable fields = HttpFields.build();
            this.routingContext.request().headers().forEach(entry -> fields.add((String)entry.getKey(), (String)entry.getValue()));
            return fields.asImmutable();
        }

        public void demand(Runnable runnable) {
            throw new UnsupportedOperationException();
        }

        public void fail(Throwable throwable) {
            this.routingContext.fail(throwable);
        }

        public HttpFields getTrailers() {
            throw new UnsupportedOperationException();
        }

        public long getBeginNanoTime() {
            return System.nanoTime();
        }

        public long getHeadersNanoTime() {
            return System.nanoTime();
        }
    }

    private record WrappedResponse(RoutingContext routingContext) implements Response
    {
        public boolean isCommitted() {
            return this.routingContext.response().headWritten();
        }

        public boolean hasLastWrite() {
            throw new UnsupportedOperationException();
        }

        public boolean isCompletedSuccessfully() {
            throw new UnsupportedOperationException();
        }

        public void reset() {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<Void> writeInterim(int i, HttpFields httpFields) {
            throw new UnsupportedOperationException();
        }

        public void write(boolean b, ByteBuffer byteBuffer, Callback callback) {
        }

        public void setStatus(int i) {
            this.routingContext.response().setStatusCode(i);
        }

        public HttpFields.Mutable getHeaders() {
            HttpFields.Mutable fields = HttpFields.build();
            this.routingContext.request().headers().forEach(entry -> fields.add((String)entry.getKey(), (String)entry.getValue()));
            return fields;
        }

        public Supplier<HttpFields> getTrailersSupplier() {
            throw new UnsupportedOperationException();
        }

        public void setTrailersSupplier(Supplier<HttpFields> supplier) {
            throw new UnsupportedOperationException();
        }

        public Request getRequest() {
            throw new UnsupportedOperationException();
        }

        public int getStatus() {
            return this.routingContext.response().getStatusCode();
        }
    }
}

