/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import io.confluent.common.security.jetty.JwtLoginService;
import io.confluent.common.security.jetty.JwtWithFallbackLoginService;
import io.confluent.common.security.jetty.MdsBasicLoginService;
import io.confluent.common.security.jetty.OAuthOrBasicAuthenticator;
import io.confluent.common.security.jetty.initializer.InstallBearerOrBasicSecurityHandler;
import io.confluent.common.security.util.AuthUtils;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtAuthenticator;
import io.confluent.ksql.security.VertxAuthenticationPlugin;
import io.vertx.ext.web.RoutingContext;
import java.security.Principal;
import java.util.Map;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;

public class VertxBearerOrBasicAuthenticationPlugin
extends VertxAuthenticationPlugin {
    @Override
    public void configure(Map<String, ?> config) {
        BasicAuthenticator basicAuthenticator = AuthUtils.getBasicAuthenticatorForNonJettyUsage();
        OAuthOrBasicAuthenticator authenticator = new OAuthOrBasicAuthenticator(basicAuthenticator);
        InstallBearerOrBasicSecurityHandler.BearerConfig bearerConfig = new InstallBearerOrBasicSecurityHandler.BearerConfig(config);
        String realm = bearerConfig.getString("authentication.realm");
        JwtLoginService jwtLoginService = new JwtLoginService(realm, new JwtAuthenticator(bearerConfig.jwtAuthenticatorConfig()));
        MdsBasicLoginService mdsBasicLoginService = new MdsBasicLoginService(config, realm);
        JwtWithFallbackLoginService loginService = new JwtWithFallbackLoginService(jwtLoginService, (LoginService)mdsBasicLoginService);
        this.configure(realm, (Authenticator)authenticator, (LoginService)loginService);
    }

    @Override
    protected boolean validateUser(UserIdentity userIdentity) {
        return true;
    }

    @Override
    protected Principal getPrincipalFromUserIdentity(UserIdentity userIdentity, RoutingContext routingContext) {
        return userIdentity.getUserPrincipal();
    }
}

