/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import io.confluent.common.security.jetty.JwtLoginService;
import io.confluent.common.security.jetty.OAuthBearerAuthenticator;
import io.confluent.common.security.jetty.initializer.InstallOAuthSecurityHandler;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtAuthenticator;
import io.confluent.ksql.security.VertxAuthenticationPlugin;
import io.vertx.ext.web.RoutingContext;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.UserIdentity;

public class VertxOAuthAuthenticationPlugin
extends VertxAuthenticationPlugin {
    List<String> allowedRoles = Collections.emptyList();

    @Override
    public void configure(Map<String, ?> config) {
        InstallOAuthSecurityHandler.OAuthConfig oauthConfig = new InstallOAuthSecurityHandler.OAuthConfig(config);
        String realm = oauthConfig.getString("authentication.realm");
        List authRoles = oauthConfig.getList("authentication.roles");
        this.allowedRoles = authRoles.stream().filter(role -> !"*".equals(role)).map(role -> "**".equals(role) ? "*" : role).collect(Collectors.toList());
        OAuthBearerAuthenticator authenticator = new OAuthBearerAuthenticator();
        JwtLoginService loginService = new JwtLoginService(realm, new JwtAuthenticator(oauthConfig.jwtAuthenticatorConfig()));
        this.configure(realm, (Authenticator)authenticator, (LoginService)loginService);
    }

    @Override
    protected boolean validateUser(UserIdentity userIdentity) {
        if (this.allowedRoles.contains("*")) {
            return true;
        }
        return this.allowedRoles.stream().anyMatch(arg_0 -> ((UserIdentity)userIdentity).isUserInRole(arg_0));
    }

    @Override
    protected Principal getPrincipalFromUserIdentity(UserIdentity userIdentity, RoutingContext routingContext) {
        return userIdentity.getUserPrincipal();
    }
}

