/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.auth;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.security.oauthbearer.HttpRequestFormatter;
import io.confluent.kafka.security.oauthbearer.HttpRequestFormatterFactory;
import io.confluent.ksql.security.Credentials;
import io.confluent.ksql.security.KsqlClientConfig;
import io.confluent.ksql.security.auth.KsqlClientAssertionConfig;
import io.confluent.ksql.security.oauth.CachedOAuthTokenRetriever;
import io.confluent.ksql.security.oauth.OAuthTokenCache;
import io.confluent.ksql.security.ssl.HostSslSocketFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpAccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.LoginAccessTokenValidator;

public class OAuthClientAssertionCredentials
implements Credentials {
    private CachedOAuthTokenRetriever tokenRetriever;

    public void configure(Map<String, ?> configs) {
        ConfigurationUtils configUtils = new ConfigurationUtils(configs);
        CachedOAuthTokenRetriever cachedOAuthTokenRetriever = new CachedOAuthTokenRetriever(this.getAccessTokenRetriever(configUtils, configs), this.getAccessTokenValidator(configs), this.getOAuthTokenCache(configs));
        this.init(cachedOAuthTokenRetriever);
    }

    @VisibleForTesting
    void init(CachedOAuthTokenRetriever tokenRetriever) {
        this.tokenRetriever = tokenRetriever;
    }

    public String getAuthHeader() {
        return "Bearer " + this.retrieveToken();
    }

    public String retrieveToken() {
        return this.tokenRetriever.getToken();
    }

    @VisibleForTesting
    AccessTokenRetriever getAccessTokenRetriever(ConfigurationUtils cu, Map<String, ?> configs) {
        String clientId = cu.validateString("bearer.auth.client.id", false);
        String scope = cu.validateString("bearer.auth.scope", false);
        String clientAssertionIssuer = (String)cu.get("bearer.assertion.claim.iss");
        String clientAssertionLocation = (String)cu.get("bearer.assertion.file");
        if (clientAssertionLocation == null && clientAssertionIssuer == null) {
            throw new ConfigException("Either bearer.assertion.claim.iss or bearer.assertion.file must be set.");
        }
        HttpRequestFormatter httpRequestFormatter = this.getHttpRequestFormatter(clientId, configs);
        Long retryBackoffMs = 100L;
        Long retryBackoffMaxMs = 10000L;
        Integer loginConnectTimeoutMs = null;
        Integer loginReadTimeoutMs = null;
        JaasOptionsUtils jou = new JaasOptionsUtils(KsqlClientConfig.getClientSslConfig(configs));
        HostSslSocketFactory sslSocketFactory = null;
        URL url = cu.validateUrl("bearer.auth.issuer.endpoint.url");
        if (jou.shouldCreateSSLSocketFactory(url)) {
            sslSocketFactory = new HostSslSocketFactory(jou.createSSLSocketFactory(), url.getHost());
        }
        return new HttpAccessTokenRetriever(httpRequestFormatter, scope, (SSLSocketFactory)sslSocketFactory, url.toString(), retryBackoffMs.longValue(), retryBackoffMaxMs.longValue(), loginConnectTimeoutMs, loginReadTimeoutMs);
    }

    private HttpRequestFormatter getHttpRequestFormatter(String clientId, Map<String, ?> configs) {
        KsqlClientAssertionConfig clientAssertionConfig = new KsqlClientAssertionConfig(configs);
        ConfigurationUtils tu = new ConfigurationUtils(clientAssertionConfig.saslClientConfigs());
        HashMap<String, String> jouOptions = new HashMap<String, String>();
        jouOptions.put("clientId", clientId);
        JaasOptionsUtils jou = new JaasOptionsUtils(jouOptions);
        try {
            HttpRequestFormatter httpRequestFormatter = HttpRequestFormatterFactory.create((ConfigurationUtils)tu, (JaasOptionsUtils)jou);
            return httpRequestFormatter;
        }
        catch (ConfigException e) {
            String m = e.getMessage();
            String finalMessage = m.replaceFirst("sasl\\.oauth", "");
            throw new ConfigException(finalMessage);
        }
    }

    private AccessTokenValidator getAccessTokenValidator(Map<String, ?> configs) {
        String scopeClaimName = KsqlClientConfig.getBearerAuthScopeClaimName(configs);
        String subClaimName = KsqlClientConfig.getBearerAuthSubClaimName(configs);
        return new LoginAccessTokenValidator(scopeClaimName, subClaimName);
    }

    private OAuthTokenCache getOAuthTokenCache(Map<String, ?> configs) {
        short cacheExpiryBufferSeconds = KsqlClientConfig.getBearerAuthCacheExpiryBufferSeconds(configs);
        return new OAuthTokenCache(cacheExpiryBufferSeconds);
    }
}

