/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.auth;

import io.confluent.ksql.security.AuthType;
import io.confluent.ksql.security.auth.KsqlClientAssertionConfig;
import io.confluent.ksql.security.auth.OAuthClientAssertionCredentials;
import io.confluent.ksql.security.oauth.IdpConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class OAuthClientAssertionIdpConfig
implements IdpConfig {
    private String idpTokenEndpointUrl = "";
    private String idpClientId = "";
    private String idpClientAssertionIssuer = "";
    private String idpClientAssertionSubject = "";
    private String idpClientAssertionAudience = "";
    private Boolean idpIncludeJtiClaim = false;
    private Boolean idpIncludeNbfClaim = false;
    private String idpClientAssertionPrivateKey = "";
    private String idpClientAssertionPrivateKeyPassphrase = "";
    private String idpScope = "";
    private String idpScopeClaimName = "scope";
    private String idpSubClaimName = "sub";
    private Short idpCacheExpiryBufferSeconds = 300;

    public AuthType getAuthType() {
        return AuthType.CUSTOM;
    }

    public String getAuthenticationMethod() {
        return "CLIENT_ASSERTION";
    }

    public Map<String, Object> toIdpCredentialsConfig() {
        HashMap<String, Object> mp = new HashMap<String, Object>();
        mp.put("bearer.auth.issuer.endpoint.url", this.idpTokenEndpointUrl);
        mp.put("bearer.auth.client.id", this.idpClientId);
        mp.put("bearer.assertion.claim.iss", this.idpClientAssertionIssuer);
        mp.put("bearer.assertion.claim.sub", this.idpClientAssertionSubject);
        mp.put("bearer.assertion.claim.aud", this.idpClientAssertionAudience);
        mp.put("bearer.assertion.claim.jti.include", this.idpIncludeJtiClaim);
        mp.put("bearer.assertion.claim.nbf.include", this.idpIncludeNbfClaim);
        mp.put("bearer.assertion.private.key.file", this.idpClientAssertionPrivateKey);
        if (!this.idpClientAssertionPrivateKeyPassphrase.isEmpty()) {
            mp.put("bearer.assertion.private.key.passphrase", this.idpClientAssertionPrivateKeyPassphrase);
        }
        mp.put("bearer.auth.scope", this.idpScope);
        mp.put("bearer.auth.scope.claim.name", this.idpScopeClaimName);
        mp.put("bearer.auth.sub.claim.name", this.idpSubClaimName);
        mp.put("bearer.auth.cache.expiry.buffer.seconds", this.idpCacheExpiryBufferSeconds);
        mp.put("custom.token.credentials.class", OAuthClientAssertionCredentials.class.getName());
        return mp;
    }

    public void configure(Map<String, ?> configs) {
        KsqlClientAssertionConfig ksqlClientAssertionConfig = new KsqlClientAssertionConfig(configs);
        this.idpTokenEndpointUrl = (String)configs.get("bearer.auth.issuer.endpoint.url");
        this.idpClientId = (String)configs.get("bearer.auth.client.id");
        this.idpClientAssertionIssuer = ksqlClientAssertionConfig.getString("bearer.assertion.claim.iss");
        this.idpClientAssertionSubject = ksqlClientAssertionConfig.getString("bearer.assertion.claim.sub");
        this.idpClientAssertionAudience = ksqlClientAssertionConfig.getString("bearer.assertion.claim.aud");
        this.idpClientAssertionPrivateKey = ksqlClientAssertionConfig.getString("bearer.assertion.private.key.file");
        if (ksqlClientAssertionConfig.getPassword("bearer.assertion.private.key.passphrase") != null) {
            this.idpClientAssertionPrivateKeyPassphrase = ksqlClientAssertionConfig.getPassword("bearer.assertion.private.key.passphrase").value();
        }
        this.idpScope = (String)configs.get("bearer.auth.scope");
        if (configs.get("bearer.auth.scope.claim.name") != null) {
            this.idpScopeClaimName = (String)configs.get("bearer.auth.scope.claim.name");
        }
        if (configs.get("bearer.auth.sub.claim.name") != null) {
            this.idpSubClaimName = (String)configs.get("bearer.auth.sub.claim.name");
        }
        if (configs.get("bearer.auth.cache.expiry.buffer.seconds") != null) {
            this.idpCacheExpiryBufferSeconds = (Short)configs.get("bearer.auth.cache.expiry.buffer.seconds");
        }
    }

    public String getIdpTokenEndpointUrl() {
        return this.idpTokenEndpointUrl;
    }

    public String getIdpClientId() {
        return this.idpClientId;
    }

    public String getIdpClientAssertionIssuer() {
        return this.idpClientAssertionIssuer;
    }

    public String getIdpClientAssertionSubject() {
        return this.idpClientAssertionSubject;
    }

    public String getIdpClientAssertionAudience() {
        return this.idpClientAssertionAudience;
    }

    public Boolean getIdpIncludeJtiClaim() {
        return this.idpIncludeJtiClaim;
    }

    public Boolean getIdpIncludeNbfClaim() {
        return this.idpIncludeNbfClaim;
    }

    public String getIdpClientAssertionPrivateKey() {
        return this.idpClientAssertionPrivateKey;
    }

    public String getIdpClientAssertionPrivateKeyPassphrase() {
        return this.idpClientAssertionPrivateKeyPassphrase;
    }

    public String getIdpScope() {
        return this.idpScope;
    }

    public String getIdpScopeClaimName() {
        return this.idpScopeClaimName;
    }

    public String getIdpSubClaimName() {
        return this.idpSubClaimName;
    }

    public Short getIdpCacheExpiryBufferSeconds() {
        return this.idpCacheExpiryBufferSeconds;
    }

    public OAuthClientAssertionIdpConfig copy() {
        return new Builder().withTokenEndpointUrl(this.idpTokenEndpointUrl).withClientId(this.idpClientId).withClientAssertionIssuer(this.idpClientAssertionIssuer).withClientAssertionSubject(this.idpClientAssertionSubject).withClientAssertionAudience(this.idpClientAssertionAudience).withIncludeJtiClaim(this.idpIncludeJtiClaim).withIncludeNbfClaim(this.idpIncludeNbfClaim).withClientAssertionPrivateKey(this.idpClientAssertionPrivateKey).withClientAssertionPrivateKeyPassphrase(this.idpClientAssertionPrivateKeyPassphrase).withScope(this.idpScope).withScopeClaimName(this.idpScopeClaimName).withSubClaimName(this.idpSubClaimName).withCacheExpiryBufferSeconds(this.idpCacheExpiryBufferSeconds).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuthClientAssertionIdpConfig)) {
            return false;
        }
        OAuthClientAssertionIdpConfig oauthClientAssertionIdpConfig = (OAuthClientAssertionIdpConfig)o;
        return this.compareBasicFields(oauthClientAssertionIdpConfig) && this.compareAssertionFields(oauthClientAssertionIdpConfig) && this.compareClaimFields(oauthClientAssertionIdpConfig);
    }

    private boolean compareBasicFields(OAuthClientAssertionIdpConfig other) {
        return Objects.equals(this.idpTokenEndpointUrl, other.idpTokenEndpointUrl) && Objects.equals(this.idpClientId, other.idpClientId) && Objects.equals(this.idpScope, other.idpScope) && Objects.equals(this.idpCacheExpiryBufferSeconds, other.idpCacheExpiryBufferSeconds);
    }

    private boolean compareAssertionFields(OAuthClientAssertionIdpConfig other) {
        return Objects.equals(this.idpClientAssertionIssuer, other.idpClientAssertionIssuer) && Objects.equals(this.idpClientAssertionSubject, other.idpClientAssertionSubject) && Objects.equals(this.idpClientAssertionAudience, other.idpClientAssertionAudience) && this.comparePrivateKeyFields(other);
    }

    private boolean comparePrivateKeyFields(OAuthClientAssertionIdpConfig other) {
        return Objects.equals(this.idpClientAssertionPrivateKey, other.idpClientAssertionPrivateKey) && Objects.equals(this.idpClientAssertionPrivateKeyPassphrase, other.idpClientAssertionPrivateKeyPassphrase);
    }

    private boolean compareClaimFields(OAuthClientAssertionIdpConfig other) {
        return Objects.equals(this.idpIncludeJtiClaim, other.idpIncludeJtiClaim) && Objects.equals(this.idpIncludeNbfClaim, other.idpIncludeNbfClaim) && Objects.equals(this.idpScopeClaimName, other.idpScopeClaimName) && Objects.equals(this.idpSubClaimName, other.idpSubClaimName);
    }

    public int hashCode() {
        return Objects.hash(this.idpTokenEndpointUrl, this.idpClientId, this.idpClientAssertionIssuer, this.idpClientAssertionSubject, this.idpClientAssertionAudience, this.idpIncludeJtiClaim, this.idpIncludeJtiClaim, this.idpClientAssertionPrivateKey, this.idpClientAssertionPrivateKeyPassphrase, this.idpScope, this.idpScopeClaimName, this.idpSubClaimName, this.idpCacheExpiryBufferSeconds);
    }

    public String toString() {
        return "IdpConfig{idpTokenEndpointUrl='" + this.idpTokenEndpointUrl + "', idpClientId='" + this.idpClientId + "', idpClientAssertionIssuer='" + this.idpClientAssertionIssuer + "', idpClientAssertionSubject='" + this.idpClientAssertionSubject + "', idpClientAssertionAudience='" + this.idpClientAssertionAudience + "', idpIncludeJtiClaim=" + this.idpIncludeJtiClaim + ", idpIncludeNbfClaim=" + this.idpIncludeNbfClaim + ", idpClientAssertionPrivateKey='" + this.idpClientAssertionPrivateKey + "', idpScope='" + this.idpScope + "', idpScopeClaimName='" + this.idpScopeClaimName + "', idpSubClaimName='" + this.idpSubClaimName + "', idpCacheExpiryBufferSeconds=" + this.idpCacheExpiryBufferSeconds + "}";
    }

    public static class Builder {
        private final OAuthClientAssertionIdpConfig config = new OAuthClientAssertionIdpConfig();

        public Builder withTokenEndpointUrl(String url) {
            this.config.idpTokenEndpointUrl = url;
            return this;
        }

        public Builder withClientId(String clientId) {
            this.config.idpClientId = clientId;
            return this;
        }

        public Builder withClientAssertionIssuer(String clientAssertionIssuer) {
            this.config.idpClientAssertionIssuer = clientAssertionIssuer;
            return this;
        }

        public Builder withClientAssertionSubject(String clientAssertionSubject) {
            this.config.idpClientAssertionSubject = clientAssertionSubject;
            return this;
        }

        public Builder withClientAssertionAudience(String clientAssertionAudience) {
            this.config.idpClientAssertionAudience = clientAssertionAudience;
            return this;
        }

        public Builder withIncludeJtiClaim(Boolean includeJtiClaim) {
            this.config.idpIncludeJtiClaim = includeJtiClaim;
            return this;
        }

        public Builder withIncludeNbfClaim(Boolean includeNbfClaim) {
            this.config.idpIncludeNbfClaim = includeNbfClaim;
            return this;
        }

        public Builder withClientAssertionPrivateKey(String clientAssertionPrivateKey) {
            this.config.idpClientAssertionPrivateKey = clientAssertionPrivateKey;
            return this;
        }

        public Builder withClientAssertionPrivateKeyPassphrase(String clientAssertionPrivateKeyPassphrase) {
            this.config.idpClientAssertionPrivateKeyPassphrase = clientAssertionPrivateKeyPassphrase;
            return this;
        }

        public Builder withScope(String scope) {
            this.config.idpScope = scope;
            return this;
        }

        public Builder withScopeClaimName(String scopeClaimName) {
            this.config.idpScopeClaimName = scopeClaimName;
            return this;
        }

        public Builder withSubClaimName(String subClaimName) {
            this.config.idpSubClaimName = subClaimName;
            return this;
        }

        public Builder withCacheExpiryBufferSeconds(Short cacheExpiryBufferSeconds) {
            this.config.idpCacheExpiryBufferSeconds = cacheExpiryBufferSeconds;
            return this;
        }

        public OAuthClientAssertionIdpConfig build() {
            return this.config;
        }
    }
}

