/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.ksql.schema.registry.KsqlSchemaRegistryClientFactory;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class KsqlSchemaRegistryRestService {
    private static final Map<String, String> DEFAULT_REQUEST_PROPERTIES = Collections.singletonMap("Content-Type", "application/vnd.schemaregistry.v1+json");
    private final RestService restService;

    public KsqlSchemaRegistryRestService(KsqlConfig config, Map<String, String> headers) {
        this(KsqlSchemaRegistryRestService.newRestService(config, headers));
    }

    @VisibleForTesting
    KsqlSchemaRegistryRestService(RestService restService) {
        this.restService = Objects.requireNonNull(restService, "restService");
    }

    public <T> T httpRequest(String path, String method, byte[] requestBodyData, TypeReference<T> responseFormat) throws RestClientException, IOException {
        return (T)this.restService.httpRequest(path, method, requestBodyData, DEFAULT_REQUEST_PROPERTIES, responseFormat);
    }

    private static RestService newRestService(KsqlConfig config, Map<String, String> headers) {
        SchemaRegistryClient client = new KsqlSchemaRegistryClientFactory(config, headers).get();
        if (!(client instanceof CachedSchemaRegistryClient)) {
            throw new KsqlException("Schema Registry is not correctly configured");
        }
        try {
            Field field = CachedSchemaRegistryClient.class.getDeclaredField("restService");
            field.setAccessible(true);
            return (RestService)field.get(client);
        }
        catch (Exception e) {
            throw new KsqlException("Could not access to the 'restService' object from the Schema Registry client. This may be caused by an unnoticed change in the Schema Registry API.", (Throwable)e);
        }
    }
}

