/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.license;

import io.confluent.common.security.license.ComponentBrokerCompatibilityLogger;
import io.confluent.common.security.license.MultiLicenseBrokerHandler;
import io.confluent.license.InvalidLicenseException;
import io.confluent.license.License;
import io.confluent.license.kafka.BrokerDetectionException;
import io.confluent.license.kafka.BrokerType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlLicenseEventLogger
extends ComponentBrokerCompatibilityLogger {
    private static final Logger log = LoggerFactory.getLogger(KsqlLicenseEventLogger.class);

    public KsqlLicenseEventLogger(MultiLicenseBrokerHandler handler) {
        super(handler);
        log.info("KsqlLicenseEventLogger instantiated.");
    }

    private void handleLoggingForIncompatibleLicense() {
        log.warn("Your license for Customer-Managed Confluent Platform for Confluent Cloud may be used solely to access and use the Cloud Service. When operating under this specific license, Confluent does not provide support for any self-managed (Confluent Platform) components utilised exclusively for Confluent Platform broker use cases. To be eligible for support, you must ensure you are connecting to a Confluent Cloud broker or are utilising a valid Enterprise license for a Confluent Platform subscription.");
    }

    public void onLicenseValidationFailure(InvalidLicenseException exception) {
        log.warn("No Valid Enterprise license detected. Confluent does not provide Enterprise support for any self-managed (Confluent Platform) components without a valid Enterprise license.");
    }

    public void onBrokerDetectionException(BrokerDetectionException e) {
        log.warn(e.getMessage());
        this.handleLoggingForIncompatibleLicense();
    }

    public void onIncompatibleLicenseDetected(List<License> licenses, BrokerType brokerType) {
        this.handleLoggingForIncompatibleLicense();
    }
}

