/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.license;

import io.confluent.common.security.license.LicenseEventListener;
import io.confluent.common.security.license.MultiLicenseBrokerHandler;
import io.confluent.ksql.security.KsqlResourceExtension;
import io.confluent.ksql.security.license.KsqlLicenseEventLogger;
import io.confluent.ksql.security.license.KsqlLicenseValidatorExtensionConfig;
import io.confluent.ksql.util.KsqlConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlLicenseValidatorExtension
implements KsqlResourceExtension {
    private static final Logger log = LoggerFactory.getLogger(KsqlLicenseValidatorExtension.class);
    private MultiLicenseBrokerHandler licenseBackgroundHandler;

    public void register(KsqlConfig ksqlConfig) {
        log.info("Registering KsqlLicenseValidatorExtension...");
        try {
            KsqlLicenseValidatorExtensionConfig ksqlLicenseValidatorExtensionConfig = new KsqlLicenseValidatorExtensionConfig(ksqlConfig.originals());
            this.licenseBackgroundHandler = new MultiLicenseBrokerHandler(ksqlLicenseValidatorExtensionConfig.licenseTopic(), ksqlLicenseValidatorExtensionConfig.licenseProducerConfigs(), ksqlLicenseValidatorExtensionConfig.licenseConsumerConfigs(), ksqlLicenseValidatorExtensionConfig.licenseAdminConfigs(), ksqlLicenseValidatorExtensionConfig.licenseString());
            KsqlLicenseEventLogger licenseEventLogger = new KsqlLicenseEventLogger(this.licenseBackgroundHandler);
            this.licenseBackgroundHandler.addListener((LicenseEventListener)licenseEventLogger);
            log.info("Starting MultiLicenseBackgroundFetcher...");
            this.licenseBackgroundHandler.startAsync();
            log.info("KsqlLicenseValidatorExtension registered successfully.");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register KsqlLicenseValidatorExtension", e);
        }
    }

    public void close() {
        log.info("Cleaning up KsqlLicenseValidatorExtension...");
        if (this.licenseBackgroundHandler != null) {
            try {
                log.info("Stopping MultiLicenseBackgroundFetcher...");
                this.licenseBackgroundHandler.stopAsync();
                log.info("MultiLicenseBackgroundFetcher stopped.");
            }
            catch (Exception e) {
                log.error("Error while stopping MultiLicenseBackgroundFetcher", (Throwable)e);
            }
        } else {
            log.warn("MultiLicenseBackgroundFetcher was not initialized; nothing to clean.");
        }
    }
}

