/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.license;

import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class KsqlLicenseValidatorExtensionConfig
extends AbstractConfig {
    public static final String KAFKASTORE_PREFIX = "kafkastore.";
    public static final String CONFLUENT_LICENSE_CONFIG = "confluent.license";
    public static final String CONFLUENT_LICENSE_DEFAULT = "";
    protected static final String CONFLUENT_LICENSE_DOC = "Confluent will issue a license key to each subscriber. The license key will be a short snippet of text that you can copy and paste. Without the license key, you can use Confluent Security Plugins for a 30-day trial period. If you are a subscriber and don't have a license key, please contact Confluent Support at support@confluent.io.";
    public static final String CONFLUENT_TOPIC_CONFIG = "confluent.license.topic";
    public static final String CONFLUENT_TOPIC_DEFAULT = "_confluent-license";
    public static final String CONFLUENT_TOPIC_DOC = "Topic used for storing Confluent license";
    public static final String LICENSE_CONFIG_PREFIX = "confluent.license.";
    public static final String CONFLUENT_TOPIC_PRODUCER_PREFIX = "confluent.license.producer.";
    public static final String CONFLUENT_TOPIC_CONSUMER_PREFIX = "confluent.license.consumer.";
    public static final String CONFLUENT_TOPIC_ADMIN_PREFIX = "confluent.license.admin.";
    private static final ConfigDef confluentConfigDef = KsqlLicenseValidatorExtensionConfig.initConfigDef();

    public String licenseString() {
        return this.getPassword(CONFLUENT_LICENSE_CONFIG).value();
    }

    public String licenseTopic() {
        return this.getString(CONFLUENT_TOPIC_CONFIG);
    }

    private Map<String, Object> getKafkaConnectionProps() {
        Map props = this.originals();
        props.putAll(this.originalsWithPrefix(KAFKASTORE_PREFIX));
        props.putAll(this.originalsWithPrefix(LICENSE_CONFIG_PREFIX));
        props.putIfAbsent("bootstrap.servers", this.bootstrapBrokers());
        return props;
    }

    private String bootstrapBrokers() {
        return this.getString("bootstrap.servers");
    }

    public Map<String, Object> getKafkaConnectionPropsWithConsumerConfigs() {
        Map<String, Object> props = this.getKafkaConnectionProps();
        props.putAll(this.originalsWithPrefix(CONFLUENT_TOPIC_CONSUMER_PREFIX));
        return props;
    }

    public Map<String, Object> licenseProducerConfigs() {
        Map<String, Object> producerProperties = this.getKafkaConnectionProps();
        producerProperties.putAll(this.originalsWithPrefix(CONFLUENT_TOPIC_PRODUCER_PREFIX));
        producerProperties.put("client.id", "confluent-license-producer");
        return producerProperties;
    }

    public Map<String, Object> licenseConsumerConfigs() {
        Map<String, Object> consumerProperties = this.getKafkaConnectionProps();
        consumerProperties.putAll(this.originalsWithPrefix(CONFLUENT_TOPIC_CONSUMER_PREFIX));
        consumerProperties.put("client.id", "confluent-license-consumer");
        consumerProperties.putAll(this.originalsWithPrefix("client.", true));
        consumerProperties.putAll(this.originalsWithPrefix("consumer.", true));
        return consumerProperties;
    }

    public Map<String, Object> licenseAdminConfigs() {
        Map<String, Object> adminProperties = this.getKafkaConnectionProps();
        adminProperties.putAll(this.originalsWithPrefix(CONFLUENT_TOPIC_ADMIN_PREFIX));
        adminProperties.put("client.id", "confluent-license-admin");
        return adminProperties;
    }

    public KsqlLicenseValidatorExtensionConfig(Map<?, ?> configs) {
        super(confluentConfigDef, configs);
    }

    private static ConfigDef initConfigDef() {
        return new ConfigDef().define(CONFLUENT_LICENSE_CONFIG, ConfigDef.Type.PASSWORD, (Object)CONFLUENT_LICENSE_DEFAULT, ConfigDef.Importance.HIGH, CONFLUENT_LICENSE_DOC).define(CONFLUENT_TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)CONFLUENT_TOPIC_DEFAULT, ConfigDef.Importance.HIGH, CONFLUENT_TOPIC_DOC).define("bootstrap.servers", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.HIGH, "A list of host/port pairs used to establish the initial connection to the Kafka cluster. Clients use this list to bootstrap and discover the full set of Kafka brokers. While the order of servers in the list does not matter, we recommend including more than one server to ensure resilience if any servers are down. This list does not need to contain the entire set of brokers, as Kafka clients automatically manage and update connections to the cluster efficiently. This list must be in the form <code>host1:port1,host2:port2,...</code>.");
    }
}

