/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.configdef;

import io.confluent.ksql.util.KsqlConfig;
import java.net.URL;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public final class ConfigValidators {
    private ConfigValidators() {
    }

    public static ConfigDef.Validator parses(Function<String, ?> parser) {
        return (name, val) -> {
            if (val != null && !(val instanceof String)) {
                throw new IllegalArgumentException("validator should only be used with STRING defs");
            }
            try {
                parser.apply((String)val);
            }
            catch (Exception e) {
                throw new ConfigException("Configuration " + name + " is invalid: " + e.getMessage());
            }
        };
    }

    public static ConfigDef.Validator nullsAllowed(ConfigDef.Validator delegate) {
        return (name, value) -> {
            if (value == null) {
                return;
            }
            delegate.ensureValid(name, value);
        };
    }

    public static <T extends Enum<T>> ConfigDef.Validator enumValues(Class<T> enumClass) {
        String[] enumValues = (String[])EnumSet.allOf(enumClass).stream().map(Object::toString).toArray(String[]::new);
        String[] validValues = Arrays.copyOf(enumValues, enumValues.length + 1);
        validValues[enumValues.length] = null;
        return ValidCaseInsensitiveString.in(validValues);
    }

    public static ConfigDef.Validator validUrl() {
        return (name, val) -> {
            if (!(val instanceof String)) {
                throw new IllegalArgumentException("validator should only be used with STRING defs");
            }
            try {
                new URL((String)val);
            }
            catch (Exception e) {
                throw new ConfigException(name, val, "Not valid URL: " + e.getMessage());
            }
        };
    }

    public static ConfigDef.Validator validRegex() {
        return (name, val) -> {
            if (!(val instanceof List)) {
                throw new IllegalArgumentException("validator should only be used with LIST of STRING defs");
            }
            StringBuilder regexBuilder = new StringBuilder();
            for (Object item : (List)val) {
                if (!(item instanceof String)) {
                    throw new IllegalArgumentException("validator should only be used with LIST of STRING defs");
                }
                if (regexBuilder.length() > 0) {
                    regexBuilder.append("|");
                }
                regexBuilder.append((String)item);
            }
            try {
                Pattern.compile(regexBuilder.toString());
            }
            catch (Exception e) {
                throw new ConfigException(name, val, "Not valid regular expression: " + e.getMessage());
            }
        };
    }

    public static ConfigDef.Validator zeroOrPositive() {
        return (name, val) -> {
            if (val instanceof Long) {
                if ((Long)val < 0L) {
                    throw new ConfigException(name, val, "Not >= 0");
                }
            } else if (val instanceof Integer) {
                if ((Integer)val < 0) {
                    throw new ConfigException(name, val, "Not >= 0");
                }
            } else {
                throw new IllegalArgumentException("validator should only be used with int, long");
            }
        };
    }

    public static ConfigDef.Validator oneOrMore() {
        return (name, val) -> {
            if (val instanceof Long) {
                if ((Long)val < 1L) {
                    throw new ConfigException(name, val, "Not >= 1");
                }
            } else if (val instanceof Integer) {
                if ((Integer)val < 1) {
                    throw new ConfigException(name, val, "Not >= 1");
                }
            } else {
                throw new IllegalArgumentException("validator should only be used with int, long");
            }
        };
    }

    public static ConfigDef.Validator intList() {
        return (name, val) -> {
            if (!(val instanceof List)) {
                throw new ConfigException(name, val, "Must be a list");
            }
            List list = (List)val;
            list.forEach(intStr -> {
                try {
                    Integer.parseInt(intStr);
                }
                catch (NumberFormatException e) {
                    throw new ConfigException(name, intStr, "Not an integer");
                }
            });
        };
    }

    public static ConfigDef.Validator mapWithIntKeyDoubleValue() {
        return (name, val) -> {
            if (!(val instanceof String)) {
                throw new ConfigException(name, val, "Must be a string");
            }
            String str = (String)val;
            Map<String, String> map = KsqlConfig.parseStringAsMap(name, str);
            map.forEach((keyStr, valueStr) -> {
                try {
                    Integer.parseInt(keyStr);
                }
                catch (NumberFormatException e) {
                    throw new ConfigException(name, keyStr, "Not an int");
                }
                try {
                    Double.parseDouble(valueStr);
                }
                catch (NumberFormatException e) {
                    throw new ConfigException(name, valueStr, "Not a double");
                }
            });
        };
    }

    public static ConfigDef.Validator mapWithDoubleValue() {
        return (name, val) -> {
            if (!(val instanceof String)) {
                throw new ConfigException(name, val, "Must be a string");
            }
            String str = (String)val;
            Map<String, String> map = KsqlConfig.parseStringAsMap(name, str);
            map.forEach((k, valueStr) -> {
                try {
                    Double.parseDouble(valueStr);
                }
                catch (NumberFormatException e) {
                    throw new ConfigException(name, valueStr, "Not a double");
                }
            });
        };
    }

    public static final class ValidCaseInsensitiveString
    implements ConfigDef.Validator {
        private final List<String> validStrings;

        private ValidCaseInsensitiveString(String ... validStrings) {
            this.validStrings = Arrays.stream(Objects.requireNonNull(validStrings, "validStrings")).map(v -> v == null ? null : v.toUpperCase()).collect(Collectors.toList());
        }

        public static ValidCaseInsensitiveString in(String ... validStrings) {
            return new ValidCaseInsensitiveString(validStrings);
        }

        public void ensureValid(String name, Object value) {
            String s = (String)value;
            if (!this.validStrings.contains(s == null ? null : s.toUpperCase())) {
                throw new ConfigException(name, value, "String must be one of: " + String.join((CharSequence)", ", this.validStrings));
            }
        }

        public String toString() {
            return "[" + String.join((CharSequence)", ", this.validStrings) + "]";
        }
    }
}

