/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import io.confluent.ksql.function.KsqlScalarFunction;
import io.confluent.ksql.function.UdfIndex;
import io.confluent.ksql.function.udf.Kudf;
import io.confluent.ksql.function.udf.UdfMetadata;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class UdfFactory {
    private final UdfMetadata metadata;
    private final Class<? extends Kudf> udfClass;
    private final UdfIndex<KsqlScalarFunction> udfIndex;

    UdfFactory(Class<? extends Kudf> udfClass, UdfMetadata metadata) {
        this.udfClass = Objects.requireNonNull(udfClass, "udfClass can't be null");
        this.metadata = Objects.requireNonNull(metadata, "metadata can't be null");
        this.udfIndex = new UdfIndex(metadata.getName(), true);
    }

    synchronized void addFunction(KsqlScalarFunction ksqlFunction) {
        this.checkCompatible(ksqlFunction);
        this.udfIndex.addFunction(ksqlFunction);
    }

    private void checkCompatible(KsqlScalarFunction ksqlFunction) {
        if (this.udfClass != ksqlFunction.getKudfClass()) {
            throw new KsqlException("Can't add function " + String.valueOf(ksqlFunction) + " as a function with the same name exists in a different " + String.valueOf(this.udfClass));
        }
        if (!ksqlFunction.getPathLoadedFrom().equals(this.metadata.getPath())) {
            throw new KsqlException("Can't add function " + String.valueOf(ksqlFunction) + "as a function with the same name has been loaded from a different jar " + this.metadata.getPath());
        }
    }

    public UdfMetadata getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return this.metadata.getName();
    }

    public synchronized void eachFunction(Consumer<KsqlScalarFunction> consumer) {
        this.udfIndex.values().forEach(consumer);
    }

    public boolean matches(UdfFactory that) {
        return this == that || this.udfClass.equals(that.udfClass) && this.metadata.equals(that.metadata);
    }

    public String toString() {
        return "UdfFactory{metadata=" + String.valueOf(this.metadata) + ", udfClass=" + String.valueOf(this.udfClass) + ", udfIndex=" + String.valueOf(this.udfIndex) + "}";
    }

    public synchronized KsqlScalarFunction getFunction(List<SqlArgument> argTypes) {
        return this.udfIndex.getFunction(argTypes);
    }
}

