/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.function.FunctionSignature;
import io.confluent.ksql.function.GenericsUtil;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.ParameterInfo;
import io.confluent.ksql.function.types.ArrayType;
import io.confluent.ksql.function.types.GenericType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.types.ParamTypes;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UdfIndex<T extends FunctionSignature> {
    private static final Logger LOG = LogManager.getLogger(UdfIndex.class);
    private static final ParamType OBJ_VAR_ARG = ArrayType.of(ParamTypes.ANY);
    private final String udfName;
    private final Node root = new Node();
    private final Map<List<ParamType>, T> allFunctions;
    private final boolean supportsImplicitCasts;

    UdfIndex(String udfName, boolean supportsImplicitCasts) {
        this.udfName = Objects.requireNonNull(udfName, "udfName");
        this.allFunctions = new HashMap<List<ParamType>, T>();
        this.supportsImplicitCasts = supportsImplicitCasts;
    }

    void addFunction(T function) {
        List<ParameterInfo> parameters = function.parameterInfo();
        if (this.allFunctions.put(function.parameters(), function) != null) {
            throw new KsqlFunctionException("Can't add function " + String.valueOf(function.name()) + " with parameters " + String.valueOf(function.parameters()) + " as a function with the same name and parameter types already exists " + String.valueOf(this.allFunctions.get(function.parameters())));
        }
        Pair<Node, Integer> variadicParentAndOffset = this.buildTree(this.root, parameters, function, false, false);
        Node variadicParent = variadicParentAndOffset.getLeft();
        if (variadicParent != null) {
            int toIndex;
            int fromIndex;
            int offset = variadicParentAndOffset.getRight();
            this.buildTree(variadicParent, parameters, function, true, false);
            boolean isLeftVariadic = parameters.get(offset).isVariadic();
            List<ParameterInfo> paramsWithoutVariadic = isLeftVariadic ? parameters.subList(offset + 1, parameters.size() - offset) : parameters.subList(offset, parameters.size() - offset - 1);
            this.buildTree(variadicParent, paramsWithoutVariadic, function, false, false);
            ParameterInfo variadicParam = isLeftVariadic ? parameters.get(offset) : parameters.get(parameters.size() - offset - 1);
            int maxAddedVariadics = paramsWithoutVariadic.size() + 1;
            List<ParameterInfo> addedVariadics = Collections.nCopies(maxAddedVariadics, variadicParam);
            ArrayList<ParameterInfo> combinedAllParams = new ArrayList<ParameterInfo>();
            if (isLeftVariadic) {
                combinedAllParams.addAll(addedVariadics);
                combinedAllParams.addAll(paramsWithoutVariadic);
                fromIndex = maxAddedVariadics - 1;
                toIndex = combinedAllParams.size();
            } else {
                combinedAllParams.addAll(paramsWithoutVariadic);
                combinedAllParams.addAll(addedVariadics);
                fromIndex = 0;
                toIndex = combinedAllParams.size() - maxAddedVariadics + 1;
            }
            while (fromIndex >= 0 && toIndex <= combinedAllParams.size()) {
                this.buildTree(variadicParent, combinedAllParams.subList(fromIndex, toIndex), function, false, toIndex - fromIndex == combinedAllParams.size());
                if (isLeftVariadic) {
                    --fromIndex;
                    continue;
                }
                ++toIndex;
            }
        }
    }

    T getFunction(List<SqlArgument> arguments) {
        Optional<T> candidate = this.findMatchingCandidate(arguments, false);
        if (candidate.isPresent()) {
            return (T)((FunctionSignature)candidate.get());
        }
        if (!this.supportsImplicitCasts) {
            throw this.createNoMatchingFunctionException(arguments);
        }
        candidate = this.findMatchingCandidate(arguments, true);
        if (candidate.isPresent()) {
            return (T)((FunctionSignature)candidate.get());
        }
        throw this.createNoMatchingFunctionException(arguments);
    }

    private Pair<Node, Integer> buildTree(Node root, List<ParameterInfo> parameters, T function, boolean keepArrays, boolean appendVariadicLoop) {
        Node curr;
        int rightStartIndex = parameters.size() - 1;
        Node parent = curr = root;
        Node parentOfVariadic = null;
        int variadicOffset = -1;
        for (int offset = 0; offset < this.indexAfterCenter(parameters.size()); ++offset) {
            ParameterInfo leftParamInfo = parameters.get(offset);
            int rightParamIndex = rightStartIndex - offset;
            ParameterInfo rightParamInfo = parameters.get(rightParamIndex);
            Parameter leftParam = new Parameter(this.toType(leftParamInfo, keepArrays), false);
            Parameter rightParam = offset == rightParamIndex ? null : new Parameter(this.toType(rightParamInfo, keepArrays), false);
            parent = curr;
            curr = curr.children.computeIfAbsent(Pair.of(leftParam, rightParam), ignored -> new Node());
            if (!leftParamInfo.isVariadic() && !rightParamInfo.isVariadic()) continue;
            parentOfVariadic = parent;
            variadicOffset = offset;
        }
        if (appendVariadicLoop) {
            if (variadicOffset < 0) {
                throw new IllegalStateException(String.format("appendVariadicLoop was set for a function named %s with parameters %s. The actual parameter types being used to build the tree were %s.", function.name(), function.parameterInfo(), parameters));
            }
            ParamType varArgSchema = this.toType(parameters.get(variadicOffset), keepArrays);
            Parameter varArg = new Parameter(varArgSchema, true);
            Node loop = parent.children.computeIfAbsent(Pair.of(varArg, varArg), ignored -> new Node());
            loop.update(function);
            loop.children.putIfAbsent(Pair.of(varArg, varArg), loop);
            Node leaf = loop.children.computeIfAbsent(Pair.of(varArg, null), ignored -> new Node());
            leaf.update(function);
        }
        curr.update(function);
        return Pair.of(parentOfVariadic, variadicOffset);
    }

    private int indexAfterCenter(int size) {
        return (size + 1) / 2;
    }

    private ParamType toType(ParameterInfo info, boolean keepArrays) {
        return info.isVariadic() && !keepArrays ? ((ArrayType)info.type()).element() : info.type();
    }

    private Optional<T> findMatchingCandidate(List<SqlArgument> arguments, boolean allowCasts) {
        ArrayList<Node> candidates = new ArrayList<Node>();
        this.getCandidates(arguments, 0, this.root, candidates, new HashMap<GenericType, SqlType>(), allowCasts);
        candidates.sort(Node::compare);
        int len = candidates.size();
        if (len == 1) {
            return Optional.of(((Node)candidates.get((int)0)).value);
        }
        if (len > 1) {
            if (((Node)candidates.get(len - 1)).compare((Node)candidates.get(len - 2)) > 0) {
                return Optional.of(((Node)candidates.get((int)(len - 1))).value);
            }
            throw this.createVagueImplicitCastException(arguments);
        }
        return Optional.empty();
    }

    private void getCandidates(List<SqlArgument> arguments, int argOffset, Node current, List<Node> candidates, Map<GenericType, SqlType> reservedGenerics, boolean allowCasts) {
        int rightArgIndex = arguments.size() - 1 - argOffset;
        if (argOffset > rightArgIndex) {
            if (current.value != null) {
                candidates.add(current);
            }
            return;
        }
        SqlArgument leftArg = arguments.get(argOffset);
        boolean isRightArgEmpty = rightArgIndex == argOffset;
        SqlArgument rightArg = isRightArgEmpty ? null : arguments.get(rightArgIndex);
        for (Map.Entry<Pair<Parameter, Parameter>, Node> candidate : current.children.entrySet()) {
            boolean rightParamAccepts;
            HashMap<GenericType, SqlType> reservedCopy = new HashMap<GenericType, SqlType>(reservedGenerics);
            Parameter leftParam = candidate.getKey().getLeft();
            boolean leftParamAccepts = leftParam.accepts(leftArg, reservedCopy, allowCasts);
            Parameter rightParam = candidate.getKey().getRight();
            boolean rightParamAlsoEmpty = rightParam == null && isRightArgEmpty;
            boolean bl = rightParamAccepts = !isRightArgEmpty && rightParam != null && rightParam.accepts(rightArg, reservedCopy, allowCasts);
            if (!leftParamAccepts || !rightParamAlsoEmpty && !rightParamAccepts) continue;
            Node node = candidate.getValue();
            this.getCandidates(arguments, argOffset + 1, node, candidates, reservedCopy, allowCasts);
        }
    }

    private String getParamsAsString(List<SqlArgument> paramTypes) {
        return paramTypes.stream().map(argument -> {
            if (argument == null) {
                return "null";
            }
            return argument.toString(FormatOptions.noEscape());
        }).collect(Collectors.joining(", ", "(", ")"));
    }

    private String getAcceptedTypesAsString() {
        return this.allFunctions.values().stream().map(UdfIndex::formatAvailableSignatures).collect(Collectors.joining(System.lineSeparator()));
    }

    private KsqlException createVagueImplicitCastException(List<SqlArgument> paramTypes) {
        LOG.debug("Current UdfIndex:\n{}", (Object)this.describe());
        throw new KsqlException("Function '" + this.udfName + "' cannot be resolved due to ambiguous method parameters " + this.getParamsAsString(paramTypes) + "." + System.lineSeparator() + "Use CAST() to explicitly cast your parameters to one of the supported function calls." + System.lineSeparator() + "Valid function calls are:" + System.lineSeparator() + this.getAcceptedTypesAsString() + System.lineSeparator() + "For detailed information on a function run: DESCRIBE FUNCTION <Function-Name>;");
    }

    private KsqlException createNoMatchingFunctionException(List<SqlArgument> paramTypes) {
        LOG.debug("Current UdfIndex:\n{}", (Object)this.describe());
        String requiredTypes = this.getParamsAsString(paramTypes);
        String acceptedTypes = this.getAcceptedTypesAsString();
        return new KsqlException("Function '" + this.udfName + "' does not accept parameters " + requiredTypes + "." + System.lineSeparator() + "Valid alternatives are:" + System.lineSeparator() + acceptedTypes + System.lineSeparator() + "For detailed information on a function run: DESCRIBE FUNCTION <Function-Name>;");
    }

    public Collection<T> values() {
        return this.allFunctions.values();
    }

    private String describe() {
        StringBuilder sb = new StringBuilder();
        sb.append("-ROOT\n");
        this.root.describe(sb, 1);
        return sb.toString();
    }

    private static <T extends FunctionSignature> String formatAvailableSignatures(T function) {
        List<ParameterInfo> parameters = function.parameterInfo();
        StringBuilder result = new StringBuilder();
        result.append(function.name().toString(FormatOptions.noEscape())).append("(");
        for (int i = 0; i < parameters.size(); ++i) {
            String type;
            ParameterInfo param = parameters.get(i);
            String string = type = param.isVariadic() ? ((ArrayType)param.type()).element().toString() + "..." : param.type().toString();
            if (i != 0) {
                result.append(", ");
            }
            result.append(type);
            if (param.name().isEmpty()) continue;
            result.append(" ").append(param.name());
        }
        return result.append(")").toString();
    }

    private final class Node {
        @VisibleForTesting
        private final Comparator<T> compareFunctions = Comparator.nullsFirst(Comparator.comparing(fun -> fun.isVariadic() ? 0 : 1).thenComparing(fun -> fun.parameters().size()).thenComparing(fun -> -this.countGenerics(fun)).thenComparing(fun -> fun.parameters().stream().anyMatch(param -> param.equals(OBJ_VAR_ARG)) ? 0 : 1).thenComparing(this::indexOfVariadic));
        private final Map<Pair<Parameter, Parameter>, Node> children = new HashMap<Pair<Parameter, Parameter>, Node>();
        private T value = null;

        private Node() {
        }

        private void update(T function) {
            int compareVal = this.compareFunctions.compare(function, this.value);
            if (compareVal > 0) {
                this.value = function;
            }
        }

        private void describe(StringBuilder builder, int indent) {
            for (Map.Entry<Pair<Parameter, Parameter>, Node> child : this.children.entrySet()) {
                if (child.getValue() == this) continue;
                builder.append(StringUtils.repeat((char)' ', (int)(indent * 2))).append('-').append(child.getKey()).append(": ").append(child.getValue()).append('\n');
                child.getValue().describe(builder, indent + 1);
            }
        }

        public String toString() {
            return this.value != null ? this.value.name().text() : "EMPTY";
        }

        int compare(Node other) {
            return this.compareFunctions.compare(this.value, other.value);
        }

        private int countGenerics(T function) {
            return function.parameters().stream().filter(param -> GenericsUtil.hasGenerics(param) || param.equals(OBJ_VAR_ARG)).mapToInt(p -> 1).sum();
        }

        private int indexOfVariadic(T function) {
            if (function == null) {
                return -1;
            }
            return IntStream.range(0, function.parameterInfo().size()).filter(index -> function.parameterInfo().get(index).isVariadic()).findFirst().orElse(-1);
        }
    }

    private static final class Parameter {
        private final ParamType type;
        private final boolean isVararg;

        private Parameter(ParamType type, boolean isVararg) {
            this.isVararg = isVararg;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            return this.isVararg == parameter.isVararg && Objects.equals(this.type, parameter.type);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.isVararg);
        }

        boolean accepts(SqlArgument argument, Map<GenericType, SqlType> reservedGenerics, boolean allowCasts) {
            if (argument == null || !argument.getSqlLambda().isPresent() && !argument.getSqlType().isPresent()) {
                return true;
            }
            if (GenericsUtil.hasGenerics(this.type)) {
                return GenericsUtil.reserveGenerics(this.type, argument, reservedGenerics).getLeft();
            }
            return ParamTypes.areCompatible(argument, this.type, allowCasts);
        }

        public String toString() {
            return String.valueOf(this.type) + (this.isVararg ? "(VARARG)" : "");
        }
    }
}

