/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.connect;

import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.schema.connect.SchemaFormatter;
import io.confluent.ksql.schema.connect.SchemaWalker;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.util.DecimalUtil;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public final class SqlSchemaFormatter
implements SchemaFormatter {
    private static final String MAP_START = "MAP<";
    private static final String ARRAY_START = "ARRAY<";
    private static final String STRUCT_START = "STRUCT<";
    private static final String STRUCTURED_END = ">";
    private static final String NOT_NULL_SUFFIX = " NOT NULL";
    private final ImmutableSet<Option> options;
    private final FormatOptions formatOptions;

    public SqlSchemaFormatter(Predicate<String> addQuotesPredicate, Option ... options) {
        this.options = ImmutableSet.copyOf((Object[])options);
        this.formatOptions = FormatOptions.of(addQuotesPredicate);
    }

    @Override
    public String format(Schema schema) {
        String converted = SchemaWalker.visit(schema, new Converter()) + this.typePostFix(schema);
        return this.options.contains((Object)Option.AS_COLUMN_LIST) ? SqlSchemaFormatter.stripTopLevelStruct(converted) : converted;
    }

    private String typePostFix(Schema schema) {
        if (this.options.contains((Object)Option.APPEND_NOT_NULL) && !schema.isOptional()) {
            return NOT_NULL_SUFFIX;
        }
        return "";
    }

    private static String stripTopLevelStruct(String toStrip) {
        if (!toStrip.startsWith(STRUCT_START)) {
            return toStrip;
        }
        String suffixStripped = toStrip.endsWith(NOT_NULL_SUFFIX) ? toStrip.substring(0, toStrip.length() - NOT_NULL_SUFFIX.length()) : toStrip;
        return suffixStripped.substring(STRUCT_START.length(), suffixStripped.length() - STRUCTURED_END.length());
    }

    private final class Converter
    implements SchemaWalker.Visitor<String, String> {
        private Converter() {
        }

        @Override
        public String visitSchema(Schema schema) {
            throw new KsqlException("Invalid type in schema: " + String.valueOf(schema));
        }

        @Override
        public String visitBoolean(Schema schema) {
            return "BOOLEAN";
        }

        @Override
        public String visitInt32(Schema schema) {
            return "INT";
        }

        @Override
        public String visitInt64(Schema schema) {
            return "BIGINT";
        }

        @Override
        public String visitFloat64(Schema schema) {
            return "DOUBLE";
        }

        @Override
        public String visitString(Schema schema) {
            return "VARCHAR";
        }

        @Override
        public String visitBytes(Schema schema) {
            if (DecimalUtil.isDecimal(schema)) {
                return "DECIMAL(" + DecimalUtil.precision(schema) + ", " + DecimalUtil.scale(schema) + ")";
            }
            return "BYTES";
        }

        @Override
        public String visitArray(Schema schema, String element) {
            return SqlSchemaFormatter.ARRAY_START + element + SqlSchemaFormatter.this.typePostFix(schema.valueSchema()) + SqlSchemaFormatter.STRUCTURED_END;
        }

        @Override
        public String visitMap(Schema schema, String key, String value) {
            return SqlSchemaFormatter.MAP_START + key + SqlSchemaFormatter.this.typePostFix(schema.keySchema()) + ", " + value + SqlSchemaFormatter.this.typePostFix(schema.valueSchema()) + SqlSchemaFormatter.STRUCTURED_END;
        }

        @Override
        public String visitStruct(Schema schema, List<? extends String> fields) {
            if (fields.isEmpty()) {
                return "STRUCT< >";
            }
            return fields.stream().collect(Collectors.joining(", ", SqlSchemaFormatter.STRUCT_START, SqlSchemaFormatter.STRUCTURED_END));
        }

        @Override
        public String visitField(Field field, String type) {
            Schema schema = field.schema();
            String typePostFix = SqlSchemaFormatter.this.typePostFix(schema);
            return SqlSchemaFormatter.this.formatOptions.escape(field.name()) + " " + type + typePostFix;
        }
    }

    public static enum Option {
        APPEND_NOT_NULL,
        AS_COLUMN_LIST;

    }
}

