/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import io.confluent.ksql.security.AuthType;
import io.confluent.ksql.security.BasicCredentials;
import io.confluent.ksql.security.Credentials;
import io.confluent.ksql.security.oauth.OAuthBearerCredentials;
import io.confluent.ksql.security.oauth.StaticTokenCredentials;
import org.apache.kafka.common.config.ConfigException;

public class CredentialsFactory {
    public static Credentials createCredentials(AuthType authType, String customTokenCredentialsClassName) {
        switch (authType) {
            case BASIC: {
                return new BasicCredentials();
            }
            case OAUTHBEARER: {
                return new OAuthBearerCredentials();
            }
            case CUSTOM: {
                return CredentialsFactory.getCustomCredentials(customTokenCredentialsClassName);
            }
            case STATIC_TOKEN: {
                return new StaticTokenCredentials();
            }
        }
        return null;
    }

    private static Credentials getCustomCredentials(String customTokenCredentialsClassName) {
        Credentials customTokenCredentials;
        if (customTokenCredentialsClassName == null || customTokenCredentialsClassName.isEmpty()) {
            throw new ConfigException(String.format("Cannot configure CustomTokenCredentials as %s is not configured", "custom.token.credentials.class"));
        }
        try {
            customTokenCredentials = (Credentials)Class.forName(customTokenCredentialsClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ConfigException(String.format("Unable to instantiate an object of class %s, failed with exception: ", "custom.token.credentials.class") + e.getMessage());
        }
        return customTokenCredentials;
    }
}

