/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public final class KsqlClientConfig
extends AbstractConfig {
    public static final String KSQL_BASIC_AUTH_USERNAME = "ksql.auth.basic.username";
    public static final String KSQL_BASIC_AUTH_PASSWORD = "ksql.auth.basic.password";
    public static final String BEARER_AUTH_TOKEN_CONFIG = "bearer.auth.token";
    public static final String BEARER_AUTH_TOKEN_ENDPOINT_URL = "bearer.auth.issuer.endpoint.url";
    public static final String BEARER_AUTH_CLIENT_ID = "bearer.auth.client.id";
    public static final String BEARER_AUTH_CLIENT_SECRET = "bearer.auth.client.secret";
    public static final String BEARER_AUTH_SCOPE = "bearer.auth.scope";
    public static final String BEARER_AUTH_SCOPE_CLAIM_NAME = "bearer.auth.scope.claim.name";
    public static final String BEARER_AUTH_SCOPE_CLAIM_NAME_DEFAULT = "scope";
    public static final String BEARER_AUTH_SUB_CLAIM_NAME = "bearer.auth.sub.claim.name";
    public static final String BEARER_AUTH_SUB_CLAIM_NAME_DEFAULT = "sub";
    public static final String BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS = "bearer.auth.cache.expiry.buffer.seconds";
    public static final short BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS_DEFAULT = 300;
    public static final String SSL_PREFIX = "ssl.";
    public static final String SSL_TRUSTSTORE_LOCATION = "ssl.truststore.location";
    public static final String SSL_TRUSTSTORE_PASSWORD = "ssl.truststore.password";
    public static final String SSL_KEYSTORE_LOCATION = "ssl.keystore.location";
    public static final String SSL_KEYSTORE_PASSWORD = "ssl.keystore.password";
    public static final String SSL_KEY_PASSWORD = "ssl.key.password";
    public static final String SSL_KEY_ALIAS = "ssl.key.alias";
    public static final String SSL_ALPN = "ssl.alpn";
    public static final String SSL_VERIFY_HOST = "ssl.verify.host";
    public static final String CUSTOM_TOKEN_CREDENTIALS_CLASS = "custom.token.credentials.class";
    public static final String CUSTOM_TOKEN_CREDENTIALS_CLASS_DOC = "The class name of the custom token credentials. The class must implement the io.confluent.ksql.security.Credentials interface.";
    public static final String BEARER_AUTHENTICATION_METHOD = "bearer.auth.method";
    public static final String BEARER_AUTHENTICATION_METHOD_DOC = "The mechanism used to identifythe implementation of io.confluent.ksql.security.oauth.IdpConfig";

    private KsqlClientConfig(Map<String, String> configs) {
        super(new ConfigDef().define(KSQL_BASIC_AUTH_USERNAME, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "The username for the KSQL server").define(KSQL_BASIC_AUTH_PASSWORD, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.MEDIUM, "The password for the KSQL server").define(BEARER_AUTH_TOKEN_CONFIG, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.MEDIUM, "The static bearer token for the IDP Authorization server").define(BEARER_AUTH_TOKEN_ENDPOINT_URL, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "The issuer endpoint URL for the IDP Authorization server").define(BEARER_AUTH_CLIENT_ID, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "The client ID for the IDP Authorization server").define(BEARER_AUTH_CLIENT_SECRET, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.MEDIUM, "The client secret for the IDP Authorization server").define(BEARER_AUTH_SCOPE, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "The scope for the IDP Authorization server").define(BEARER_AUTH_SCOPE_CLAIM_NAME, ConfigDef.Type.STRING, (Object)BEARER_AUTH_SCOPE_CLAIM_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, "The scope claim name for the IDP Authorization server").define(BEARER_AUTH_SUB_CLAIM_NAME, ConfigDef.Type.STRING, (Object)BEARER_AUTH_SUB_CLAIM_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, "The sub claim name for the IDP Authorization server").define(BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS, ConfigDef.Type.SHORT, (Object)300, ConfigDef.Importance.MEDIUM, "The expiry buffer for token cache").define(SSL_TRUSTSTORE_LOCATION, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "The trust store path").define(SSL_TRUSTSTORE_PASSWORD, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.MEDIUM, "The trust store password").define(SSL_KEYSTORE_LOCATION, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "The key store path").define(SSL_KEYSTORE_PASSWORD, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.MEDIUM, "The key store password").define(SSL_KEY_PASSWORD, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.MEDIUM, "The key password").define(SSL_KEY_ALIAS, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "The key alias").define(SSL_ALPN, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Whether ALPN should be used. It defaults to false.").define(CUSTOM_TOKEN_CREDENTIALS_CLASS, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, CUSTOM_TOKEN_CREDENTIALS_CLASS_DOC).define(BEARER_AUTHENTICATION_METHOD, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, BEARER_AUTHENTICATION_METHOD_DOC).define(SSL_VERIFY_HOST, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, "Whether hostname verification is enabled. It defaults to true."), configs, false);
    }

    public static String getBearerAuthScopeClaimName(Map<String, ?> configs) {
        return configs != null && configs.containsKey(BEARER_AUTH_SCOPE_CLAIM_NAME) ? (String)configs.get(BEARER_AUTH_SCOPE_CLAIM_NAME) : BEARER_AUTH_SCOPE_CLAIM_NAME_DEFAULT;
    }

    public static String getBearerAuthSubClaimName(Map<String, ?> configs) {
        return configs != null && configs.containsKey(BEARER_AUTH_SUB_CLAIM_NAME) ? (String)configs.get(BEARER_AUTH_SUB_CLAIM_NAME) : BEARER_AUTH_SUB_CLAIM_NAME_DEFAULT;
    }

    public static short getBearerAuthCacheExpiryBufferSeconds(Map<String, ?> configs) {
        return configs != null && configs.containsKey(BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS) ? (Short)configs.get(BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS) : (short)300;
    }

    public static Map<String, Object> getClientSslConfig(Map<String, ?> configs) {
        return configs.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(SSL_PREFIX)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

