/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.oauth;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.security.oauth.OAuthTokenCache;
import io.confluent.ksql.security.oauth.exceptions.KsqlOAuthTokenRetrieverException;
import java.io.IOException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ValidateException;

public class CachedOAuthTokenRetriever {
    private final AccessTokenRetriever accessTokenRetriever;
    private final AccessTokenValidator accessTokenValidator;
    private final OAuthTokenCache authTokenCache;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public CachedOAuthTokenRetriever(AccessTokenRetriever accessTokenRetriever, AccessTokenValidator accessTokenValidator, OAuthTokenCache authTokenCache) {
        this.accessTokenRetriever = accessTokenRetriever;
        this.accessTokenValidator = accessTokenValidator;
        this.authTokenCache = authTokenCache;
    }

    public String getToken() {
        if (this.authTokenCache.isTokenExpired()) {
            OAuthBearerToken oauthBearerToken;
            String token = null;
            try {
                token = this.accessTokenRetriever.retrieve();
            }
            catch (IOException | RuntimeException e) {
                throw new KsqlOAuthTokenRetrieverException("Failed to Retrieve OAuth Token for KSQL", e);
            }
            try {
                oauthBearerToken = this.accessTokenValidator.validate(token);
            }
            catch (ValidateException e) {
                throw new KsqlOAuthTokenRetrieverException("OAuth Token for KSQL is Invalid", e);
            }
            this.authTokenCache.setCurrentToken(oauthBearerToken);
        }
        return this.authTokenCache.getCurrentToken().value();
    }
}

