/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.ssl;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.jsse.BCSSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostSslSocketFactory
extends SSLSocketFactory {
    private static final Logger log = LoggerFactory.getLogger(HostSslSocketFactory.class);
    private final SSLSocketFactory sslSocketFactory;
    private final String peerHost;
    private static final String BC_FIPS_SSL_PROVIDER = "BCJSSE";
    private static final String BC_FIPS_SECURITY_PROVIDER = "BCFIPS";

    public HostSslSocketFactory(SSLSocketFactory sslSocketFactory, String peerHost) {
        this.sslSocketFactory = sslSocketFactory;
        this.peerHost = peerHost;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.interceptAndSetHost(this.sslSocketFactory.createSocket(socket, host, port, autoClose));
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = this.sslSocketFactory.createSocket();
        return this.interceptAndSetHost(socket);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(host, port);
        return this.interceptAndSetHost(socket);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(host, port, localAddress, localPort);
        return this.interceptAndSetHost(socket);
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(address, port);
        return this.interceptAndSetHost(socket);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress remoteAddress, int remotePort) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(address, port, remoteAddress, remotePort);
        return this.interceptAndSetHost(socket);
    }

    @Override
    public Socket createSocket(Socket socket, InputStream inputStream, boolean autoClose) throws IOException {
        return this.interceptAndSetHost(this.sslSocketFactory.createSocket(socket, inputStream, autoClose));
    }

    private Socket interceptAndSetHost(Socket socket) {
        if (this.peerHost != null && HostSslSocketFactory.isFipsDeployment() && socket instanceof BCSSLSocket) {
            BCSSLSocket bcsslSocket = (BCSSLSocket)socket;
            if (!Strings.isNullOrEmpty((String)this.peerHost)) {
                log.debug("Setting hostname on Bouncy Castle SSL socket: {}", (Object)this.peerHost);
                bcsslSocket.setHost(this.peerHost);
            }
        }
        return socket;
    }

    public static boolean isFipsDeployment() {
        Provider bcFipsProvider = Security.getProvider(BC_FIPS_SECURITY_PROVIDER);
        Provider bcFipsJsseProvider = Security.getProvider(BC_FIPS_SSL_PROVIDER);
        return bcFipsProvider != null && bcFipsJsseProvider != null;
    }
}

