/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import java.util.Objects;

public class Pair<T1, T2> {
    public final T1 left;
    public final T2 right;

    public static <L, R> Pair<L, R> of(L left, R right) {
        return new Pair<L, R>(left, right);
    }

    public Pair(T1 left, T2 right) {
        this.left = left;
        this.right = right;
    }

    public T1 getLeft() {
        return this.left;
    }

    public T2 getRight() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return Objects.equals(this.left, pair.left) && Objects.equals(this.right, pair.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    public String toString() {
        return "Pair{left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + "}";
    }
}

