/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.function.sdk.v1.examples;

import com.google.protobuf.ByteString;
import io.confluent.function.sdk.v1.CCloudEnv;
import io.confluent.function.sdk.v1.CfltFunctionClient;
import io.confluent.function.sdk.v1.CfltFunctionClientBuilder;
import io.confluent.function.sdk.v1.CfltFunctionManagementClient;
import io.confluent.function.sdk.v1.CfltFunctionManagementClientBuilder;
import io.confluent.function.sdk.v1.CloudRegion;
import io.confluent.function.sdk.v1.StaticAuthTokenProvider;
import io.confluent.function.sdk.v1.types.CfltFunction;
import io.confluent.function.sdk.v1.types.ObjectMetadata;
import io.confluent.secure.compute.function.runtime.v2.InvokeRequest;
import io.confluent.secure.compute.function.runtime.v2.InvokeRequestBatch;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CfltFunctionClientExample {
    private static final String controlPlaneGatewayMagicalAccessToken = System.getenv("CONTROL_PLANE_GATEWAY_MAGICAL_ACCESS_TOKEN");
    private static final String dataPlaneGatewayMagicalAccessToken = System.getenv("DATA_PLANE_GATEWAY_MAGICAL_ACCESS_TOKEN");

    public static void main(String[] args) throws IOException, InterruptedException {
        CfltFunction cfltFunction;
        CfltFunctionClientExample.enableVerboseSdkLogging();
        try (CfltFunctionManagementClient mgmtClient = new CfltFunctionManagementClientBuilder().withClientId("connect-custom-smt").useRegionalApiServer().withRegion(CloudRegion.AWS_US_WEST_2).withCCloudEnv(CCloudEnv.DEVEL).withAuthTokenProvider(new StaticAuthTokenProvider(controlPlaneGatewayMagicalAccessToken)).useExperimentalDevelPublicGateway().build();){
            ObjectMetadata funcMetadata = ObjectMetadata.builder().name("user-func-12345").org("e9eb4f2c-ef73-475c-ba7f-6b37a4ff00e5").environment("env-devc33qr20").build();
            cfltFunction = mgmtClient.getCfltFunction(funcMetadata);
        }
        try (CfltFunctionClient client = new CfltFunctionClientBuilder().withClientId("connect-custom-smt").withAuthTokenProvider(new StaticAuthTokenProvider(dataPlaneGatewayMagicalAccessToken)).withFunction(cfltFunction).useExperimentalDevelPublicGateway().build();){
            int i;
            for (i = 0; i < 5; ++i) {
                client.invoke(InvokeRequest.newBuilder().setPayload(ByteString.copyFromUtf8((String)("hello world - " + i))).build());
            }
            for (i = 0; i < 5; ++i) {
                client.invokeBatch(InvokeRequestBatch.newBuilder().addRequests(InvokeRequest.newBuilder().setPayload(ByteString.copyFromUtf8((String)"hello world-1")).build()).addRequests(InvokeRequest.newBuilder().setPayload(ByteString.copyFromUtf8((String)"hello world-2")).build()).addRequests(InvokeRequest.newBuilder().setPayload(ByteString.copyFromUtf8((String)"hello world-3")).build()).build());
            }
        }
    }

    private static void enableVerboseSdkLogging() {
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            handler.setLevel(Level.ALL);
        }
        Logger.getLogger("io.confluent.function.sdk.v1").setLevel(Level.ALL);
    }
}

