/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.observers;

import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.internal.util.BlockingHelper;
import io.confluent.shaded.io.reactivex.internal.util.ExceptionHelper;
import java.util.concurrent.CountDownLatch;

public abstract class BlockingBaseObserver<T>
extends CountDownLatch
implements Observer<T>,
Disposable {
    T value;
    Throwable error;
    Disposable upstream;
    volatile boolean cancelled;

    public BlockingBaseObserver() {
        super(1);
    }

    @Override
    public final void onSubscribe(Disposable d) {
        this.upstream = d;
        if (this.cancelled) {
            d.dispose();
        }
    }

    @Override
    public final void onComplete() {
        this.countDown();
    }

    @Override
    public final void dispose() {
        this.cancelled = true;
        Disposable d = this.upstream;
        if (d != null) {
            d.dispose();
        }
    }

    @Override
    public final boolean isDisposed() {
        return this.cancelled;
    }

    public final T blockingGet() {
        Throwable e;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow(ex);
            }
        }
        if ((e = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(e);
        }
        return this.value;
    }
}

