/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.schedulers;

import io.confluent.shaded.io.reactivex.Scheduler;
import io.confluent.shaded.io.reactivex.annotations.NonNull;
import io.confluent.shaded.io.reactivex.disposables.CompositeDisposable;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.internal.disposables.EmptyDisposable;
import io.confluent.shaded.io.reactivex.internal.schedulers.InstantPeriodicTask;
import io.confluent.shaded.io.reactivex.internal.schedulers.RxThreadFactory;
import io.confluent.shaded.io.reactivex.internal.schedulers.ScheduledDirectPeriodicTask;
import io.confluent.shaded.io.reactivex.internal.schedulers.ScheduledDirectTask;
import io.confluent.shaded.io.reactivex.internal.schedulers.ScheduledRunnable;
import io.confluent.shaded.io.reactivex.internal.schedulers.SchedulerPoolFactory;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleScheduler
extends Scheduler {
    final ThreadFactory threadFactory;
    final AtomicReference<ScheduledExecutorService> executor = new AtomicReference();
    private static final String KEY_SINGLE_PRIORITY = "rx2.single-priority";
    private static final String THREAD_NAME_PREFIX = "RxSingleScheduler";
    static final RxThreadFactory SINGLE_THREAD_FACTORY;
    static final ScheduledExecutorService SHUTDOWN;

    public SingleScheduler() {
        this(SINGLE_THREAD_FACTORY);
    }

    public SingleScheduler(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        this.executor.lazySet(SingleScheduler.createExecutor(threadFactory));
    }

    static ScheduledExecutorService createExecutor(ThreadFactory threadFactory) {
        return SchedulerPoolFactory.create(threadFactory);
    }

    @Override
    public void start() {
        ScheduledExecutorService current;
        ExecutorService next = null;
        do {
            if ((current = this.executor.get()) != SHUTDOWN) {
                if (next != null) {
                    next.shutdown();
                }
                return;
            }
            if (next != null) continue;
            next = SingleScheduler.createExecutor(this.threadFactory);
        } while (!this.executor.compareAndSet(current, (ScheduledExecutorService)next));
    }

    @Override
    public void shutdown() {
        ScheduledExecutorService current = this.executor.get();
        if (current != SHUTDOWN && (current = this.executor.getAndSet(SHUTDOWN)) != SHUTDOWN) {
            current.shutdownNow();
        }
    }

    @Override
    @NonNull
    public Scheduler.Worker createWorker() {
        return new ScheduledWorker(this.executor.get());
    }

    @Override
    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable run, long delay, TimeUnit unit) {
        ScheduledDirectTask task = new ScheduledDirectTask(RxJavaPlugins.onSchedule(run));
        try {
            Future<Void> f = delay <= 0L ? this.executor.get().submit(task) : this.executor.get().schedule(task, delay, unit);
            task.setFuture(f);
            return task;
        }
        catch (RejectedExecutionException ex) {
            RxJavaPlugins.onError(ex);
            return EmptyDisposable.INSTANCE;
        }
    }

    @Override
    @NonNull
    public Disposable schedulePeriodicallyDirect(@NonNull Runnable run, long initialDelay, long period, TimeUnit unit) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        if (period <= 0L) {
            ScheduledExecutorService exec = this.executor.get();
            InstantPeriodicTask periodicWrapper = new InstantPeriodicTask(decoratedRun, exec);
            try {
                Future<Void> f = initialDelay <= 0L ? exec.submit(periodicWrapper) : exec.schedule(periodicWrapper, initialDelay, unit);
                periodicWrapper.setFirst(f);
            }
            catch (RejectedExecutionException ex) {
                RxJavaPlugins.onError(ex);
                return EmptyDisposable.INSTANCE;
            }
            return periodicWrapper;
        }
        ScheduledDirectPeriodicTask task = new ScheduledDirectPeriodicTask(decoratedRun);
        try {
            ScheduledFuture<?> f = this.executor.get().scheduleAtFixedRate(task, initialDelay, period, unit);
            task.setFuture(f);
            return task;
        }
        catch (RejectedExecutionException ex) {
            RxJavaPlugins.onError(ex);
            return EmptyDisposable.INSTANCE;
        }
    }

    static {
        SHUTDOWN = Executors.newScheduledThreadPool(0);
        SHUTDOWN.shutdown();
        int priority = Math.max(1, Math.min(10, Integer.getInteger(KEY_SINGLE_PRIORITY, 5)));
        SINGLE_THREAD_FACTORY = new RxThreadFactory(THREAD_NAME_PREFIX, priority, true);
    }

    static final class ScheduledWorker
    extends Scheduler.Worker {
        final ScheduledExecutorService executor;
        final CompositeDisposable tasks;
        volatile boolean disposed;

        ScheduledWorker(ScheduledExecutorService executor) {
            this.executor = executor;
            this.tasks = new CompositeDisposable();
        }

        @Override
        @NonNull
        public Disposable schedule(@NonNull Runnable run, long delay, @NonNull TimeUnit unit) {
            if (this.disposed) {
                return EmptyDisposable.INSTANCE;
            }
            Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
            ScheduledRunnable sr = new ScheduledRunnable(decoratedRun, this.tasks);
            this.tasks.add(sr);
            try {
                Future<Object> f = delay <= 0L ? this.executor.submit(sr) : this.executor.schedule(sr, delay, unit);
                sr.setFuture(f);
            }
            catch (RejectedExecutionException ex) {
                this.dispose();
                RxJavaPlugins.onError(ex);
                return EmptyDisposable.INSTANCE;
            }
            return sr;
        }

        @Override
        public void dispose() {
            if (!this.disposed) {
                this.disposed = true;
                this.tasks.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

