/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.client;

import com.fasterxml.jackson.databind.JavaType;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import io.confluent.flink.watch.v1alpha1.TypeMeta;
import io.confluent.flink.watch.v1alpha1.WatchGrpc;
import io.confluent.flink.watch.v1alpha1.WatchRequest;
import io.confluent.flink.watch.v1alpha1.WatchResponse;
import io.confluent.resourcemanager.api.client.ApiException;
import io.confluent.resourcemanager.api.client.ClientImpl;
import io.confluent.resourcemanager.api.client.GroupVersionResource;
import io.confluent.resourcemanager.api.client.WatchEvent;
import io.confluent.resourcemanager.api.model.HasMetadata;
import io.confluent.resourcemanager.api.model.ListMeta;
import io.confluent.resourcemanager.api.model.Status;
import io.confluent.resourcemanager.api.model.StatusCause;
import io.confluent.resourcemanager.api.model.location.Location;
import io.confluent.resourcemanager.api.model.scope.Scoping;
import io.confluent.resourcemanager.api.openapi.Adapter;
import io.confluent.resourcemanager.protobuf.apis.meta.v1.StatusDetails;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.StatusProto;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class Watcher<T extends HasMetadata> {
    private final Metadata.Key<String> WATCH_CLIENT_NAME_KEY = Metadata.Key.of((String)"client-name", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final StatusException CLIENT_CANCELLED_WATCH = new StatusException(io.grpc.Status.CANCELLED.withDescription("client cancelled the watch"));
    private final Metadata metadata = new Metadata();
    private final WatchGrpc.WatchStub watchStub;
    private final WatchStreamObserver<T> watchStreamObserver;
    private final WatchRequest.Builder watchRequestBuilder;

    public Watcher(Channel channel, Class<T> clazz) {
        this(channel, ClientImpl.OBJECT_MAPPER.constructType(clazz), HasMetadata.getGroup(clazz), HasMetadata.getVersion(clazz), HasMetadata.getKind(clazz));
    }

    private Watcher(Channel channel, JavaType javaType, String group, String version, String kind) {
        this.watchStub = WatchGrpc.newStub(channel);
        this.watchStreamObserver = new WatchStreamObserver(javaType);
        String apiVersion = String.format("%s/%s", group, version);
        TypeMeta objectType = TypeMeta.newBuilder().setApiVersion(apiVersion).setKind(kind).build();
        this.watchRequestBuilder = WatchRequest.newBuilder().setObjectType(objectType);
    }

    public static <U, V extends Adapter<U>> Watcher<V> fromAdapter(Channel channel, V adapter) {
        Watcher watcher = new Watcher(channel, adapter.getJavaType(), adapter.getGroupVersionResource().group(), adapter.getGroupVersionResource().version(), adapter.getKind());
        watcher.watchStreamObserver.gvr = adapter.getGroupVersionResource();
        watcher.watchStreamObserver.kind = adapter.getKind();
        watcher.watchStreamObserver.scoping = adapter.getScoping();
        return watcher;
    }

    public Watcher<T> clientName(String clientName) {
        this.metadata.put(this.WATCH_CLIENT_NAME_KEY, (Object)Objects.requireNonNull(clientName));
        return this;
    }

    public Watcher<T> subscriptionId(String subscriptionId) {
        this.watchRequestBuilder.setSubscriptionId(Objects.requireNonNull(subscriptionId));
        return this;
    }

    public Watcher<T> continueToken(String continueToken) {
        this.watchRequestBuilder.setContinueToken(Objects.requireNonNull(continueToken));
        return this;
    }

    public Watcher<T> includeSnapshot(boolean includeSnapshot) {
        this.watchRequestBuilder.setIncludeSnapshot(includeSnapshot);
        return this;
    }

    public Watcher<T> labelSelector(String labelSelector) {
        this.watchRequestBuilder.addLabelSelector(Objects.requireNonNull(labelSelector));
        return this;
    }

    public Watcher<T> fieldSelector(String fieldSelector) {
        this.watchRequestBuilder.addFieldSelector(Objects.requireNonNull(fieldSelector));
        return this;
    }

    public Watcher<T> location(Location location) {
        this.watchRequestBuilder.setLocation(Objects.requireNonNull(location).toString());
        return this;
    }

    public Watcher<T> onNext(Consumer<WatchEvent<T>> onNextCallback) {
        this.watchStreamObserver.onNextCallback = Objects.requireNonNull(onNextCallback);
        return this;
    }

    public Watcher<T> onError(Consumer<Throwable> onErrorCallback) {
        this.watchStreamObserver.onErrorCallback = Objects.requireNonNull(onErrorCallback);
        return this;
    }

    public Watcher<T> onCompleted(Runnable onCompletedCallback) {
        this.watchStreamObserver.onCompletedCallback = Objects.requireNonNull(onCompletedCallback);
        return this;
    }

    public Subscription subscribe() {
        if (this.watchStreamObserver.onNextCallback == null || this.watchStreamObserver.onErrorCallback == null) {
            throw new IllegalStateException("Please provide at least an onNext and an onError callback");
        }
        if (this.watchRequestBuilder.getSubscriptionId().isEmpty()) {
            this.watchRequestBuilder.setSubscriptionId(UUID.randomUUID().toString());
        }
        WatchRequest watchRequest = this.watchRequestBuilder.build();
        Context.CancellableContext withCancellation = Context.current().withCancellation();
        withCancellation.run(() -> ((WatchGrpc.WatchStub)((WatchGrpc.WatchStub)this.watchStub.withWaitForReady()).withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)this.metadata)})).watch(watchRequest, this.watchStreamObserver));
        return () -> {
            try (Context.CancellableContext cancellableContext = withCancellation;){
                withCancellation.cancel((Throwable)CLIENT_CANCELLED_WATCH);
            }
        };
    }

    private static class WatchStreamObserver<T extends HasMetadata>
    implements StreamObserver<WatchResponse> {
        private final JavaType javaType;
        private Consumer<WatchEvent<T>> onNextCallback;
        private Consumer<Throwable> onErrorCallback;
        private Runnable onCompletedCallback;
        GroupVersionResource gvr;
        String kind;
        Scoping scoping;

        WatchStreamObserver(JavaType javaType) {
            this.javaType = javaType;
        }

        public void onNext(WatchResponse watchResponse) {
            for (io.confluent.flink.watch.v1alpha1.WatchEvent event : watchResponse.getEventsList()) {
                try {
                    WatchEvent watchEvent = WatchEvent.fromV1Alpha1Event(event, this.javaType);
                    Object object = watchEvent.object();
                    if (object instanceof Adapter) {
                        Adapter adapter = (Adapter)object;
                        adapter.setGroupVersionResource(this.gvr);
                        adapter.setKind(this.kind);
                        adapter.setScoping(this.scoping);
                    }
                    this.onNextCallback.accept(watchEvent);
                }
                catch (IOException e) {
                    throw new StatusRuntimeException(io.grpc.Status.fromThrowable((Throwable)e));
                }
            }
        }

        public void onError(Throwable throwable) {
            if (this.hasClientCancelled(throwable)) {
                this.onCompleted();
                return;
            }
            com.google.rpc.Status status = StatusProto.fromThrowable((Throwable)throwable);
            if (status == null) {
                this.onErrorCallback.accept(throwable);
                return;
            }
            for (Any detail : status.getDetailsList()) {
                try {
                    io.confluent.resourcemanager.protobuf.apis.meta.v1.Status rmProtoStatus = (io.confluent.resourcemanager.protobuf.apis.meta.v1.Status)detail.unpack(io.confluent.resourcemanager.protobuf.apis.meta.v1.Status.class);
                    if (rmProtoStatus == null) continue;
                    Status mappedStatus = WatchStreamObserver.mapProtoStatus(rmProtoStatus);
                    this.onErrorCallback.accept(new ApiException(mappedStatus));
                    return;
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                }
            }
            this.onErrorCallback.accept(throwable);
        }

        private static Status mapProtoStatus(io.confluent.resourcemanager.protobuf.apis.meta.v1.Status rmProtoStatus) {
            ListMeta mappedMeta = new ListMeta(rmProtoStatus.getMetadata().getContinue(), rmProtoStatus.getMetadata().getRemainingItemCount());
            io.confluent.resourcemanager.api.model.StatusDetails details = null;
            if (rmProtoStatus.hasDetails()) {
                StatusDetails protoDetails = rmProtoStatus.getDetails();
                details = new io.confluent.resourcemanager.api.model.StatusDetails(protoDetails.getName(), protoDetails.getGroup(), protoDetails.getKind(), UUID.fromString(protoDetails.getUid()), protoDetails.getCausesList().stream().map(protoCause -> new StatusCause(protoCause.getReason(), protoCause.getMessage(), protoCause.getField())).collect(Collectors.toList()), protoDetails.getRetryAfterSeconds());
            }
            return new Status(mappedMeta, rmProtoStatus.getStatus(), rmProtoStatus.getMessage(), rmProtoStatus.getReason(), details, rmProtoStatus.getCode());
        }

        private boolean hasClientCancelled(Throwable throwable) {
            io.grpc.Status status = io.grpc.Status.fromThrowable((Throwable)throwable);
            Status.Code clientCancelledCode = CLIENT_CANCELLED_WATCH.getStatus().getCode();
            String clientCancelledDesc = CLIENT_CANCELLED_WATCH.getStatus().getDescription();
            return status.getCode() == clientCancelledCode && status.getDescription() != null && status.getDescription().equals(clientCancelledDesc);
        }

        public void onCompleted() {
            if (this.onCompletedCallback == null) {
                return;
            }
            this.onCompletedCallback.run();
        }
    }

    public static interface Subscription
    extends AutoCloseable {
        @Override
        public void close();
    }
}

