/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.resourcemanager.api.annotations.GroupVersionKind;
import io.confluent.resourcemanager.api.annotations.Plural;
import io.confluent.resourcemanager.api.annotations.Scope;
import io.confluent.resourcemanager.api.client.GroupVersionResource;
import io.confluent.resourcemanager.api.model.identifier.ObjectIdentifier;
import io.confluent.resourcemanager.api.model.scope.Scoping;
import io.confluent.resourcemanager.protobuf.apis.meta.v1.ObjectMeta;
import java.util.Optional;

public interface HasMetadata {
    public ObjectMeta getMetadata();

    public ObjectIdentifier<? extends HasMetadata> identifier();

    @JsonProperty(value="kind", access=JsonProperty.Access.READ_ONLY)
    default public String getKind() {
        return HasMetadata.getKind(this.getClass());
    }

    @JsonProperty(value="apiVersion", access=JsonProperty.Access.READ_ONLY)
    default public String getApiVersion() {
        return String.format("%s/%s", HasMetadata.getGroup(this.getClass()), HasMetadata.getVersion(this.getClass()));
    }

    public static String getGroup(Class<?> clazz) {
        return HasMetadata.getGroupVersionKind(clazz).map(GroupVersionKind::group).orElseThrow(() -> new RuntimeException("GroupVersionKind annotation not found"));
    }

    public static String getVersion(Class<?> clazz) {
        return HasMetadata.getGroupVersionKind(clazz).map(GroupVersionKind::version).orElseThrow(() -> new RuntimeException("GroupVersionKind annotation not found"));
    }

    public static String getKind(Class<?> clazz) {
        return HasMetadata.getGroupVersionKind(clazz).map(GroupVersionKind::kind).orElseThrow(() -> new RuntimeException("GroupVersionKind annotation not found"));
    }

    public static Optional<GroupVersionResource> getGVR(Class<?> clazz) {
        return HasMetadata.getGroupVersionKind(clazz).map(gvk -> new GroupVersionResource(gvk.group(), gvk.version(), HasMetadata.getResource(clazz, gvk.kind())));
    }

    public static Optional<Scoping> getScoping(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Scope.class)) {
            return Optional.of(clazz.getAnnotation(Scope.class).scoping());
        }
        return Optional.empty();
    }

    private static Optional<GroupVersionKind> getGroupVersionKind(Class<?> clazz) {
        if (clazz.isAnnotationPresent(GroupVersionKind.class)) {
            return Optional.of(clazz.getAnnotation(GroupVersionKind.class));
        }
        return Optional.empty();
    }

    private static String getResource(Class<?> clazz, String kind) {
        if (clazz.isAnnotationPresent(Plural.class)) {
            return clazz.getAnnotation(Plural.class).value();
        }
        if (kind.isEmpty()) {
            return "";
        }
        return kind.toLowerCase() + "s";
    }
}

