/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.List;
import org.apache.kafka.common.Confluent;

public class NewPartitionReassignment {
    private final List<Integer> targetReplicas;
    private final List<Integer> targetObservers;

    @Confluent
    public static NewPartitionReassignment ofReplicasAndObservers(List<Integer> replicas, List<Integer> observers) {
        return new NewPartitionReassignment(replicas, observers);
    }

    public NewPartitionReassignment(List<Integer> targetReplicas) {
        this(targetReplicas, List.of());
    }

    private NewPartitionReassignment(List<Integer> targetReplicas, List<Integer> targetObservers) {
        if (targetReplicas == null || targetReplicas.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a new partition reassignment without any replicas");
        }
        if (targetObservers == null) {
            throw new IllegalArgumentException("Cannot create a new partition reassignment with null observers");
        }
        this.targetReplicas = List.copyOf(targetReplicas);
        this.targetObservers = List.copyOf(targetObservers);
    }

    public List<Integer> targetReplicas() {
        return this.targetReplicas;
    }

    @Confluent
    public List<Integer> targetObservers() {
        return this.targetObservers;
    }
}

