/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.CoordinatorStrategy;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class ListConsumerGroupOffsetsHandler
implements AdminApiHandler<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> {
    private final boolean requireStable;
    private final Map<String, ListConsumerGroupOffsetsSpec> groupSpecs;
    private final Logger log;
    private final CoordinatorStrategy lookupStrategy;

    public ListConsumerGroupOffsetsHandler(Map<String, ListConsumerGroupOffsetsSpec> groupSpecs, boolean requireStable, LogContext logContext) {
        this.log = logContext.logger(ListConsumerGroupOffsetsHandler.class);
        this.lookupStrategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, logContext);
        this.groupSpecs = groupSpecs;
        this.requireStable = requireStable;
    }

    public static AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> newFuture(List<String> groupIds) {
        return AdminApiFuture.forKeys(groupIds.stream().map(CoordinatorKey::byGroupId).collect(Collectors.toSet()));
    }

    public static AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> newFuture(Collection<String> groupIds) {
        return AdminApiFuture.forKeys(ListConsumerGroupOffsetsHandler.coordinatorKeys(groupIds));
    }

    @Override
    public String apiName() {
        return "offsetFetch";
    }

    @Override
    public AdminApiLookupStrategy<CoordinatorKey> lookupStrategy() {
        return this.lookupStrategy;
    }

    private void validateKeys(Set<CoordinatorKey> groupIds) {
        Set<CoordinatorKey> keys = ListConsumerGroupOffsetsHandler.coordinatorKeys(this.groupSpecs.keySet());
        if (!keys.containsAll(groupIds)) {
            throw new IllegalArgumentException("Received unexpected group ids " + String.valueOf(groupIds) + " (expected one of " + String.valueOf(keys) + ")");
        }
    }

    private static Set<CoordinatorKey> coordinatorKeys(Collection<String> groupIds) {
        return groupIds.stream().map(CoordinatorKey::byGroupId).collect(Collectors.toSet());
    }

    public OffsetFetchRequest.Builder buildBatchedRequest(Set<CoordinatorKey> groupIds) {
        HashMap<String, List<TopicPartition>> coordinatorGroupIdToTopicPartitions = new HashMap<String, List<TopicPartition>>(groupIds.size());
        groupIds.forEach(g2 -> {
            ListConsumerGroupOffsetsSpec spec = this.groupSpecs.get(g2.idValue);
            ArrayList<TopicPartition> partitions = spec.topicPartitions() != null ? new ArrayList<TopicPartition>(spec.topicPartitions()) : null;
            coordinatorGroupIdToTopicPartitions.put(g2.idValue, partitions);
        });
        return new OffsetFetchRequest.Builder(coordinatorGroupIdToTopicPartitions, this.requireStable, false);
    }

    @Override
    public Collection<AdminApiHandler.RequestAndKeys<CoordinatorKey>> buildRequest(int brokerId, Set<CoordinatorKey> groupIds) {
        this.validateKeys(groupIds);
        if (this.lookupStrategy.batch()) {
            return Collections.singletonList(new AdminApiHandler.RequestAndKeys<CoordinatorKey>(this.buildBatchedRequest(groupIds), groupIds));
        }
        return groupIds.stream().map(groupId -> {
            Set<CoordinatorKey> keys = Collections.singleton(groupId);
            return new AdminApiHandler.RequestAndKeys<CoordinatorKey>(this.buildBatchedRequest(keys), keys);
        }).collect(Collectors.toList());
    }

    @Override
    public AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> handleResponse(Node coordinator, Set<CoordinatorKey> groupIds, AbstractResponse abstractResponse) {
        this.validateKeys(groupIds);
        OffsetFetchResponse response = (OffsetFetchResponse)abstractResponse;
        HashMap completed = new HashMap();
        HashMap<CoordinatorKey, Throwable> failed = new HashMap<CoordinatorKey, Throwable>();
        ArrayList<CoordinatorKey> unmapped = new ArrayList<CoordinatorKey>();
        for (CoordinatorKey coordinatorKey : groupIds) {
            String group = coordinatorKey.idValue;
            if (response.groupHasError(group)) {
                this.handleGroupError(CoordinatorKey.byGroupId(group), response.groupLevelError(group), failed, unmapped);
                continue;
            }
            HashMap<TopicPartition, OffsetAndMetadata> groupOffsetsListing = new HashMap<TopicPartition, OffsetAndMetadata>();
            Map<TopicPartition, OffsetFetchResponse.PartitionData> responseData = response.partitionDataMap(group);
            for (Map.Entry<TopicPartition, OffsetFetchResponse.PartitionData> partitionEntry : responseData.entrySet()) {
                TopicPartition topicPartition = partitionEntry.getKey();
                OffsetFetchResponse.PartitionData partitionData = partitionEntry.getValue();
                Errors error = partitionData.error;
                if (error == Errors.NONE) {
                    long offset = partitionData.offset;
                    String metadata = partitionData.metadata;
                    Optional<Integer> leaderEpoch = partitionData.leaderEpoch;
                    if (offset < 0L) {
                        groupOffsetsListing.put(topicPartition, null);
                        continue;
                    }
                    groupOffsetsListing.put(topicPartition, new OffsetAndMetadata(offset, leaderEpoch, metadata));
                    continue;
                }
                this.log.warn("Skipping return offset for {} due to error {}.", (Object)topicPartition, (Object)error);
            }
            completed.put(CoordinatorKey.byGroupId(group), groupOffsetsListing);
        }
        return new AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>>(completed, failed, unmapped);
    }

    private void handleGroupError(CoordinatorKey groupId, Errors error, Map<CoordinatorKey, Throwable> failed, List<CoordinatorKey> groupsToUnmap) {
        switch (error) {
            case GROUP_AUTHORIZATION_FAILED: 
            case UNKNOWN_MEMBER_ID: 
            case STALE_MEMBER_EPOCH: {
                this.log.debug("`OffsetFetch` request for group id {} failed due to error {}", (Object)groupId.idValue, (Object)error);
                failed.put(groupId, error.exception());
                break;
            }
            case COORDINATOR_LOAD_IN_PROGRESS: {
                this.log.debug("`OffsetFetch` request for group id {} failed because the coordinator is still in the process of loading state. Will retry", (Object)groupId.idValue);
                break;
            }
            case COORDINATOR_NOT_AVAILABLE: 
            case NOT_COORDINATOR: {
                this.log.debug("`OffsetFetch` request for group id {} returned error {}. Will attempt to find the coordinator again and retry", (Object)groupId.idValue, (Object)error);
                groupsToUnmap.add(groupId);
                break;
            }
            default: {
                this.log.error("`OffsetFetch` request for group id {} failed due to unexpected error {}", (Object)groupId.idValue, (Object)error);
                failed.put(groupId, error.exception());
            }
        }
    }
}

