/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterBrokerHealthRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class AlterBrokerHealthRequestDataJsonConverter {
    public static AlterBrokerHealthRequestData read(JsonNode _node, short _version) {
        AlterBrokerHealthRequestData _object = new AlterBrokerHealthRequestData();
        JsonNode _brokerIdsNode = _node.get("brokerIds");
        if (_brokerIdsNode == null) {
            throw new RuntimeException("AlterBrokerHealthRequestData: unable to locate field 'brokerIds', which is mandatory in version " + _version);
        }
        if (!_brokerIdsNode.isArray()) {
            throw new RuntimeException("AlterBrokerHealthRequestData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<Integer> _collection = new ArrayList<Integer>(_brokerIdsNode.size());
        _object.brokerIds = _collection;
        for (JsonNode _element : _brokerIdsNode) {
            _collection.add(MessageUtil.jsonNodeToInt(_element, "AlterBrokerHealthRequestData element"));
        }
        JsonNode _reasonNode = _node.get("reason");
        if (_reasonNode == null) {
            throw new RuntimeException("AlterBrokerHealthRequestData: unable to locate field 'reason', which is mandatory in version " + _version);
        }
        if (!_reasonNode.isTextual()) {
            throw new RuntimeException("AlterBrokerHealthRequestData expected a string type, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.reason = _reasonNode.asText();
        JsonNode _componentCodeNode = _node.get("componentCode");
        if (_componentCodeNode == null) {
            if (_version >= 2) {
                throw new RuntimeException("AlterBrokerHealthRequestData: unable to locate field 'componentCode', which is mandatory in version " + _version);
            }
            _object.componentCode = 0;
        } else {
            _object.componentCode = MessageUtil.jsonNodeToByte(_componentCodeNode, "AlterBrokerHealthRequestData");
        }
        JsonNode _statusCodeNode = _node.get("statusCode");
        if (_statusCodeNode == null) {
            throw new RuntimeException("AlterBrokerHealthRequestData: unable to locate field 'statusCode', which is mandatory in version " + _version);
        }
        _object.statusCode = MessageUtil.jsonNodeToByte(_statusCodeNode, "AlterBrokerHealthRequestData");
        JsonNode _forceNode = _node.get("force");
        if (_forceNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("AlterBrokerHealthRequestData: unable to locate field 'force', which is mandatory in version " + _version);
            }
            _object.force = false;
        } else {
            if (!_forceNode.isBoolean()) {
                throw new RuntimeException("AlterBrokerHealthRequestData expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.force = _forceNode.asBoolean();
        }
        JsonNode _brokerEpochNode = _node.get("brokerEpoch");
        _object.brokerEpoch = _brokerEpochNode == null ? -1L : MessageUtil.jsonNodeToLong(_brokerEpochNode, "AlterBrokerHealthRequestData");
        return _object;
    }

    public static JsonNode write(AlterBrokerHealthRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode _brokerIdsArray = new ArrayNode(JsonNodeFactory.instance);
        for (Integer _element : _object.brokerIds) {
            _brokerIdsArray.add((JsonNode)new IntNode(_element.intValue()));
        }
        _node.set("brokerIds", (JsonNode)_brokerIdsArray);
        _node.set("reason", (JsonNode)new TextNode(_object.reason));
        if (_version >= 2) {
            _node.set("componentCode", (JsonNode)new ShortNode((short)_object.componentCode));
        } else if (_object.componentCode != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default componentCode at version " + _version);
        }
        _node.set("statusCode", (JsonNode)new ShortNode((short)_object.statusCode));
        if (_version >= 1) {
            _node.set("force", (JsonNode)BooleanNode.valueOf((boolean)_object.force));
        }
        if (_version >= 5 && _object.brokerEpoch != -1L) {
            _node.set("brokerEpoch", (JsonNode)new LongNode(_object.brokerEpoch));
        }
        return _node;
    }

    public static JsonNode write(AlterBrokerHealthRequestData _object, short _version) {
        return AlterBrokerHealthRequestDataJsonConverter.write(_object, _version, true);
    }
}

