/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.ReportQuotaConsumptionRequestData;
import org.apache.kafka.common.message.ReportQuotaConsumptionResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ReportQuotaConsumptionResponse;

public class ReportQuotaConsumptionRequest
extends AbstractRequest {
    private final ReportQuotaConsumptionRequestData data;

    public ReportQuotaConsumptionRequest(short version) {
        this(new ReportQuotaConsumptionRequestData(), version);
    }

    public ReportQuotaConsumptionRequest(ReportQuotaConsumptionRequestData data, short version) {
        super(ApiKeys.REPORT_QUOTA_CONSUMPTION, version);
        this.data = data;
    }

    @Override
    public ReportQuotaConsumptionResponse getErrorResponse(int throttleTimeMs, Throwable throwable) {
        ApiError apiError = ApiError.fromThrowable(throwable);
        ArrayList<ReportQuotaConsumptionResponseData.EntryData> errors = this.data.entries() == null ? new ArrayList<ReportQuotaConsumptionResponseData.EntryData>() : this.data.entries().stream().map(entry -> new ReportQuotaConsumptionResponseData.EntryData().setEntity(entry.entity().stream().map(entityData -> new ReportQuotaConsumptionResponseData.EntityData().setEntityName(entityData.entityName()).setEntityType(entityData.entityType())).collect(Collectors.toList())).setErrorCode(apiError.error().code())).collect(Collectors.toList());
        ReportQuotaConsumptionResponseData data = new ReportQuotaConsumptionResponseData().setEntries(errors).setThrottleTimeMs(throttleTimeMs);
        return new ReportQuotaConsumptionResponse(data);
    }

    @Override
    public ReportQuotaConsumptionRequestData data() {
        return this.data;
    }

    public static ReportQuotaConsumptionRequest parse(Readable readable, short version, MessageContext context) {
        return new ReportQuotaConsumptionRequest(new ReportQuotaConsumptionRequestData(readable, version, context), version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportQuotaConsumptionRequest that = (ReportQuotaConsumptionRequest)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public static class Builder
    extends AbstractRequest.Builder<ReportQuotaConsumptionRequest> {
        private final ReportQuotaConsumptionRequestData data;

        public Builder(ReportQuotaConsumptionRequestData data) {
            super(ApiKeys.REPORT_QUOTA_CONSUMPTION);
            this.data = data;
        }

        @Override
        public ReportQuotaConsumptionRequest build(short version) {
            return new ReportQuotaConsumptionRequest(this.data, version);
        }
    }
}

