/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security;

import io.confluent.common.security.license.LicenseEventListener;
import io.confluent.common.security.license.MultiLicenseBackgroundFetcher;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.extensions.SchemaRegistryResourceExtension;
import io.confluent.kafka.schemaregistry.security.config.SecureSchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.security.license.LicensePrivilegeManager;
import io.confluent.kafka.schemaregistry.security.license.SchemaRegistryLicenseListener;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.rest.RestConfigException;
import jakarta.ws.rs.core.Configurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryLicenseResourceExtension
implements SchemaRegistryResourceExtension {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryLicenseResourceExtension.class);
    private MultiLicenseBackgroundFetcher licenseBackgroundFetcher;
    private SchemaRegistryLicenseListener schemaRegistryLicenseListener;

    public void register(Configurable<?> configurable, SchemaRegistryConfig schemaRegistryConfig, SchemaRegistry kafkaSchemaRegistry) throws SchemaRegistryException {
        SecureSchemaRegistryConfig confluentSecureSchemaRegistryConfig;
        try {
            confluentSecureSchemaRegistryConfig = new SecureSchemaRegistryConfig(schemaRegistryConfig.originalProperties());
        }
        catch (RestConfigException e) {
            throw new SchemaRegistryException((Throwable)e);
        }
        this.initializeLicenseAttribution(confluentSecureSchemaRegistryConfig, kafkaSchemaRegistry);
    }

    public void close() {
        if (this.licenseBackgroundFetcher != null) {
            this.licenseBackgroundFetcher.stopAsync();
        }
    }

    private void initializeLicenseAttribution(SecureSchemaRegistryConfig config, SchemaRegistry kafkaSchemaRegistry) {
        try {
            log.info("Initializing license attribution");
            this.licenseBackgroundFetcher = new MultiLicenseBackgroundFetcher(config.licenseTopic(), config.licenseProducerConfigs(), config.licenseConsumerConfigs(), config.licenseAdminConfigs());
            this.schemaRegistryLicenseListener = new SchemaRegistryLicenseListener(kafkaSchemaRegistry);
            this.licenseBackgroundFetcher.addListener((LicenseEventListener)this.schemaRegistryLicenseListener);
            LicensePrivilegeManager.registerLicenseWithFetcher(config, this.licenseBackgroundFetcher);
            log.info("Starting MultiLicenseBackgroundFetcher for license changes");
            this.licenseBackgroundFetcher.startAsync();
            log.info("License attribution initialization completed successfully");
        }
        catch (Exception e) {
            log.error("Failed to initialize license attribution", (Throwable)e);
        }
    }

    MultiLicenseBackgroundFetcher getLicenseBackgroundFetcher() {
        return this.licenseBackgroundFetcher;
    }

    SchemaRegistryLicenseListener getSchemaRegistryLicenseListener() {
        return this.schemaRegistryLicenseListener;
    }
}

