/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer;

import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryResourceOperation;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.security.Principal;

public class AuthorizeRequest {
    private final Principal user;
    private final String resourceName;
    private final SchemaRegistryResourceOperation schemaRegistryResourceOperation;
    private final ContainerRequestContext containerRequestContext;
    private final HttpServletRequest httpServletRequest;
    private final String crnSuffix;

    public AuthorizeRequest(Principal user, String resourceName, String crnSuffix, SchemaRegistryResourceOperation schemaRegistryResourceOperation, ContainerRequestContext containerRequestContext, HttpServletRequest httpServletRequest) {
        this.user = user;
        this.resourceName = resourceName;
        this.crnSuffix = crnSuffix;
        this.schemaRegistryResourceOperation = schemaRegistryResourceOperation;
        this.containerRequestContext = containerRequestContext;
        this.httpServletRequest = httpServletRequest;
    }

    public AuthorizeRequest(Principal user, String resourceName, SchemaRegistryResourceOperation schemaRegistryResourceOperation, ContainerRequestContext containerRequestContext, HttpServletRequest httpServletRequest) {
        this(user, resourceName, null, schemaRegistryResourceOperation, containerRequestContext, httpServletRequest);
    }

    public Principal getUser() {
        return this.user;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public SchemaRegistryResourceOperation getSchemaRegistryResourceOperation() {
        return this.schemaRegistryResourceOperation;
    }

    public String getCrnSuffix() {
        return this.crnSuffix;
    }

    public ContainerRequestContext getContainerRequestContext() {
        return this.containerRequestContext;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }
}

