/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer;

import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizeRequest;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizerException;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryAuthorizer;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeSchemaRegistryAuthorizer
implements SchemaRegistryAuthorizer {
    private static final Logger log = LoggerFactory.getLogger(CompositeSchemaRegistryAuthorizer.class);
    private List<SchemaRegistryAuthorizer> authorizers;

    public CompositeSchemaRegistryAuthorizer(List<SchemaRegistryAuthorizer> authorizers) {
        this.authorizers = authorizers;
    }

    public CompositeSchemaRegistryAuthorizer(SchemaRegistryAuthorizer ... authorizers) {
        this(Arrays.asList(authorizers));
    }

    @Override
    public void configure(SchemaRegistryConfig config, SchemaRegistry kafkaSchemaRegistry) throws AuthorizerException {
        for (SchemaRegistryAuthorizer authorizer : this.authorizers) {
            try {
                authorizer.configure(config, kafkaSchemaRegistry);
            }
            catch (AuthorizerException e) {
                throw new AuthorizerException("Unable to initialize authorizer class " + authorizer.getClass().getCanonicalName(), e);
            }
        }
    }

    @Override
    public SchemaRegistryAuthorizer.AuthorizerResult authorize(AuthorizeRequest authorizeRequest) {
        return this.authorizers.stream().anyMatch(authorizer -> {
            try {
                return authorizer.authorize(authorizeRequest) == SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED;
            }
            catch (AuthorizerException e) {
                log.error("Exception encountered while authorizing request", (Throwable)e);
                return false;
            }
        }) ? SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED : SchemaRegistryAuthorizer.AuthorizerResult.DENIED;
    }

    @Override
    public void shutdown() {
        this.authorizers.forEach(authorizer -> {
            try {
                authorizer.shutdown();
            }
            catch (Throwable t) {
                log.error("Failed to shut down authorizer", t);
            }
        });
        this.authorizers = null;
    }

    @Override
    public List<SchemaRegistryAuthorizer.AuthorizerResult> bulkAuthorize(Principal principal, List<AuthorizeRequest> authorizeRequests) {
        List<SchemaRegistryAuthorizer.AuthorizerResult> result = IntStream.range(0, authorizeRequests.size()).mapToObj(i -> SchemaRegistryAuthorizer.AuthorizerResult.DENIED).collect(Collectors.toList());
        this.authorizers.forEach(authorizer -> {
            try {
                List<SchemaRegistryAuthorizer.AuthorizerResult> authorizations = authorizer.bulkAuthorize(principal, authorizeRequests);
                for (int i = 0; i < authorizations.size(); ++i) {
                    if (authorizations.get(i) != SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED) continue;
                    result.set(i, SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED);
                }
            }
            catch (AuthorizerException e) {
                log.error("Failed to authorize actions", (Throwable)e);
            }
        });
        return result;
    }
}

