/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer;

import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizeRequest;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizerException;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;

public interface SchemaRegistryAuthorizer {
    public void configure(SchemaRegistryConfig var1, SchemaRegistry var2) throws AuthorizerException;

    public AuthorizerResult authorize(AuthorizeRequest var1) throws AuthorizerException;

    public void shutdown();

    default public List<AuthorizerResult> bulkAuthorize(Principal principal, List<AuthorizeRequest> authorizeRequests) throws AuthorizerException {
        ArrayList<AuthorizerResult> result = new ArrayList<AuthorizerResult>();
        for (AuthorizeRequest authorizeRequest : authorizeRequests) {
            result.add(this.authorize(authorizeRequest));
        }
        return result;
    }

    public static enum AuthorizerResult {
        ALLOWED,
        DENIED,
        IP_FILTERED;

    }
}

