/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer.rbac;

import io.confluent.kafka.schemaregistry.rest.exceptions.RestSchemaRegistryException;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizeRequest;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryResourceOperation;
import io.confluent.kafka.schemaregistry.security.authorizer.rbac.SchemaRegistryOperations;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Scope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryActions {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryActions.class);
    private final Scope scope;

    public SchemaRegistryActions(Scope scope) {
        this.scope = scope;
    }

    public Action subjectAction(SchemaRegistryResourceOperation operation, String subject) {
        return new Action(this.scope, SchemaRegistryOperations.resourceTypeFor(operation), subject, SchemaRegistryOperations.operationFor(operation));
    }

    public Action kekAction(SchemaRegistryResourceOperation operation, String kekName) {
        return new Action(this.scope, SchemaRegistryOperations.resourceTypeFor(operation), kekName, SchemaRegistryOperations.operationFor(operation));
    }

    public Action globalAction(SchemaRegistryResourceOperation operation) {
        return new Action(this.scope, SchemaRegistryOperations.resourceTypeFor(operation), "__GLOBAL", SchemaRegistryOperations.operationFor(operation));
    }

    public Action action(AuthorizeRequest authorizeRequest) {
        SchemaRegistryResourceOperation operation = authorizeRequest.getSchemaRegistryResourceOperation();
        if (SchemaRegistryResourceOperation.SUBJECT_RESOURCE_OPERATIONS.contains((Object)operation)) {
            return this.subjectAction(operation, authorizeRequest.getResourceName());
        }
        if (SchemaRegistryResourceOperation.KEK_RESOURCE_OPERATIONS.contains((Object)operation)) {
            return this.kekAction(operation, authorizeRequest.getResourceName());
        }
        if (SchemaRegistryResourceOperation.GLOBAL_RESOURCE_OPERATIONS.contains((Object)operation)) {
            return this.globalAction(operation);
        }
        RestSchemaRegistryException exception = new RestSchemaRegistryException("Unrecognized schema registry resource operation: " + String.valueOf((Object)operation));
        log.error("Error while determining action for authorize request", (Throwable)exception);
        throw exception;
    }
}

