/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.Min;
import org.hibernate.validator.constraints.NotEmpty;

@JsonPropertyOrder(value={"magic", "principal"})
public abstract class SchemaRegistryAclValue {
    @Min(value=0L)
    protected @Min(value=0L) int magicByte;
    @NotEmpty
    protected String principal;

    public SchemaRegistryAclValue(int magicByte, String principal) {
        this.magicByte = magicByte;
        this.principal = principal;
    }

    @JsonProperty(value="magic")
    public int getMagicByte() {
        return this.magicByte;
    }

    @JsonProperty(value="magic")
    public void setMagicByte(int magicByte) {
        this.magicByte = magicByte;
    }

    @JsonProperty(value="principal")
    public String getPrincipal() {
        return this.principal;
    }

    @JsonProperty(value="principal")
    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SchemaRegistryAclValue that = (SchemaRegistryAclValue)o;
            return this.magicByte != that.magicByte ? false : this.principal.equals(that.principal);
        }
        return false;
    }

    public int hashCode() {
        int result = 31 * this.magicByte;
        result = 31 * result + this.principal.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{magic=" + this.magicByte + ",");
        sb.append("principal=" + this.principal + "}");
        return sb.toString();
    }
}

