/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer.topicacl;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.security.authorizer.AbstractSchemaRegistryAuthorizer;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizeRequest;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizerException;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryAuthorizer;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryResourceOperation;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.network.BrokerFqdnBuilder;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;

public class SimpleTopicAclAuthorizer
extends AbstractSchemaRegistryAuthorizer {
    private Authorizer aclAuthorizer;
    private Set<String> superUsers;
    private static final Map<SchemaRegistryResourceOperation, AclOperation> OPERATION_MAP = new HashMap<SchemaRegistryResourceOperation, AclOperation>();

    public SimpleTopicAclAuthorizer() {
        this((Authorizer)new StandardAuthorizer());
    }

    SimpleTopicAclAuthorizer(Authorizer aclAuthorizer) {
        this.aclAuthorizer = aclAuthorizer;
        this.superUsers = new HashSet<String>();
    }

    @Override
    public void configure(SchemaRegistryConfig config, SchemaRegistry kafkaSchemaRegistry) throws AuthorizerException {
        super.configure(config, kafkaSchemaRegistry);
        this.superUsers.addAll(Arrays.asList(config.getString("confluent.topic.acl.super.users").split(";")));
        this.superUsers.remove("");
        Map topicAclConfig = config.originalsWithPrefix("confluent.topic.acl.");
        Map<String, Object> authorizerConfig = topicAclConfig.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("authorizer.")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ImmutableMap additionalAuthorizerConfig = ImmutableMap.of((Object)"zookeeper.connect", (Object)config.getString("kafkastore.connection.url"), (Object)"allow.everyone.if.no.acl.found", (Object)false, (Object)"super.users", (Object)this.createUserString(this.superUsers));
        authorizerConfig.putAll((Map<String, Object>)additionalAuthorizerConfig);
        this.aclAuthorizer.configure(authorizerConfig);
    }

    @Override
    public SchemaRegistryAuthorizer.AuthorizerResult authorizeGlobalOperation(String user, SchemaRegistryResourceOperation schemaRegistryResourceOperation, AuthorizeRequest originalAuthorizeRequest) {
        return this.superUsers.contains(user) ? SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED : SchemaRegistryAuthorizer.AuthorizerResult.DENIED;
    }

    @Override
    public SchemaRegistryAuthorizer.AuthorizerResult authorizeSubjectOperation(String user, String subject, SchemaRegistryResourceOperation schemaRegistryResourceOperation, AuthorizeRequest originalAuthorizeRequest) {
        InetAddress clientAddress = this.getClientAddress(originalAuthorizeRequest.getHttpServletRequest());
        RequestContext requestContext = new RequestContext(user, clientAddress != null ? clientAddress.getHostAddress() : "");
        ResourcePattern pattern = new ResourcePattern(ResourceType.TOPIC, this.getAuthorizationSubject(subject), PatternType.LITERAL);
        Action action = new Action(OPERATION_MAP.get((Object)schemaRegistryResourceOperation), pattern, 1, false, false);
        List result = this.aclAuthorizer.authorize((AuthorizableRequestContext)requestContext, Collections.singletonList(action));
        return !result.isEmpty() && result.get(0) == AuthorizationResult.ALLOWED ? SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED : SchemaRegistryAuthorizer.AuthorizerResult.DENIED;
    }

    @Override
    public SchemaRegistryAuthorizer.AuthorizerResult authorizeKekOperation(String user, String subject, SchemaRegistryResourceOperation schemaRegistryResourceOperation, AuthorizeRequest originalAuthorizeRequest) {
        return SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED;
    }

    @Override
    public String getAuthorizationSubject(String subject) {
        String topic = this.removeSuffix(subject, "-key");
        topic = this.removeSuffix(topic, "-value");
        return topic;
    }

    private String removeSuffix(String subject, String suffix) {
        if (subject.endsWith(suffix)) {
            subject = subject.substring(0, subject.length() - suffix.length());
        }
        return subject;
    }

    InetAddress getClientAddress(HttpServletRequest request) {
        String ipAddress = request.getHeader("X-FORWARDED-FOR");
        if (ipAddress == null) {
            ipAddress = request.getRemoteAddr();
        }
        try {
            if (ipAddress != null) {
                return InetAddress.getByName(ipAddress);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    private String createUserString(Set<String> superUsers) {
        StringBuilder superUserString = new StringBuilder();
        Iterator<String> superUserIterator = superUsers.iterator();
        while (superUserIterator.hasNext()) {
            if (superUserString.length() != 0) {
                superUserString.append(";");
            }
            superUserString.append("User:" + superUserIterator.next());
        }
        return superUserString.toString();
    }

    static {
        OPERATION_MAP.put(SchemaRegistryResourceOperation.SUBJECT_COMPATIBILITY_READ, AclOperation.READ);
        OPERATION_MAP.put(SchemaRegistryResourceOperation.SUBJECT_READ, AclOperation.READ);
        OPERATION_MAP.put(SchemaRegistryResourceOperation.SCHEMA_READ, AclOperation.READ);
        OPERATION_MAP.put(SchemaRegistryResourceOperation.SUBJECT_COMPATIBILITY_WRITE, AclOperation.WRITE);
        OPERATION_MAP.put(SchemaRegistryResourceOperation.SUBJECT_WRITE, AclOperation.WRITE);
        OPERATION_MAP.put(SchemaRegistryResourceOperation.SUBJECT_DELETE, AclOperation.WRITE);
    }

    protected static class RequestContext
    implements AuthorizableRequestContext {
        private KafkaPrincipal principal;
        private String host;

        public RequestContext(String user, String host) {
            this.principal = new KafkaPrincipal("User", user);
            this.host = host;
        }

        public String listenerName() {
            return null;
        }

        public SecurityProtocol securityProtocol() {
            return null;
        }

        public KafkaPrincipal principal() {
            return this.principal;
        }

        public InetAddress clientAddress() {
            try {
                return InetAddress.getByName(this.host);
            }
            catch (UnknownHostException e) {
                throw new KafkaException((Throwable)e);
            }
        }

        public BrokerFqdnBuilder.FQDNPropertiesFromPPV2 fqdnPropertiesFromPpv2() {
            return null;
        }

        public int requestType() {
            return -1;
        }

        public int requestVersion() {
            return -1;
        }

        public String clientId() {
            return null;
        }

        public int correlationId() {
            return -1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestContext that = (RequestContext)o;
            return Objects.equals(this.principal, that.principal) && Objects.equals(this.host, that.host);
        }

        public int hashCode() {
            return Objects.hash(this.principal, this.host);
        }

        public boolean isProxyModeLocal() {
            return false;
        }
    }
}

