/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.filter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import io.confluent.common.security.util.StreamUtils;
import io.confluent.dekregistry.client.rest.entities.CreateKekRequest;
import io.confluent.dekregistry.web.rest.resources.DekRegistryResource;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.rest.exceptions.RestSchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.resources.CompatibilityResource;
import io.confluent.kafka.schemaregistry.rest.resources.ConfigResource;
import io.confluent.kafka.schemaregistry.rest.resources.ContextsResource;
import io.confluent.kafka.schemaregistry.rest.resources.ModeResource;
import io.confluent.kafka.schemaregistry.rest.resources.RootResource;
import io.confluent.kafka.schemaregistry.rest.resources.SchemasResource;
import io.confluent.kafka.schemaregistry.rest.resources.ServerMetadataResource;
import io.confluent.kafka.schemaregistry.rest.resources.SubjectVersionsResource;
import io.confluent.kafka.schemaregistry.rest.resources.SubjectsResource;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizeRequest;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizerException;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaNotFoundAuthorizerException;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryAuthorizer;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryResourceOperation;
import io.confluent.kafka.schemaregistry.security.authorizer.rbac.SchemaRegistryOperations;
import io.confluent.kafka.schemaregistry.security.config.SecureSchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.security.permissions.PermissionsResource;
import io.confluent.kafka.schemaregistry.security.permissions.ScopeResource;
import io.confluent.kafka.schemaregistry.security.util.CrnConstants;
import io.confluent.kafka.schemaregistry.security.util.CrnElement;
import io.confluent.kafka.schemaregistry.security.util.CrnUtils;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.schema.exporter.web.rest.resources.SchemaExporterResource;
import jakarta.annotation.Priority;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.common.config.ConfigException;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=2000)
public class AuthorizationFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    protected static final int OPERATION_FORBIDDEN_ERROR_CODE = 40301;
    protected static final int IP_FILTERED_ERROR_CODE = 40303;
    private static final Logger log = LoggerFactory.getLogger(AuthorizationFilter.class);
    private static final Map<SchemaRegistryResourceActionKey, SchemaRegistryResourceOperation> schemaRegistryResourceActionMap = new HashMap<SchemaRegistryResourceActionKey, SchemaRegistryResourceOperation>();
    private static final ObjectMapper MAPPER = new ObjectMapper();
    @VisibleForTesting
    SchemaRegistryAuthorizer authorizer;
    private final Boolean schemaLinkingRbacEnabled;
    private final Boolean dekRegistryRbacEnabled;
    @Context
    ResourceInfo resourceInfo;
    @Context
    UriInfo uriInfo;
    @Context
    HttpServletRequest httpServletRequest;

    private static void initializeSchemaRegistryResourceActionMap() {
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(ContextsResource.class, "GET", false), SchemaRegistryResourceOperation.GLOBAL_READ);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SubjectVersionsResource.class, "GET", true), SchemaRegistryResourceOperation.SUBJECT_READ);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SubjectVersionsResource.class, "POST", true), SchemaRegistryResourceOperation.SUBJECT_WRITE);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SubjectVersionsResource.class, "DELETE", true), SchemaRegistryResourceOperation.SUBJECT_DELETE);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SubjectsResource.class, "POST", true), SchemaRegistryResourceOperation.SUBJECT_READ);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SubjectsResource.class, "GET", true), SchemaRegistryResourceOperation.SUBJECT_READ);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SubjectsResource.class, "GET", false), SchemaRegistryResourceOperation.GLOBAL_READ);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SubjectsResource.class, "DELETE", true), SchemaRegistryResourceOperation.SUBJECT_DELETE);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SchemasResource.class, "GET", true), SchemaRegistryResourceOperation.SCHEMA_READ);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SchemasResource.class, "GET", false), SchemaRegistryResourceOperation.GLOBAL_READ);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SchemasResource.class, "getSubjects"), SchemaRegistryResourceOperation.GLOBAL_READ);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SchemasResource.class, "getVersions"), SchemaRegistryResourceOperation.GLOBAL_READ);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(ContextsResource.class, "DELETE", false), SchemaRegistryResourceOperation.AUTHORIZATION_NOT_REQUIRED);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SchemaExporterResource.class, "GET", false), SchemaRegistryResourceOperation.AUTHORIZATION_NOT_REQUIRED);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SchemaExporterResource.class, "POST", false), SchemaRegistryResourceOperation.AUTHORIZATION_NOT_REQUIRED);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SchemaExporterResource.class, "PUT", false), SchemaRegistryResourceOperation.AUTHORIZATION_NOT_REQUIRED);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SchemaExporterResource.class, "DELETE", false), SchemaRegistryResourceOperation.AUTHORIZATION_NOT_REQUIRED);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(ConfigResource.class, "GET", true), SchemaRegistryResourceOperation.SUBJECT_COMPATIBILITY_READ);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(ConfigResource.class, "PUT", true), SchemaRegistryResourceOperation.SUBJECT_COMPATIBILITY_WRITE);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(ConfigResource.class, "DELETE", true), SchemaRegistryResourceOperation.SUBJECT_COMPATIBILITY_WRITE);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(ConfigResource.class, "GET", false), SchemaRegistryResourceOperation.GLOBAL_COMPATIBILITY_READ);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(ConfigResource.class, "PUT", false), SchemaRegistryResourceOperation.GLOBAL_COMPATIBILITY_WRITE);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(ConfigResource.class, "DELETE", false), SchemaRegistryResourceOperation.GLOBAL_COMPATIBILITY_WRITE);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(ModeResource.class, "GET", true), SchemaRegistryResourceOperation.SUBJECT_COMPATIBILITY_READ);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(ModeResource.class, "PUT", true), SchemaRegistryResourceOperation.SUBJECT_COMPATIBILITY_WRITE);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(ModeResource.class, "DELETE", true), SchemaRegistryResourceOperation.SUBJECT_COMPATIBILITY_WRITE);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(ModeResource.class, "GET", false), SchemaRegistryResourceOperation.GLOBAL_COMPATIBILITY_READ);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(ModeResource.class, "PUT", false), SchemaRegistryResourceOperation.GLOBAL_COMPATIBILITY_WRITE);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(CompatibilityResource.class, "POST", true), SchemaRegistryResourceOperation.SUBJECT_WRITE);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(RootResource.class, "POST", false), SchemaRegistryResourceOperation.AUTHORIZATION_NOT_REQUIRED);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(RootResource.class, "GET", false), SchemaRegistryResourceOperation.AUTHORIZATION_NOT_REQUIRED);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(PermissionsResource.class, "GET", false), SchemaRegistryResourceOperation.AUTHORIZATION_NOT_REQUIRED);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(ScopeResource.class, "GET", false), SchemaRegistryResourceOperation.AUTHORIZATION_NOT_REQUIRED);
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(ServerMetadataResource.class, "GET", false), SchemaRegistryResourceOperation.AUTHORIZATION_NOT_REQUIRED);
    }

    protected static void addResourceAction(Class className, String restMethod, Boolean nonGlobalRequest, SchemaRegistryResourceOperation schemaRegistryResourceOperation) {
        schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(className, restMethod, nonGlobalRequest), schemaRegistryResourceOperation);
    }

    public AuthorizationFilter(SecureSchemaRegistryConfig secureSchemaRegistryConfig, SchemaRegistry kafkaSchemaRegistry) {
        String authorizerClassName = secureSchemaRegistryConfig.getString("confluent.schema.registry.authorizer.class");
        this.schemaLinkingRbacEnabled = secureSchemaRegistryConfig.getBoolean("schema.linking.rbac.enable");
        this.dekRegistryRbacEnabled = secureSchemaRegistryConfig.getBoolean("dek.registry.rbac.enable");
        if (StringUtil.isNotBlank((String)authorizerClassName)) {
            try {
                Class<?> schemaRegistryAuthorizerClass = Class.forName(authorizerClassName);
                this.authorizer = (SchemaRegistryAuthorizer)schemaRegistryAuthorizerClass.newInstance();
                this.authorizer.configure(secureSchemaRegistryConfig, kafkaSchemaRegistry);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RestSchemaRegistryException("Unable to load resource extension class " + authorizerClassName + ". Check your classpath and that the configured class implements the SchemaRegistryAuthorizer interface.");
            }
            catch (AuthorizerException e) {
                throw new RestSchemaRegistryException("Unable to initialize the authorizer " + authorizerClassName, (Throwable)e);
            }
        } else {
            throw new ConfigException(String.format("No authorizer class provided. Please specify an authorizer class via the '%s' configuration property", "confluent.schema.registry.authorizer.class"));
        }
        this.enableSchemaLinkingRbac();
        this.enableDekRegistryRbac();
    }

    private void enableSchemaLinkingRbac() {
        if (this.schemaLinkingRbacEnabled.booleanValue()) {
            schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SchemaExporterResource.class, "DELETE", false), SchemaRegistryResourceOperation.EXPORTER_ACCESS);
            schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SchemaExporterResource.class, "POST", false), SchemaRegistryResourceOperation.EXPORTER_ACCESS);
            schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SchemaExporterResource.class, "PUT", false), SchemaRegistryResourceOperation.EXPORTER_ACCESS);
            schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(SchemaExporterResource.class, "GET", false), SchemaRegistryResourceOperation.EXPORTER_ACCESS);
        }
    }

    private void enableDekRegistryRbac() {
        if (this.dekRegistryRbacEnabled.booleanValue()) {
            schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(DekRegistryResource.class, "GET", true), SchemaRegistryResourceOperation.KEK_READ);
            schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(DekRegistryResource.class, "createKek"), SchemaRegistryResourceOperation.KEK_REGISTER);
            schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(DekRegistryResource.class, "POST", true), SchemaRegistryResourceOperation.KEK_REGISTER);
            schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(DekRegistryResource.class, "PUT", true), SchemaRegistryResourceOperation.KEK_UPDATE);
            schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(DekRegistryResource.class, "DELETE", true), SchemaRegistryResourceOperation.KEK_DEREGISTER);
            schemaRegistryResourceActionMap.put(new SchemaRegistryResourceActionKey(DekRegistryResource.class, "GET", false), SchemaRegistryResourceOperation.GLOBAL_READ);
        }
    }

    public void filter(ContainerRequestContext requestContext) {
        SchemaRegistryResourceOperation schemaRegistryResourceOperation = this.operation(requestContext);
        if (SchemaRegistryResourceOperation.AUTHORIZATION_NOT_REQUIRED.equals((Object)schemaRegistryResourceOperation)) {
            return;
        }
        if (schemaRegistryResourceOperation == null) {
            log.error(String.format("Couldn't find a corresponding operation to authorize for  %s:%s.Possibly using an older version of plugin ", this.resourceInfo.getResourceClass(), this.resourceInfo.getResourceMethod()));
            requestContext.abortWith(this.accessDenied("User cannot access the resource."));
            return;
        }
        try {
            String resourceName = null;
            String crnSuffix = "";
            if (SchemaRegistryResourceOperation.SUBJECT_RESOURCE_OPERATIONS.contains((Object)schemaRegistryResourceOperation)) {
                resourceName = this.currentSubject();
                crnSuffix = CrnUtils.buildCrnSuffix(CrnElement.of(CrnConstants.CrnResourceType.SchemaRegistrySubject, this.currentSubject()));
            } else if (SchemaRegistryResourceOperation.KEK_RESOURCE_OPERATIONS.contains((Object)schemaRegistryResourceOperation)) {
                resourceName = this.getKekName(requestContext);
            }
            SchemaRegistryAuthorizer.AuthorizerResult authorizeResult = this.authorizer.authorize(new AuthorizeRequest(requestContext.getSecurityContext().getUserPrincipal(), resourceName, crnSuffix, schemaRegistryResourceOperation, requestContext, this.httpServletRequest));
            if (authorizeResult == SchemaRegistryAuthorizer.AuthorizerResult.DENIED) {
                requestContext.abortWith(this.accessDenied(this.operationDeniedMessage(schemaRegistryResourceOperation, resourceName)));
            } else if (authorizeResult == SchemaRegistryAuthorizer.AuthorizerResult.IP_FILTERED) {
                requestContext.abortWith(this.ipFiltered(this.operationDeniedMessage(schemaRegistryResourceOperation, resourceName)));
            }
        }
        catch (SchemaNotFoundAuthorizerException e) {
            requestContext.abortWith(this.notFound("schema not found"));
        }
        catch (AuthorizerException e) {
            requestContext.abortWith(this.accessDenied("error authorizing the resource"));
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        Class resourceClass = this.resourceInfo.getResourceClass();
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        if (responseContext.getStatus() == Response.Status.OK.getStatusCode() && SchemaRegistryResourceOperation.GLOBAL_READ.equals((Object)this.operation(requestContext))) {
            List schemas;
            if (this.isSubjectListOperation()) {
                Set subjects = (Set)AuthorizationFilter.readEntity(responseContext);
                if (subjects != null) {
                    responseContext.setEntity(this.authorizedResources(requestContext, subjects, SchemaRegistryResourceOperation.SUBJECT_COMPATIBILITY_READ));
                }
            } else if (this.isKekListOperation()) {
                List kekNames = (List)AuthorizationFilter.readEntity(responseContext);
                if (kekNames != null) {
                    responseContext.setEntity(this.authorizedResources(requestContext, new HashSet<String>(kekNames), SchemaRegistryResourceOperation.KEK_READ));
                }
            } else if (SchemasResource.class.equals((Object)resourceClass) && resourceMethod.getName().equals("getVersions")) {
                List subjectVersions = (List)AuthorizationFilter.readEntity(responseContext);
                if (subjectVersions != null) {
                    responseContext.setEntity(this.authorizedSubjectVersionsForReading(requestContext, subjectVersions));
                }
            } else if (SchemasResource.class.equals((Object)resourceClass) && resourceMethod.getName().equals("getSchemas") && (schemas = (List)AuthorizationFilter.readEntity(responseContext)) != null) {
                responseContext.setEntity(this.authorizedSchemasForReading(requestContext, schemas));
            }
        }
    }

    private boolean isSubjectListOperation() {
        Class resourceClass = this.resourceInfo.getResourceClass();
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        return SubjectsResource.class.equals((Object)resourceClass) || SchemasResource.class.equals((Object)resourceClass) && resourceMethod.getName().equals("getSubjects");
    }

    private boolean isKekListOperation() {
        Class resourceClass = this.resourceInfo.getResourceClass();
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        return DekRegistryResource.class.equals((Object)resourceClass) && resourceMethod.getName().equals("getKekNames");
    }

    static <T> T readEntity(ContainerResponseContext responseContext) {
        return (T)responseContext.getEntity();
    }

    Set<String> authorizedResources(ContainerRequestContext requestContext, Set<String> allResources, SchemaRegistryResourceOperation op) {
        List authorizations;
        if (allResources.isEmpty()) {
            return allResources;
        }
        Principal principal = requestContext.getSecurityContext().getUserPrincipal();
        ArrayList<AuthorizeRequest> authorizeRequests = new ArrayList<AuthorizeRequest>();
        allResources.forEach(resourceName -> authorizeRequests.add(new AuthorizeRequest(principal, (String)resourceName, op, requestContext, this.httpServletRequest)));
        try {
            authorizations = this.authorizer.bulkAuthorize(principal, authorizeRequests).stream().map(result -> result == SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED).collect(Collectors.toList());
        }
        catch (AuthorizerException e) {
            throw new RestSchemaRegistryException("error authorizing the resource", (Throwable)e);
        }
        return StreamUtils.zip(authorizations, authorizeRequests).filter(Pair::getLeft).map(p -> ((AuthorizeRequest)p.getRight()).getResourceName()).collect(Collectors.toSet());
    }

    List<Schema> authorizedSchemasForReading(ContainerRequestContext requestContext, List<Schema> schemas) {
        List authorizations;
        if (schemas.isEmpty()) {
            return schemas;
        }
        Set<String> subjects = schemas.stream().map(Schema::getSubject).collect(Collectors.toSet());
        Principal principal = requestContext.getSecurityContext().getUserPrincipal();
        ArrayList<AuthorizeRequest> authorizeRequests = new ArrayList<AuthorizeRequest>();
        subjects.forEach(subject -> authorizeRequests.add(new AuthorizeRequest(principal, (String)subject, SchemaRegistryResourceOperation.SUBJECT_READ, requestContext, this.httpServletRequest)));
        try {
            authorizations = this.authorizer.bulkAuthorize(principal, authorizeRequests).stream().map(result -> result == SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED).collect(Collectors.toList());
        }
        catch (AuthorizerException e) {
            throw new RestSchemaRegistryException("error authorizing the resource", (Throwable)e);
        }
        Set authorizedSubjects = StreamUtils.zip(authorizations, authorizeRequests).filter(Pair::getLeft).map(p -> ((AuthorizeRequest)p.getRight()).getResourceName()).collect(Collectors.toSet());
        return schemas.stream().filter((? super T schema) -> authorizedSubjects.contains(schema.getSubject())).collect(Collectors.toList());
    }

    List<SubjectVersion> authorizedSubjectVersionsForReading(ContainerRequestContext requestContext, List<SubjectVersion> subjectVersions) {
        List authorizations;
        if (subjectVersions.isEmpty()) {
            return subjectVersions;
        }
        Set<String> subjects = subjectVersions.stream().map(SubjectVersion::getSubject).collect(Collectors.toSet());
        Principal principal = requestContext.getSecurityContext().getUserPrincipal();
        ArrayList<AuthorizeRequest> authorizeRequests = new ArrayList<AuthorizeRequest>();
        subjects.forEach(subject -> authorizeRequests.add(new AuthorizeRequest(principal, (String)subject, SchemaRegistryResourceOperation.SUBJECT_COMPATIBILITY_READ, requestContext, this.httpServletRequest)));
        try {
            authorizations = this.authorizer.bulkAuthorize(principal, authorizeRequests).stream().map(result -> result == SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED).collect(Collectors.toList());
        }
        catch (AuthorizerException e) {
            throw new RestSchemaRegistryException("error authorizing the resource", (Throwable)e);
        }
        Set authorizedSubjects = StreamUtils.zip(authorizations, authorizeRequests).filter(Pair::getLeft).map(p -> ((AuthorizeRequest)p.getRight()).getResourceName()).collect(Collectors.toSet());
        return subjectVersions.stream().filter((? super T subjectVersion) -> authorizedSubjects.contains(subjectVersion.getSubject())).collect(Collectors.toList());
    }

    public void shutdown() {
        this.authorizer.shutdown();
    }

    protected SchemaRegistryResourceOperation operation(ContainerRequestContext requestContext) {
        if (this.resourceInfo.getResourceMethod() == null || this.resourceInfo.getResourceClass() == null) {
            return null;
        }
        Class resourceClass = this.resourceInfo.getResourceClass();
        String restMethod = requestContext.getMethod();
        String restMethodName = this.resourceInfo.getResourceMethod().getName();
        SchemaRegistryResourceActionKey methodNameKey = new SchemaRegistryResourceActionKey(resourceClass, restMethodName);
        if (schemaRegistryResourceActionMap.containsKey(methodNameKey)) {
            return schemaRegistryResourceActionMap.get(methodNameKey);
        }
        return schemaRegistryResourceActionMap.get(new SchemaRegistryResourceActionKey(resourceClass, restMethod, this.isNonGlobalRequest()));
    }

    protected boolean isNonGlobalRequest() {
        return StringUtil.isNotBlank((String)this.currentSubject()) || StringUtil.isNotBlank((String)this.currentSchemaId()) || StringUtil.isNotBlank((String)this.currentKek());
    }

    protected String currentSubject() {
        return (String)this.uriInfo.getPathParameters().getFirst((Object)"subject");
    }

    protected String currentSchemaId() {
        return (String)this.uriInfo.getPathParameters().getFirst((Object)"id");
    }

    protected String currentKek() {
        Class resourceClass = this.resourceInfo.getResourceClass();
        if (!DekRegistryResource.class.equals((Object)resourceClass)) {
            return null;
        }
        return (String)this.uriInfo.getPathParameters().getFirst((Object)"name");
    }

    private String getKekName(ContainerRequestContext requestContext) {
        Class resourceClass = this.resourceInfo.getResourceClass();
        if (!DekRegistryResource.class.equals((Object)resourceClass)) {
            return null;
        }
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        if (resourceMethod.getName().equals("createKek")) {
            try {
                String json = IOUtils.toString((InputStream)requestContext.getEntityStream(), (Charset)Charsets.UTF_8);
                InputStream in = IOUtils.toInputStream((String)json, (Charset)StandardCharsets.UTF_8);
                requestContext.setEntityStream(in);
                CreateKekRequest createKekRequest = (CreateKekRequest)MAPPER.readValue(json, (TypeReference)new TypeReference<CreateKekRequest>(){});
                return createKekRequest.getName();
            }
            catch (IOException e) {
                log.error("Error parsing createKek request body", (Throwable)e);
                return null;
            }
        }
        return this.currentKek();
    }

    public SchemaRegistryAuthorizer authorizer() {
        return this.authorizer;
    }

    private String operationDeniedMessage(SchemaRegistryResourceOperation operation, String subject) {
        String errorMessage;
        try {
            String deniedOperation = SchemaRegistryOperations.operationFor(operation).name();
            String resource = SchemaRegistryOperations.resourceTypeFor(operation).name();
            errorMessage = SchemaRegistryResourceOperation.SUBJECT_RESOURCE_OPERATIONS.contains((Object)operation) || SchemaRegistryResourceOperation.KEK_RESOURCE_OPERATIONS.contains((Object)operation) ? String.format("User is denied operation %s on %s: %s", deniedOperation, resource, subject) : String.format("User is denied operation %s on this server.", deniedOperation);
        }
        catch (RestSchemaRegistryException e) {
            errorMessage = "User is denied operation on this server.";
        }
        return errorMessage;
    }

    protected Response accessDenied(String msg) {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ImmutableMap.of((Object)"error_code", (Object)40301, (Object)"message", (Object)msg)).build();
    }

    protected Response ipFiltered(String msg) {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ImmutableMap.of((Object)"error_code", (Object)40303, (Object)"message", (Object)msg)).build();
    }

    protected Response notFound(String msg) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error_code", (Object)40403, (Object)"message", (Object)msg)).build();
    }

    static {
        AuthorizationFilter.initializeSchemaRegistryResourceActionMap();
    }

    private static class SchemaRegistryResourceActionKey {
        private Class resourceClass;
        private String restMethod;
        private boolean subjectRequest;
        private final String restMethodName;

        public SchemaRegistryResourceActionKey(Class resourceClass, String restMethod, boolean nonGlobalRequest) {
            this.resourceClass = resourceClass;
            this.restMethod = restMethod;
            this.subjectRequest = nonGlobalRequest;
            this.restMethodName = "";
        }

        public SchemaRegistryResourceActionKey(Class resourceClass, String restMethodName) {
            this.resourceClass = resourceClass;
            this.restMethodName = restMethodName;
            this.restMethod = "";
            this.subjectRequest = false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemaRegistryResourceActionKey that = (SchemaRegistryResourceActionKey)o;
            if (this.subjectRequest != that.subjectRequest) {
                return false;
            }
            if (!this.resourceClass.equals(that.resourceClass)) {
                return false;
            }
            if (!this.restMethodName.equals(that.restMethodName)) {
                return false;
            }
            return this.restMethod.equals(that.restMethod);
        }

        public int hashCode() {
            int result = this.resourceClass.hashCode();
            result = 31 * result + this.restMethod.hashCode();
            result = 31 * result + this.restMethodName.hashCode();
            result = 31 * result + (this.subjectRequest ? 1 : 0);
            return result;
        }
    }
}

