/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.license;

import io.confluent.common.security.license.MultiLicenseBackgroundFetcher;
import io.confluent.kafka.schemaregistry.security.config.SecureSchemaRegistryConfig;
import io.confluent.license.License;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicensePrivilegeManager {
    private static final Logger log = LoggerFactory.getLogger(LicensePrivilegeManager.class);

    public static LogMessageType logLicenseMessages(List<License> licenses) {
        if (licenses == null || licenses.isEmpty()) {
            return LicensePrivilegeManager.logCommunityWarning();
        }
        LicensePrivilegeLevel highestPrivilege = LicensePrivilegeManager.determineHighestPrivilegeLevel(licenses);
        switch (highestPrivilege) {
            case ENTERPRISE: {
                return LogMessageType.ENTERPRISE;
            }
            case CP_FOR_CC: {
                return LicensePrivilegeManager.logCpForCcWarning();
            }
        }
        return LicensePrivilegeManager.logCommunityWarning();
    }

    public static LogMessageType logCpForCcWarning() {
        log.warn("Your license for Customer-Managed Confluent Platform for Confluent Cloud may be used solely to access and use the Cloud Service. When operating under this specific license, Confluent does not provide support for any self-managed (Confluent Platform) components utilised exclusively for Confluent Platform broker use cases. To be eligible for support, you must ensure you are connecting to a Confluent Cloud broker or are utilising a valid Enterprise license for a Confluent Platform subscription.");
        return LogMessageType.CP_FOR_CC;
    }

    public static LogMessageType logCommunityWarning() {
        log.warn("No Enterprise license detected. Confluent does not offer Enterprise support for any self-managed (Confluent Platform) components without a valid Enterprise license");
        return LogMessageType.COMMUNITY;
    }

    public static LicensePrivilegeLevel determineHighestPrivilegeLevel(List<License> licenses) {
        LicensePrivilegeLevel highestPrivilege = LicensePrivilegeLevel.NONE;
        for (License license : licenses) {
            if (license == null || !license.isValid()) continue;
            LicensePrivilegeLevel currentPrivilege = LicensePrivilegeManager.getLicensePrivilegeLevel(license);
            if (currentPrivilege.ordinal() < highestPrivilege.ordinal()) {
                highestPrivilege = currentPrivilege;
            }
            if (highestPrivilege != LicensePrivilegeLevel.ENTERPRISE) continue;
            break;
        }
        return highestPrivilege;
    }

    public static LicensePrivilegeLevel getLicensePrivilegeLevel(License license) {
        License.Type licenseType = license.type();
        if ((licenseType == License.Type.ENTERPRISE || licenseType == License.Type.CSFLE) && license.deploymentScope() != License.DeploymentScope.CP_FOR_CC) {
            return LicensePrivilegeLevel.ENTERPRISE;
        }
        if (license.deploymentScope() == License.DeploymentScope.CP_FOR_CC) {
            return LicensePrivilegeLevel.CP_FOR_CC;
        }
        return LicensePrivilegeLevel.COMMUNITY;
    }

    public static void registerLicenseWithFetcher(SecureSchemaRegistryConfig config, MultiLicenseBackgroundFetcher licenseBackgroundFetcher) {
        try {
            String licenseString = config.licenseString();
            if (licenseString != null && !licenseString.trim().isEmpty()) {
                log.info("Registering configured license with MultiLicenseBackgroundFetcher");
                licenseBackgroundFetcher.registerLicenseThenNotify(licenseString, Boolean.valueOf(true));
                log.info("Successfully registered configured license");
            } else {
                log.info("No license configured, generating trial license for license attribution");
                licenseBackgroundFetcher.registerLicenseThenNotify("", Boolean.valueOf(false));
                log.info("Successfully registered trial license for license attribution");
            }
        }
        catch (Exception e) {
            log.error("Failed to register license with MultiLicenseBackgroundFetcher. License attribution may not work correctly.", (Throwable)e);
        }
    }

    public static enum LogMessageType {
        ENTERPRISE,
        CP_FOR_CC,
        COMMUNITY,
        NONE;

    }

    public static enum LicensePrivilegeLevel {
        ENTERPRISE,
        CP_FOR_CC,
        COMMUNITY,
        NONE;

    }
}

