/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.permissions;

import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizeRequest;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizerException;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryAuthorizer;
import io.confluent.kafka.schemaregistry.security.authorizer.rbac.SchemaRegistryOperations;
import io.confluent.kafka.schemaregistry.security.permissions.entities.Permissions;
import io.confluent.kafka.schemaregistry.security.permissions.entities.PermittedOperations;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.roledefinitions.ResourceType;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class PermissionsBuilder {
    private final Principal principal;
    private final LinkedHashMap<ResourceType, LinkedHashMap<String, List<AuthorizeRequest>>> permissionsRequests;
    private SchemaRegistryAuthorizer authorizer;
    private Scope scope;

    public PermissionsBuilder(Principal principal) {
        this.principal = principal;
        this.permissionsRequests = new LinkedHashMap();
        this.authorizer = null;
        this.scope = null;
    }

    public PermissionsBuilder withAuthorizer(SchemaRegistryAuthorizer authorizer) {
        Objects.requireNonNull(authorizer, "Authorizer cannot be null");
        if (this.authorizer != null) {
            throw new IllegalStateException("An authorizer has already been specified");
        }
        this.authorizer = authorizer;
        return this;
    }

    public PermissionsBuilder withRequests(ResourceType resourceType, String resource, List<AuthorizeRequest> requests) {
        Objects.requireNonNull(resourceType, "Resource type cannot be null");
        Objects.requireNonNull(resource, "Resource cannot be null");
        Objects.requireNonNull(requests, "List of requests cannot be null");
        requests.forEach(request -> {
            Objects.requireNonNull(request, "Requests cannot be null");
            if (!this.principal.equals(request.getUser())) {
                throw new IllegalArgumentException(String.format("Principal for authorize request %s does not match expected principal of %s", request, this.principal));
            }
        });
        this.permissionsRequests.computeIfAbsent(resourceType, k -> new LinkedHashMap()).computeIfAbsent(resource, k -> new ArrayList()).addAll(requests);
        return this;
    }

    public PermissionsBuilder withRequest(ResourceType resourceType, String resource, AuthorizeRequest request) {
        return this.withRequests(resourceType, resource, Collections.singletonList(request));
    }

    public PermissionsBuilder withScope(Scope scope) {
        Objects.requireNonNull(scope, "Scope cannot be null");
        if (this.scope != null) {
            throw new IllegalStateException("A scope has already been specified");
        }
        this.scope = scope;
        return this;
    }

    public Permissions build() throws AuthorizerException {
        if (this.authorizer == null) {
            throw new IllegalStateException("An authorizer must be provided before building permissions");
        }
        List<AuthorizeRequest> bulkRequests = this.permissionsRequests.values().stream().flatMap(m -> m.values().stream()).flatMap(Collection::stream).collect(Collectors.toList());
        List authorizations = this.authorizer.bulkAuthorize(this.principal, bulkRequests).stream().map(result -> result == SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED).collect(Collectors.toList());
        HashMap<ResourceType, Map<String, PermittedOperations>> permissions = new HashMap<ResourceType, Map<String, PermittedOperations>>();
        int i = 0;
        for (Map.Entry<ResourceType, LinkedHashMap<String, List<AuthorizeRequest>>> requestsByResourceByResourceType : this.permissionsRequests.entrySet()) {
            for (Map.Entry<String, List<AuthorizeRequest>> requestsByResource : requestsByResourceByResourceType.getValue().entrySet()) {
                ArrayList<String> permittedOperations = new ArrayList<String>();
                for (AuthorizeRequest authorizeRequest : requestsByResource.getValue()) {
                    if (((Boolean)authorizations.get(i)).booleanValue()) {
                        permittedOperations.add(SchemaRegistryOperations.operationFor(authorizeRequest.getSchemaRegistryResourceOperation()).toString());
                    }
                    ++i;
                }
                if (permittedOperations.isEmpty()) continue;
                permissions.computeIfAbsent(requestsByResourceByResourceType.getKey(), k -> new HashMap()).put(requestsByResource.getKey(), new PermittedOperations(permittedOperations));
            }
        }
        return new Permissions(permissions, this.scope);
    }
}

