/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.tools;

import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryResourceOperation;
import io.confluent.kafka.schemaregistry.security.config.SecureSchemaRegistryConfig;
import io.confluent.rest.RestConfigException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.BuiltinHelpFormatter;
import joptsimple.HelpFormatter;
import joptsimple.OptionDescriptor;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.kafka.server.util.CommandLineUtils;
import org.eclipse.jetty.util.StringUtil;

public class SchemaRegistryAclCommandOptions {
    private static final String NEW_LINE = System.lineSeparator();
    public static final String OPERATION_DESC = "Operation that is being authorized. Valid operation names are: " + NEW_LINE + String.valueOf(SchemaRegistryResourceOperation.ACL_COMMAND_OPERATIONS) + NEW_LINE;
    public static final String LIST_DESC = "List all the current ACLs";
    public static final String REMOVE_DESC = "Indicates you are trying to remove ACLs.";
    public static final String ADD_DESC = "Indicates you are trying to add ACLs.";
    public static final String PROP_DESC = "REQUIRED: Schema Registry properties file";
    public static final String TOPIC_DESC = "Topic to which the ACL is being applied to. The corresponding subjects would topic-key and topic-value.Only applicable for SUBJECT operations. Use * to apply to all subjects";
    public static final String SUBJECT_DESC = "Subject to which the ACL is being applied to. Only applicable for SUBJECT operations. Use * to apply to all subjects";
    public static final String PRINCIPAL_DESC = "Principal to which the ACL is being applied to. Use * to apply to all principals";
    public static final String GLOBAL_SUBJECTS_READ = "GLOBAL_SUBJECTS_READ";
    private final OptionSet options;
    private final OptionParser parser = new OptionParser(false);
    private final ArgumentAcceptingOptionSpec<File> authorizerPropertiesOpt;
    private final OptionSpecBuilder addOpt;
    private final OptionSpecBuilder removeOpt;
    private final OptionSpecBuilder listOpt;
    private final OptionSpec<String> operationsOpt;
    private final OptionSpec<String> subjectOpt;
    private final OptionSpec<String> topicOpt;
    private final OptionSpec<String> principalOpt;
    private final OptionSpecBuilder helpOpt = this.parser.acceptsAll((List)ImmutableList.of((Object)"h", (Object)"help"), "Print usage information.");
    private final Set<SchemaRegistryResourceOperation> requestedOperations;
    private List<String> principals;
    private List<String> subjects;
    private SecureSchemaRegistryConfig config;
    private boolean hasGlobalOperations;
    private boolean hasSubjectOperations;
    private static final String ANY = "*";
    private static final List<String> ANY_LIST = ImmutableList.of((Object)"*");

    public SchemaRegistryAclCommandOptions(String[] args) {
        this.addOpt = this.parser.accepts("add", ADD_DESC);
        this.removeOpt = this.parser.accepts("remove", REMOVE_DESC);
        this.listOpt = this.parser.accepts("list", LIST_DESC);
        this.authorizerPropertiesOpt = this.parser.acceptsAll((List)ImmutableList.of((Object)"config"), PROP_DESC).withRequiredArg().ofType(File.class);
        this.operationsOpt = this.parser.acceptsAll((List)ImmutableList.of((Object)"o", (Object)"operation"), OPERATION_DESC).withRequiredArg().ofType(String.class).withValuesSeparatedBy(":");
        this.subjectOpt = this.parser.acceptsAll((List)ImmutableList.of((Object)"s", (Object)"subject"), SUBJECT_DESC).withRequiredArg().ofType(String.class);
        this.topicOpt = this.parser.acceptsAll((List)ImmutableList.of((Object)"t", (Object)"topic"), TOPIC_DESC).withRequiredArg().ofType(String.class).withValuesSeparatedBy(":");
        this.principalOpt = this.parser.acceptsAll((List)ImmutableList.of((Object)"p", (Object)"principal"), PRINCIPAL_DESC).withRequiredArg().ofType(String.class).withValuesSeparatedBy(":");
        this.options = this.parser.parse(args);
        this.parser.formatHelpWith((HelpFormatter)new BuiltinHelpFormatter(80, 4){

            public String format(Map<String, ? extends OptionDescriptor> options) {
                this.addRows(new LinkedHashSet<OptionDescriptor>(options.values()));
                return this.formattedHelpOutput();
            }
        });
        this.requestedOperations = EnumSet.noneOf(SchemaRegistryResourceOperation.class);
    }

    public void parseAndValidateArgs() throws RestConfigException, IOException {
        if (this.options.has((OptionSpec)this.helpOpt) || !this.options.hasOptions()) {
            this.printUsageAndDie("Usage:");
        }
        OptionSpecBuilder action = null;
        int actions = 0;
        for (Object optionSpec : ImmutableList.of((Object)this.listOpt, (Object)this.addOpt, (Object)this.removeOpt)) {
            if (!this.options.has((OptionSpec)optionSpec)) continue;
            action = optionSpec;
            ++actions;
        }
        if (actions != 1) {
            this.printUsageAndDie("Command must include exactly one action: --list, --add, --remove. ");
        }
        if (this.listOpt.equals(action)) {
            ArrayList invalidSpecs = new ArrayList(this.options.specs());
            invalidSpecs.remove(this.listOpt);
            invalidSpecs.remove(this.authorizerPropertiesOpt);
            if (invalidSpecs.size() != 0) {
                this.printUsageAndDie(String.format("Can't use %s with --list", invalidSpecs));
            }
        } else {
            CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.authorizerPropertiesOpt, this.principalOpt, this.operationsOpt});
        }
        ArrayList<String> operations = new ArrayList<String>(this.options.valuesOf(this.operationsOpt));
        if (operations.contains(ANY)) {
            operations.clear();
            for (SchemaRegistryResourceOperation schemaRegistryResourceOperation : SchemaRegistryResourceOperation.ACL_COMMAND_OPERATIONS) {
                operations.add(schemaRegistryResourceOperation.name());
            }
        }
        for (String string : operations) {
            try {
                SchemaRegistryResourceOperation registryResourceOperation = SchemaRegistryAclCommandOptions.fromString(string.toUpperCase());
                this.hasGlobalOperations |= SchemaRegistryResourceOperation.GLOBAL_RESOURCE_OPERATIONS.contains((Object)registryResourceOperation);
                this.hasSubjectOperations |= SchemaRegistryResourceOperation.SUBJECT_RESOURCE_OPERATIONS.contains((Object)registryResourceOperation);
                this.requestedOperations.add(registryResourceOperation);
            }
            catch (IllegalArgumentException e) {
                this.printUsageAndDie("Invalid operation specified : " + string);
            }
        }
        if (this.hasSubjectOperations && !this.options.has(this.subjectOpt) && !this.options.has(this.topicOpt)) {
            this.printUsageAndDie("Subject/Topic needs to be specified when applying ACL's to subject operations" + String.valueOf(SchemaRegistryResourceOperation.SUBJECT_RESOURCE_OPERATIONS));
        }
        if (this.hasGlobalOperations && !this.hasSubjectOperations && (this.options.has(this.subjectOpt) || this.options.has(this.topicOpt))) {
            this.printUsageAndDie("Subject/Topic can't be specified when applying ACL's to only Global operations" + String.valueOf(SchemaRegistryResourceOperation.GLOBAL_RESOURCE_OPERATIONS));
        }
        Properties authorizerProps = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream((File)this.options.valueOf(this.authorizerPropertiesOpt));){
            authorizerProps.load(fileInputStream);
        }
        this.config = new SecureSchemaRegistryConfig(authorizerProps);
        if (StringUtil.isBlank((String)this.config.bootstrapBrokers())) {
            this.printUsageAndDie("Kafka connection details is required");
        }
        this.principals = this.options.valuesOf(this.principalOpt);
        this.subjects = new ArrayList<String>();
        this.subjects.addAll(this.options.valuesOf(this.subjectOpt));
        for (String topic : this.options.valuesOf(this.topicOpt)) {
            if (ANY.equals(topic)) {
                this.subjects.add(ANY);
                continue;
            }
            this.subjects.add(topic + "-key");
            this.subjects.add(topic + "-value");
        }
    }

    public static SchemaRegistryResourceOperation fromString(String operation) {
        if (GLOBAL_SUBJECTS_READ.equals(operation)) {
            operation = SchemaRegistryResourceOperation.GLOBAL_READ.name();
        }
        return SchemaRegistryResourceOperation.valueOf(operation);
    }

    public Set<SchemaRegistryResourceOperation> getRequestedOperations() {
        return this.requestedOperations;
    }

    public List<String> getPrincipals() {
        if (this.principals.contains(ANY)) {
            return ANY_LIST;
        }
        return this.principals;
    }

    public List<String> getSubjects() {
        if (this.subjects.contains(ANY)) {
            return ANY_LIST;
        }
        return this.subjects;
    }

    public SecureSchemaRegistryConfig getConfig() {
        return this.config;
    }

    public boolean isListCommand() {
        return this.options.has((OptionSpec)this.listOpt);
    }

    public boolean isAddCommand() {
        return this.options.has((OptionSpec)this.addOpt);
    }

    public boolean isRemoveCommand() {
        return this.options.has((OptionSpec)this.removeOpt);
    }

    public boolean hasGlobalOperations() {
        return this.hasGlobalOperations;
    }

    public boolean hasSubjectOperations() {
        return this.hasSubjectOperations;
    }

    public void printUsageAndDie(String message) {
        CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)message);
    }
}

