/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ReportQuotaConsumptionRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class ReportQuotaConsumptionRequestDataJsonConverter {
    public static ReportQuotaConsumptionRequestData read(JsonNode _node, short _version) {
        ReportQuotaConsumptionRequestData _object = new ReportQuotaConsumptionRequestData();
        JsonNode _brokerIdNode = _node.get("brokerId");
        if (_brokerIdNode == null) {
            throw new RuntimeException("ReportQuotaConsumptionRequestData: unable to locate field 'brokerId', which is mandatory in version " + _version);
        }
        _object.brokerId = MessageUtil.jsonNodeToInt(_brokerIdNode, "ReportQuotaConsumptionRequestData");
        JsonNode _entriesNode = _node.get("entries");
        if (_entriesNode == null) {
            throw new RuntimeException("ReportQuotaConsumptionRequestData: unable to locate field 'entries', which is mandatory in version " + _version);
        }
        if (_entriesNode.isNull()) {
            _object.entries = null;
        } else {
            if (!_entriesNode.isArray()) {
                throw new RuntimeException("ReportQuotaConsumptionRequestData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<ReportQuotaConsumptionRequestData.EntryData> _collection = new ArrayList<ReportQuotaConsumptionRequestData.EntryData>(_entriesNode.size());
            _object.entries = _collection;
            for (JsonNode _element : _entriesNode) {
                _collection.add(EntryDataJsonConverter.read(_element, _version));
            }
        }
        return _object;
    }

    public static JsonNode write(ReportQuotaConsumptionRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("brokerId", (JsonNode)new IntNode(_object.brokerId));
        if (_object.entries == null) {
            _node.set("entries", (JsonNode)NullNode.instance);
        } else {
            ArrayNode _entriesArray = new ArrayNode(JsonNodeFactory.instance);
            for (ReportQuotaConsumptionRequestData.EntryData _element : _object.entries) {
                _entriesArray.add(EntryDataJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("entries", (JsonNode)_entriesArray);
        }
        return _node;
    }

    public static JsonNode write(ReportQuotaConsumptionRequestData _object, short _version) {
        return ReportQuotaConsumptionRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class EntryDataJsonConverter {
        public static ReportQuotaConsumptionRequestData.EntryData read(JsonNode _node, short _version) {
            ReportQuotaConsumptionRequestData.EntryData _object = new ReportQuotaConsumptionRequestData.EntryData();
            JsonNode _entityNode = _node.get("entity");
            if (_entityNode == null) {
                throw new RuntimeException("EntryData: unable to locate field 'entity', which is mandatory in version " + _version);
            }
            if (!_entityNode.isArray()) {
                throw new RuntimeException("EntryData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<ReportQuotaConsumptionRequestData.EntityData> _collection = new ArrayList<ReportQuotaConsumptionRequestData.EntityData>(_entityNode.size());
            _object.entity = _collection;
            for (JsonNode _element : _entityNode) {
                _collection.add(EntityDataJsonConverter.read(_element, _version));
            }
            JsonNode _consumptionsNode = _node.get("consumptions");
            if (_consumptionsNode == null) {
                throw new RuntimeException("EntryData: unable to locate field 'consumptions', which is mandatory in version " + _version);
            }
            if (!_consumptionsNode.isArray()) {
                throw new RuntimeException("EntryData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<ReportQuotaConsumptionRequestData.ConsumptionData> _collection2 = new ArrayList<ReportQuotaConsumptionRequestData.ConsumptionData>(_consumptionsNode.size());
            _object.consumptions = _collection2;
            for (JsonNode _element : _consumptionsNode) {
                _collection2.add(ConsumptionDataJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(ReportQuotaConsumptionRequestData.EntryData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            ArrayNode _entityArray = new ArrayNode(JsonNodeFactory.instance);
            for (ReportQuotaConsumptionRequestData.EntityData _element : _object.entity) {
                _entityArray.add(EntityDataJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("entity", (JsonNode)_entityArray);
            ArrayNode _consumptionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (ReportQuotaConsumptionRequestData.ConsumptionData _element : _object.consumptions) {
                _consumptionsArray.add(ConsumptionDataJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("consumptions", (JsonNode)_consumptionsArray);
            return _node;
        }

        public static JsonNode write(ReportQuotaConsumptionRequestData.EntryData _object, short _version) {
            return EntryDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class EntityDataJsonConverter {
        public static ReportQuotaConsumptionRequestData.EntityData read(JsonNode _node, short _version) {
            ReportQuotaConsumptionRequestData.EntityData _object = new ReportQuotaConsumptionRequestData.EntityData();
            JsonNode _entityTypeNode = _node.get("entityType");
            if (_entityTypeNode == null) {
                throw new RuntimeException("EntityData: unable to locate field 'entityType', which is mandatory in version " + _version);
            }
            if (!_entityTypeNode.isTextual()) {
                throw new RuntimeException("EntityData expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.entityType = _entityTypeNode.asText();
            JsonNode _entityNameNode = _node.get("entityName");
            if (_entityNameNode == null) {
                throw new RuntimeException("EntityData: unable to locate field 'entityName', which is mandatory in version " + _version);
            }
            if (!_entityNameNode.isTextual()) {
                throw new RuntimeException("EntityData expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.entityName = _entityNameNode.asText();
            return _object;
        }

        public static JsonNode write(ReportQuotaConsumptionRequestData.EntityData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("entityType", (JsonNode)new TextNode(_object.entityType));
            _node.set("entityName", (JsonNode)new TextNode(_object.entityName));
            return _node;
        }

        public static JsonNode write(ReportQuotaConsumptionRequestData.EntityData _object, short _version) {
            return EntityDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class ConsumptionDataJsonConverter {
        public static ReportQuotaConsumptionRequestData.ConsumptionData read(JsonNode _node, short _version) {
            ReportQuotaConsumptionRequestData.ConsumptionData _object = new ReportQuotaConsumptionRequestData.ConsumptionData();
            JsonNode _quotaTypeNode = _node.get("quotaType");
            if (_quotaTypeNode == null) {
                throw new RuntimeException("ConsumptionData: unable to locate field 'quotaType', which is mandatory in version " + _version);
            }
            if (!_quotaTypeNode.isTextual()) {
                throw new RuntimeException("ConsumptionData expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.quotaType = _quotaTypeNode.asText();
            JsonNode _usageNode = _node.get("usage");
            if (_usageNode == null) {
                throw new RuntimeException("ConsumptionData: unable to locate field 'usage', which is mandatory in version " + _version);
            }
            _object.usage = MessageUtil.jsonNodeToDouble(_usageNode, "ConsumptionData");
            JsonNode _throttledNode = _node.get("throttled");
            if (_throttledNode == null) {
                if (_version <= 0) {
                    throw new RuntimeException("ConsumptionData: unable to locate field 'throttled', which is mandatory in version " + _version);
                }
                _object.throttled = false;
            } else {
                if (!_throttledNode.isBoolean()) {
                    throw new RuntimeException("ConsumptionData expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.throttled = _throttledNode.asBoolean();
            }
            JsonNode _throttledTimeMsNode = _node.get("throttledTimeMs");
            if (_throttledTimeMsNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("ConsumptionData: unable to locate field 'throttledTimeMs', which is mandatory in version " + _version);
                }
                _object.throttledTimeMs = 0.0;
            } else {
                _object.throttledTimeMs = MessageUtil.jsonNodeToDouble(_throttledTimeMsNode, "ConsumptionData");
            }
            return _object;
        }

        public static JsonNode write(ReportQuotaConsumptionRequestData.ConsumptionData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("quotaType", (JsonNode)new TextNode(_object.quotaType));
            _node.set("usage", (JsonNode)new DoubleNode(_object.usage));
            if (_version <= 0) {
                _node.set("throttled", (JsonNode)BooleanNode.valueOf((boolean)_object.throttled));
            } else if (_object.throttled) {
                throw new UnsupportedVersionException("Attempted to write a non-default throttled at version " + _version);
            }
            if (_version >= 1) {
                _node.set("throttledTimeMs", (JsonNode)new DoubleNode(_object.throttledTimeMs));
            } else if (_object.throttledTimeMs != 0.0) {
                throw new UnsupportedVersionException("Attempted to write a non-default throttledTimeMs at version " + _version);
            }
            return _node;
        }

        public static JsonNode write(ReportQuotaConsumptionRequestData.ConsumptionData _object, short _version) {
            return ConsumptionDataJsonConverter.write(_object, _version, true);
        }
    }
}

