/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ReadableBuf;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Utils;

public final class ReadableByteBuf
implements ReadableBuf,
AutoCloseable {
    private final ByteBuf byteBuf;
    private final int initialPosition;
    private final InputStream byteBufInputStream;

    public ReadableByteBuf(ByteBuf byteBuf) {
        this.byteBuf = byteBuf.retain();
        this.byteBufInputStream = new ByteBufInputStream(byteBuf);
        this.initialPosition = this.position();
    }

    private InputStream asInputStream() {
        return this.byteBufInputStream;
    }

    @Override
    public void close() {
        Utils.closeQuietly(this.byteBufInputStream, "ReadableByteBuf InputStream");
        this.byteBuf.release();
    }

    @Override
    public int position() {
        return this.byteBuf.readerIndex();
    }

    @Override
    public void position(int pos) {
        if (pos < this.initialPosition) {
            throw new IndexOutOfBoundsException("Invalid position " + pos);
        }
        this.byteBuf.readerIndex(pos);
    }

    @Override
    public void rewind() {
        this.position(this.initialPosition);
    }

    @Override
    public void flip() {
        this.byteBuf.writerIndex(this.byteBuf.readerIndex());
        this.rewind();
    }

    @Override
    public byte readByte() {
        return this.byteBuf.readByte();
    }

    @Override
    public short readShort() {
        return this.byteBuf.readShort();
    }

    @Override
    public int readInt() {
        return this.byteBuf.readInt();
    }

    @Override
    public long readLong() {
        return this.byteBuf.readLong();
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public byte[] readArray(int length) {
        byte[] result = new byte[length];
        this.byteBuf.readBytes(result);
        return result;
    }

    @Override
    public int readUnsignedVarint() {
        try {
            return ByteUtils.readUnsignedVarint(this.asInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ByteBuffer readByteBuffer(int length) {
        return this.byteBuf.readSlice(length).nioBuffer();
    }

    @Override
    public int readVarint() {
        try {
            return ByteUtils.readVarint(this.asInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long readVarlong() {
        try {
            return ByteUtils.readVarlong(this.asInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int remaining() {
        return this.byteBuf.readableBytes();
    }
}

