/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import java.util.Set;
import kafka.catalog.KRaftMetadataCollector;
import kafka.catalog.MetadataEventProvider;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.metadata.MirrorTopic;

public class KRaftMetadataEventProvider
implements MetadataEventProvider<Uuid> {
    private final KRaftMetadataCollector collector;
    private final Set<Uuid> topics;
    private final Set<Uuid> linkIds;
    private final MetadataImage metadataImage;

    public KRaftMetadataEventProvider(KRaftMetadataCollector collector, Set<Uuid> topics, Set<Uuid> linkIds, MetadataImage metadataImage) {
        this.collector = collector;
        this.topics = topics;
        this.linkIds = linkIds;
        this.metadataImage = metadataImage;
    }

    @Override
    public Iterable<Uuid> topicIterable() {
        return this.topics;
    }

    @Override
    public Iterable<Uuid> clusterLinkIterable() {
        return this.linkIds;
    }

    @Override
    public MetadataEvent getTopicMetadata(Uuid topic) {
        TopicImage topicImage = this.metadataImage.topics().getTopic(topic);
        MirrorTopic mirrorInfo = topicImage.mirrorTopic().orElse(null);
        return this.collector.getMetadataUpdateEventFromTopicImage(this.metadataImage, topicImage, false, false, mirrorInfo);
    }

    @Override
    public MetadataEvent getClusterLinkMetadata(Uuid clusterLink) {
        ClusterLink link = this.metadataImage.clusterLinks().linksById().get(clusterLink);
        return this.collector.getMetadataUpdateEventFromClusterLinkImage(this.metadataImage, link, false, false);
    }
}

