/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.metadata;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.util.Objects;
import kafka.common.TenantHelpers;
import kafka.server.link.ConnectionMode;
import org.apache.kafka.common.Uuid;

public class ClusterLinkInfo {
    private final String logicalClusterId;
    private final String clusterLinkName;
    private final Uuid clusterLinkId;
    private final ClusterLinkConfig.LinkMode linkMode;
    private final ConnectionMode connectionMode;
    private final String remoteClusterId;
    private final String localClusterId;

    public ClusterLinkInfo(String linkName, Uuid linkId, ClusterLinkConfig.LinkMode linkMode, ConnectionMode connectionMode, String remoteClusterId) {
        String tenantPrefix = TenantHelpers.extractTenantPrefix(linkName, false);
        this.logicalClusterId = tenantPrefix == null ? "" : tenantPrefix;
        this.clusterLinkName = linkName;
        this.clusterLinkId = linkId;
        this.linkMode = linkMode;
        this.connectionMode = connectionMode;
        this.remoteClusterId = remoteClusterId;
        this.localClusterId = this.logicalClusterId;
    }

    public String logicalClusterId() {
        return this.logicalClusterId;
    }

    public String clusterLinkName() {
        return this.clusterLinkName;
    }

    public Uuid clusterLinkId() {
        return this.clusterLinkId;
    }

    public ClusterLinkConfig.LinkMode linkMode() {
        return this.linkMode;
    }

    public ConnectionMode connectionMode() {
        return this.connectionMode;
    }

    public String remoteClusterId() {
        return this.remoteClusterId;
    }

    public String localClusterId() {
        return this.localClusterId;
    }

    public String toString() {
        return "ClusterLinkInfo=(logicalClusterId=" + this.logicalClusterId + ", clusterLinkName=" + this.clusterLinkName + ", clusterLinkId=" + String.valueOf(this.clusterLinkId) + ", linkMode=" + String.valueOf((Object)this.linkMode) + ", connectionMode=" + String.valueOf(this.connectionMode) + ", remoteClusterId=" + this.remoteClusterId + ", localClusterId=" + this.localClusterId + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterLinkInfo)) {
            return false;
        }
        ClusterLinkInfo that = (ClusterLinkInfo)o;
        return Objects.equals(this.logicalClusterId, that.logicalClusterId()) && Objects.equals(this.clusterLinkName, that.clusterLinkName()) && Objects.equals(this.clusterLinkId, that.clusterLinkId()) && Objects.equals((Object)this.linkMode, (Object)that.linkMode()) && Objects.equals(this.connectionMode, that.connectionMode()) && Objects.equals(this.remoteClusterId, that.remoteClusterId()) && Objects.equals(this.localClusterId, that.localClusterId());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.logicalClusterId, this.clusterLinkName, this.clusterLinkId, this.linkMode, this.connectionMode, this.remoteClusterId, this.localClusterId});
    }
}

