/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.BalancerOperationStatus;
import org.apache.kafka.clients.admin.BrokerReplicaExclusionStatus;
import org.apache.kafka.clients.admin.BrokerShutdownStatus;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;

public class BrokerRemovalDescriptionInternal {
    private final int brokerId;
    private final Exception exception;
    private final long createTimeMs;
    private final long lastUpdateTimeMs;
    private final BalancerOperationStatus generalOperationStatus;
    private final BrokerReplicaExclusionStatus replicaExclusionStatus;
    private final PartitionReassignmentsStatus partitionReassignmentsStatus;
    private final BrokerShutdownStatus brokerShutdownStatus;
    private final boolean shutdownScheduled;

    public BrokerRemovalDescriptionInternal(int brokerId, BalancerOperationStatus generalOperationStatus, BrokerReplicaExclusionStatus replicaExclusionStatus, PartitionReassignmentsStatus partitionReassignmentsStatus, BrokerShutdownStatus brokerShutdownStatus, Exception e, long createTimeMs, long lastUpdateTimeMs, boolean shutdownScheduled) {
        this.brokerId = brokerId;
        this.generalOperationStatus = generalOperationStatus;
        this.replicaExclusionStatus = replicaExclusionStatus;
        this.partitionReassignmentsStatus = partitionReassignmentsStatus;
        this.brokerShutdownStatus = brokerShutdownStatus;
        this.exception = e;
        this.createTimeMs = createTimeMs;
        this.lastUpdateTimeMs = lastUpdateTimeMs;
        this.shutdownScheduled = shutdownScheduled;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long createTimeMs() {
        return this.createTimeMs;
    }

    public long lastUpdateTimeMs() {
        return this.lastUpdateTimeMs;
    }

    public Exception exception() {
        return this.exception;
    }

    public boolean shutdownScheduled() {
        return this.shutdownScheduled;
    }

    public BalancerOperationStatus generalOperationStatus() {
        return this.generalOperationStatus;
    }

    public PartitionReassignmentsStatus partitionReassignmentsStatus() {
        return this.partitionReassignmentsStatus;
    }

    public BrokerShutdownStatus brokerShutdownStatus() {
        return this.brokerShutdownStatus;
    }

    public BrokerReplicaExclusionStatus replicaExclusionStatus() {
        return this.replicaExclusionStatus;
    }

    public String toString() {
        return "BrokerRemovalDescriptionInternal{brokerId=" + this.brokerId + ", replicaExclusionStatus=" + this.replicaExclusionStatus.name() + ", partitionReassignmentsStatus=" + this.partitionReassignmentsStatus.name() + ", brokerShutdownStatus=" + this.brokerShutdownStatus.name() + ", exception=" + String.valueOf(this.exception) + ", createTime=" + ClientUtils.utcDateFor(this.createTimeMs) + ", updateTime=" + ClientUtils.utcDateFor(this.lastUpdateTimeMs) + ", shutdownScheduled=" + this.shutdownScheduled + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerRemovalDescriptionInternal that = (BrokerRemovalDescriptionInternal)o;
        return this.brokerId == that.brokerId;
    }

    public int hashCode() {
        return this.brokerId;
    }
}

