/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PendingCompleteTxn;
import kafka.coordinator.transaction.PendingCompleteTxnAndMarkerEntry;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005a4A\u0001D\u0007\u0001)!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \t\u000b!\u0003A\u0011A%\t\u000f=\u0003\u0001\u0019!C\u0005!\"9A\u000b\u0001a\u0001\n\u0013)\u0006BB.\u0001A\u0003&\u0011\u000bC\u0003a\u0001\u0011\u0005\u0011\rC\u0003p\u0001\u0011\u0005\u0003\u000fC\u0003r\u0001\u0011\u0005#OA\u0015Ue\u0006t7/Y2uS>tW*\u0019:lKJ\u0014V-];fgR\u001cu.\u001c9mKRLwN\u001c%b]\u0012dWM\u001d\u0006\u0003\u001d=\t1\u0002\u001e:b]N\f7\r^5p]*\u0011\u0001#E\u0001\fG>|'\u000fZ5oCR|'OC\u0001\u0013\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\u000b\u001eQA\u0011acG\u0007\u0002/)\u0011\u0001$G\u0001\u0005Y\u0006twMC\u0001\u001b\u0003\u0011Q\u0017M^1\n\u0005q9\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001fM5\tqD\u0003\u0002!C\u000591\r\\5f]R\u001c(B\u0001\n#\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\n\u0005\u001dz\"\u0001\u0007*fcV,7\u000f^\"p[BdW\r^5p]\"\u000bg\u000e\u001a7feB\u0011\u0011\u0006L\u0007\u0002U)\u00111&E\u0001\u0006kRLGn]\u0005\u0003[)\u0012q\u0001T8hO&tw-\u0001\u0005ce>\\WM]%e!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\rIe\u000e^\u0001\u0010ibt7\u000b^1uK6\u000bg.Y4feB\u0011q\u0007O\u0007\u0002\u001b%\u0011\u0011(\u0004\u0002\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJ\fq\u0003\u001e=o\u001b\u0006\u00148.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0011\u0005]b\u0014BA\u001f\u000e\u0005}!&/\u00198tC\u000e$\u0018n\u001c8NCJ\\WM]\"iC:tW\r\\'b]\u0006<WM]\u0001#a\u0016tG-\u001b8h\u0007>l\u0007\u000f\\3uKRCh.\u00118e\u001b\u0006\u00148.\u001a:F]R\u0014\u0018.Z:\u0011\u0007\u0001\u001bU)D\u0001B\u0015\t\u0011\u0015$\u0001\u0003vi&d\u0017B\u0001#B\u0005\u0011a\u0015n\u001d;\u0011\u0005]2\u0015BA$\u000e\u0005\u0001\u0002VM\u001c3j]\u001e\u001cu.\u001c9mKR,G\u000b\u001f8B]\u0012l\u0015M]6fe\u0016sGO]=\u0002\rqJg.\u001b;?)\u0015Q5\nT'O!\t9\u0004\u0001C\u0003/\u000b\u0001\u0007q\u0006C\u00036\u000b\u0001\u0007a\u0007C\u0003;\u000b\u0001\u00071\bC\u0003?\u000b\u0001\u0007q(A\u0005d_6\u0004H.\u001a;fIV\t\u0011\u000b\u0005\u00021%&\u00111+\r\u0002\b\u0005>|G.Z1o\u00035\u0019w.\u001c9mKR,Gm\u0018\u0013fcR\u0011a+\u0017\t\u0003a]K!\u0001W\u0019\u0003\tUs\u0017\u000e\u001e\u0005\b5\u001e\t\t\u00111\u0001R\u0003\rAH%M\u0001\u000bG>l\u0007\u000f\\3uK\u0012\u0004\u0003F\u0001\u0005^!\t\u0001d,\u0003\u0002`c\tAao\u001c7bi&dW-\u0001\u000euQJ|w/\u00137mK\u001e\fGn\u0015;bi\u0016,\u0005pY3qi&|g\u000e\u0006\u0002WE\")1-\u0003a\u0001I\u00069Q.Z:tC\u001e,\u0007CA3m\u001d\t1'\u000e\u0005\u0002hc5\t\u0001N\u0003\u0002j'\u00051AH]8pizJ!a[\u0019\u0002\rA\u0013X\rZ3g\u0013\tigN\u0001\u0004TiJLgn\u001a\u0006\u0003WF\n\u0001BZ5oC2L'0\u001a\u000b\u0002-\u0006QqN\\\"p[BdW\r^3\u0015\u0005Y\u001b\b\"\u0002;\f\u0001\u0004)\u0018\u0001\u0003:fgB|gn]3\u0011\u0005y1\u0018BA< \u00059\u0019E.[3oiJ+7\u000f]8og\u0016\u0004")
public class TransactionMarkerRequestCompletionHandler
implements RequestCompletionHandler,
Logging {
    private final TransactionStateManager txnStateManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final List<PendingCompleteTxnAndMarkerEntry> pendingCompleteTxnAndMarkerEntries;
    private volatile boolean completed;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TransactionMarkerRequestCompletionHandler transactionMarkerRequestCompletionHandler = this;
        synchronized (transactionMarkerRequestCompletionHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private boolean completed() {
        return this.completed;
    }

    private void completed_$eq(boolean x$1) {
        this.completed = x$1;
    }

    public void throwIllegalStateException(String message) {
        this.txnStateManager.stateErrorSensor().record();
        this.error((Function0<String> & Serializable)() -> message + "; transaction is left in PrepareCommit or PrepareAbort state");
        throw new IllegalStateException(message);
    }

    public void finalize() {
        if (!this.completed()) {
            CollectionConverters$.MODULE$.ListHasAsScala(this.pendingCompleteTxnAndMarkerEntries).asScala().foreach((Function1<PendingCompleteTxnAndMarkerEntry, Object> & Serializable)pendingCompleteTxnAndMarker -> {
                TransactionMarkerRequestCompletionHandler.$anonfun$finalize$1(this, pendingCompleteTxnAndMarker);
                return BoxedUnit.UNIT;
            });
        }
        super.finalize();
    }

    @Override
    public void onComplete(ClientResponse response) {
        this.completed_$eq(true);
        RequestHeader requestHeader = response.requestHeader();
        int correlationId = requestHeader.correlationId();
        if (response.wasDisconnected()) {
            this.trace((Function0<String> & Serializable)() -> "Cancelled request with header " + requestHeader + " due to node " + response.destination() + " being disconnected");
            CollectionConverters$.MODULE$.ListHasAsScala(this.pendingCompleteTxnAndMarkerEntries).asScala().foreach((Function1<PendingCompleteTxnAndMarkerEntry, Object> & Serializable)pendingCompleteTxnAndMarker -> {
                TransactionMarkerRequestCompletionHandler.$anonfun$onComplete$2(this, pendingCompleteTxnAndMarker);
                return BoxedUnit.UNIT;
            });
            return;
        }
        this.debug((Function0<String> & Serializable)() -> "Received WriteTxnMarker response " + response + " from node " + response.destination() + " with correlation id " + correlationId);
        WriteTxnMarkersResponse writeTxnMarkerResponse = (WriteTxnMarkersResponse)response.responseBody();
        Map<Long, Map<TopicPartition, Errors>> responseErrors = writeTxnMarkerResponse.errorsByProducerId();
        CollectionConverters$.MODULE$.ListHasAsScala(this.pendingCompleteTxnAndMarkerEntries).asScala().foreach((Function1<PendingCompleteTxnAndMarkerEntry, Object> & Serializable)pendingCompleteTxnAndMarker -> {
            TransactionMarkerRequestCompletionHandler.$anonfun$onComplete$8(this, responseErrors, pendingCompleteTxnAndMarker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$finalize$1(TransactionMarkerRequestCompletionHandler $this, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        PendingCompleteTxn pendingCompleteTxn = pendingCompleteTxnAndMarker.pendingCompleteTxn();
        String transactionalId = pendingCompleteTxn.transactionalId();
        WriteTxnMarkersRequest.TxnMarkerEntry txnMarker = pendingCompleteTxnAndMarker.txnMarkerEntry();
        $this.error((Function0<String> & Serializable)() -> "Transaction marker " + txnMarker + " for " + transactionalId + " is not completed; transaction is left in PrepareCommit or PrepareAbort state");
    }

    public static final /* synthetic */ void $anonfun$onComplete$2(TransactionMarkerRequestCompletionHandler $this, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        Option option;
        Errors errors;
        PendingCompleteTxn pendingCompleteTxn = pendingCompleteTxnAndMarker.pendingCompleteTxn();
        String transactionalId = pendingCompleteTxn.transactionalId();
        WriteTxnMarkersRequest.TxnMarkerEntry txnMarker = pendingCompleteTxnAndMarker.txnMarkerEntry();
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors2 = (Errors)((Object)left.value());
            if (((Object)((Object)Errors.NOT_COORDINATOR)).equals((Object)errors2)) {
                $this.info((Function0<String> & Serializable)() -> "I am no longer the coordinator for " + transactionalId + "; cancel sending transaction markers " + txnMarker + " to the brokers");
                $this.txnMarkerChannelManager.removeMarkersForTxn(pendingCompleteTxn);
                return;
            }
        }
        if (bl && ((Object)((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS)).equals((Object)(errors = (Errors)((Object)left.value())))) {
            $this.info((Function0<String> & Serializable)() -> "I am loading the transaction partition that contains " + transactionalId + " which means the current markers have to be obsoleted; cancel sending transaction markers " + txnMarker + " to the brokers");
            $this.txnMarkerChannelManager.removeMarkersForTxn(pendingCompleteTxn);
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)((Object)left.value());
            $this.throwIllegalStateException("Unhandled error " + unexpectedError + " when fetching current transaction state for " + transactionalId);
            return;
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                $this.throwIllegalStateException("The coordinator still owns the transaction partition for " + transactionalId + ", but there is no metadata in the cache; this is not expected");
                return;
            }
        }
        if (bl2 && (option = (Option)right.value()) instanceof Some) {
            Some some = (Some)option;
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
            if (epochAndMetadata.coordinatorEpoch() != txnMarker.coordinatorEpoch()) {
                $this.info((Function0<String> & Serializable)() -> "Transaction coordinator epoch for " + transactionalId + " has changed from " + txnMarker.coordinatorEpoch() + " to " + epochAndMetadata.coordinatorEpoch() + "; cancel sending transaction markers " + txnMarker + " to the brokers");
                $this.txnMarkerChannelManager.removeMarkersForTxn(pendingCompleteTxn);
                return;
            }
            $this.trace((Function0<String> & Serializable)() -> "Re-enqueuing " + txnMarker.transactionResult() + " transaction markers for transactional id " + transactionalId + " under coordinator epoch " + txnMarker.coordinatorEpoch());
            $this.txnMarkerChannelManager.addTxnMarkersToBrokerQueue(txnMarker.producerId(), txnMarker.producerEpoch(), txnMarker.transactionResult(), pendingCompleteTxn, CollectionConverters$.MODULE$.ListHasAsScala(txnMarker.partitions()).asScala().toSet());
            return;
        }
        throw new MatchError(either);
    }

    public static final /* synthetic */ boolean $anonfun$onComplete$13(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$onComplete$8(TransactionMarkerRequestCompletionHandler $this, Map responseErrors$1, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        Option option;
        Errors errors;
        PendingCompleteTxn pendingCompleteTxn = pendingCompleteTxnAndMarker.pendingCompleteTxn();
        String transactionalId = pendingCompleteTxn.transactionalId();
        WriteTxnMarkersRequest.TxnMarkerEntry txnMarker = pendingCompleteTxnAndMarker.txnMarkerEntry();
        Map errors2 = (Map)responseErrors$1.get(BoxesRunTime.boxToLong(txnMarker.producerId()));
        if (errors2 == null) {
            $this.throwIllegalStateException("WriteTxnMarkerResponse for " + transactionalId + " does not contain expected error map for producer id " + txnMarker.producerId());
        }
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors3 = (Errors)((Object)left.value());
            if (((Object)((Object)Errors.NOT_COORDINATOR)).equals((Object)errors3)) {
                $this.info((Function0<String> & Serializable)() -> "I am no longer the coordinator for " + transactionalId + "; cancel sending transaction markers " + txnMarker + " to the brokers");
                $this.txnMarkerChannelManager.removeMarkersForTxn(pendingCompleteTxn);
                return;
            }
        }
        if (bl && ((Object)((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS)).equals((Object)(errors = (Errors)((Object)left.value())))) {
            $this.info((Function0<String> & Serializable)() -> "I am loading the transaction partition that contains " + transactionalId + " which means the current markers have to be obsoleted; cancel sending transaction markers " + txnMarker + " to the brokers");
            $this.txnMarkerChannelManager.removeMarkersForTxn(pendingCompleteTxn);
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)((Object)left.value());
            $this.throwIllegalStateException("Unhandled error " + unexpectedError + " when fetching current transaction state for " + transactionalId);
            return;
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                $this.throwIllegalStateException("The coordinator still owns the transaction partition for " + transactionalId + ", but there is no metadata in the cache; this is not expected");
                return;
            }
        }
        if (bl2 && (option = (Option)right.value()) instanceof Some) {
            Some some = (Some)option;
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
            TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
            Set retryPartitions = (Set)Set$.MODULE$.empty();
            BooleanRef abortSending = BooleanRef.create(false);
            if (epochAndMetadata.coordinatorEpoch() != txnMarker.coordinatorEpoch()) {
                $this.info((Function0<String> & Serializable)() -> "Transaction coordinator epoch for " + transactionalId + " has changed from " + txnMarker.coordinatorEpoch() + " to " + epochAndMetadata.coordinatorEpoch() + "; cancel sending transaction markers " + txnMarker + " to the brokers");
                $this.txnMarkerChannelManager.removeMarkersForTxn(pendingCompleteTxn);
                abortSending.elem = true;
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = txnMetadata.inLock(() -> CollectionConverters$.MODULE$.MapHasAsScala(errors2).asScala().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(TransactionMarkerRequestCompletionHandler.$anonfun$onComplete$13(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        TopicPartition topicPartition = (TopicPartition)tuple2._1();
                        Errors error = (Errors)((Object)((Object)((Object)tuple2._2())));
                        Errors errors = error;
                        if (((Object)((Object)Errors.NONE)).equals((Object)errors)) {
                            txnMetadata.removePartition(topicPartition);
                            return BoxedUnit.UNIT;
                        }
                        if (((Object)((Object)Errors.CORRUPT_MESSAGE)).equals((Object)errors) ? true : (((Object)((Object)Errors.MESSAGE_TOO_LARGE)).equals((Object)errors) ? true : (((Object)((Object)Errors.RECORD_LIST_TOO_LARGE)).equals((Object)errors) ? true : ((Object)((Object)Errors.INVALID_REQUIRED_ACKS)).equals((Object)errors)))) {
                            $this.throwIllegalStateException("Received fatal error " + error.exceptionName() + " while sending txn marker for " + transactionalId);
                            return BoxedUnit.UNIT;
                        }
                        if (((Object)((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)).equals((Object)errors) ? true : (((Object)((Object)Errors.NOT_LEADER_OR_FOLLOWER)).equals((Object)errors) ? true : (((Object)((Object)Errors.NOT_ENOUGH_REPLICAS)).equals((Object)errors) ? true : (((Object)((Object)Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND)).equals((Object)errors) ? true : (((Object)((Object)Errors.REQUEST_TIMED_OUT)).equals((Object)errors) ? true : ((Object)((Object)Errors.KAFKA_STORAGE_ERROR)).equals((Object)errors)))))) {
                            $this.info((Function0<String> & Serializable)() -> "Sending " + transactionalId + "'s transaction marker for partition " + topicPartition + " has failed with error " + error.exceptionName() + ", retrying with current coordinator epoch " + epochAndMetadata.coordinatorEpoch());
                            return retryPartitions.$plus$eq(topicPartition);
                        }
                        if (((Object)((Object)Errors.INVALID_PRODUCER_EPOCH)).equals((Object)errors) ? true : ((Object)((Object)Errors.TRANSACTION_COORDINATOR_FENCED)).equals((Object)errors)) {
                            $this.info((Function0<String> & Serializable)() -> "Sending " + transactionalId + "'s transaction marker for partition " + topicPartition + " has permanently failed with error " + error.exceptionName() + " with the current coordinator epoch " + epochAndMetadata.coordinatorEpoch() + "; cancel sending any more transaction markers " + txnMarker + " to the brokers");
                            $this.txnMarkerChannelManager.removeMarkersForTxn(pendingCompleteTxn);
                            abortSending$1.elem = true;
                            return BoxedUnit.UNIT;
                        }
                        if (((Object)((Object)Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT)).equals((Object)errors) ? true : ((Object)((Object)Errors.UNSUPPORTED_VERSION)).equals((Object)errors)) {
                            $this.info((Function0<String> & Serializable)() -> "Sending " + transactionalId + "'s transaction marker from partition " + topicPartition + " has failed with  " + error.name() + ". This partition will be removed from the set of partitions waiting for completion");
                            txnMetadata.removePartition(topicPartition);
                            return BoxedUnit.UNIT;
                        }
                        $this.throwIllegalStateException("Unexpected error " + errors.exceptionName() + " while sending txn marker for " + transactionalId);
                        return BoxedUnit.UNIT;
                    }
                    throw new MatchError(tuple2);
                }));
            }
            if (!abortSending.elem) {
                if (retryPartitions.nonEmpty()) {
                    $this.debug((Function0<String> & Serializable)() -> "Re-enqueuing " + txnMarker.transactionResult() + " transaction markers for transactional id " + transactionalId + " under coordinator epoch " + txnMarker.coordinatorEpoch());
                    $this.txnMarkerChannelManager.addTxnMarkersToBrokerQueue(txnMarker.producerId(), txnMarker.producerEpoch(), txnMarker.transactionResult(), pendingCompleteTxn, retryPartitions.toSet());
                    return;
                }
                $this.txnMarkerChannelManager.maybeWriteTxnCompletion(transactionalId);
                return;
            }
            return;
        }
        throw new MatchError(either);
    }

    public TransactionMarkerRequestCompletionHandler(int brokerId, TransactionStateManager txnStateManager, TransactionMarkerChannelManager txnMarkerChannelManager, List<PendingCompleteTxnAndMarkerEntry> pendingCompleteTxnAndMarkerEntries) {
        this.txnStateManager = txnStateManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.pendingCompleteTxnAndMarkerEntries = pendingCompleteTxnAndMarkerEntries;
        Logging.$init$(this);
        this.logIdent_$eq("[Transaction Marker Request Completion Handler " + brokerId + "]: ");
        this.completed = false;
    }
}

