/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.concurrent.DefaultEventExecutor;
import io.confluent.kafka.concurrent.EventExecutor;
import io.confluent.kafka.raft.CompositeRaftTracer;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kafka.durability.audit.manager.KRaftDurabilityAuditor$;
import kafka.log.MergedLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.tier.raft.KRaftSnapshotManager;
import kafka.tier.raft.KRaftSnapshotMetrics;
import kafka.tier.store.TierObjectStore;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.ExternalKRaftMetrics;
import org.apache.kafka.raft.FileQuorumStateStore;
import org.apache.kafka.raft.KafkaNetworkChannel;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.KafkaRaftClientDriver;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.util.FileLock;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.timer.SystemTimer;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\rUv!\u0002#F\u0011\u0003Qe!\u0002'F\u0011\u0003i\u0005\"\u0002+\u0002\t\u0003)\u0006\"\u0002,\u0002\t\u00139\u0006\"B8\u0002\t\u0013\u0001\bbBA\u0001\u0003\u0011%\u00111\u0001\u0004\u0006\u0019\u0016\u0003\u0011\u0011\u0004\u0005\n\u0003\u000b2!\u0011!Q\u0001\n\u0011D!\"!\u0004\u0007\u0005\u0003\u0005\u000b\u0011BA\b\u0011)\t9E\u0002B\u0001B\u0003%\u0011\u0011\n\u0005\u000b\u0003+2!\u0011!Q\u0001\n\u0005]\u0003BCA3\r\t\u0005\t\u0015!\u0003\u0002h!Q\u0011Q\u000e\u0004\u0003\u0002\u0003\u0006I!!\u0013\t\u0015\u0005=dA!A!\u0002\u0013\t\t\b\u0003\u0006\u0002|\u0019\u0011\t\u0011)A\u0005\u0003{B!\"a\"\u0007\u0005\u0003\u0005\u000b\u0011BAE\u0011)\t\u0019J\u0002B\u0001B\u0003%\u0011Q\u0013\u0005\u000b\u000373!Q1A\u0005\u0002\u0005u\u0005BCAg\r\t\u0005\t\u0015!\u0003\u0002 \"Q\u0011q\u001a\u0004\u0003\u0002\u0003\u0006I!!5\t\u0015\u0005]gA!A!\u0002\u0013\tI\u000e\u0003\u0006\u0002`\u001a\u0011\t\u0011)A\u0005\u0003CD!\"!<\u0007\u0005\u0003\u0005\u000b\u0011BAx\u0011\u0019!f\u0001\"\u0001\u0003\u0006!I!q\u0005\u0004C\u0002\u0013%!\u0011\u0006\u0005\t\u0005o1\u0001\u0015!\u0003\u0003,!I!\u0011\b\u0004C\u0002\u0013\u0005!1\b\u0005\t\u0005\u00132\u0001\u0015!\u0003\u0003>!I!1\n\u0004C\u0002\u0013%!Q\n\u0005\t\u0005+2\u0001\u0015!\u0003\u0003P!I!q\u000b\u0004C\u0002\u0013%!\u0011\f\u0005\b\u000572\u0001\u0015!\u0003e\u0011%\u0011iF\u0002b\u0001\n\u0013\u0011y\u0006\u0003\u0005\u0003h\u0019\u0001\u000b\u0011\u0002B1\u0011%\u0011IG\u0002b\u0001\n\u0013\u0011Y\u0007\u0003\u0005\u0003t\u0019\u0001\u000b\u0011\u0002B7\u0011!yhA1A\u0005\n\tU\u0004b\u0002B<\r\u0001\u0006I\u0001\u0017\u0005\n\u0005s2!\u0019!C\u0005\u0005wB\u0001Ba \u0007A\u0003%!Q\u0010\u0005\n\u0005\u00033!\u0019!C!\u0005\u0007C\u0001Ba#\u0007A\u0003%!Q\u0011\u0005\n\u0005\u001b3!\u0019!C\u0005\u0005\u001fC\u0001Ba&\u0007A\u0003%!\u0011\u0013\u0005\n\u000533!\u0019!C\u0005\u00057C\u0001B!+\u0007A\u0003%!Q\u0014\u0005\n\u0005W3!\u0019!C\u0005\u0005[C\u0001B!.\u0007A\u0003%!q\u0016\u0005\n\u0005o3!\u0019!C!\u0005sC\u0001B!1\u0007A\u0003%!1\u0018\u0005\n\u0005\u00074!\u0019!C\u0005\u0005\u000bD\u0001B!4\u0007A\u0003%!q\u0019\u0005\n\u0005\u001f4\u0001\u0019!C\u0005\u0005#D\u0011Ba:\u0007\u0001\u0004%IA!;\t\u0011\tUh\u0001)Q\u0005\u0005'DqAa>\u0007\t\u0003\u0011I\u0010C\u0004\u0003|\u001a!\tA!?\t\u000f\tuh\u0001\"\u0011\u0003\u0000\"911\u0003\u0004\u0005B\rU\u0001bBB'\r\u0011%1q\n\u0005\b\u0007;2A\u0011BB0\u0011\u001d\u0019\tG\u0002C\u0005\u0007GBqa!\u001a\u0007\t\u0013\u00199\u0007C\u0004\u0004j\u0019!Iaa\u001b\t\u000f\rMd\u0001\"\u0003\u0004v!91q\u0012\u0004\u0005B\rE\u0005bBBM\r\u0011\u000531\u0014\u0005\b\u0007c3A\u0011IBZ\u0003AY\u0015MZ6b%\u00064G/T1oC\u001e,'O\u0003\u0002G\u000f\u0006!!/\u00194u\u0015\u0005A\u0015!B6bM.\f7\u0001\u0001\t\u0003\u0017\u0006i\u0011!\u0012\u0002\u0011\u0017\u000647.\u0019*bMRl\u0015M\\1hKJ\u001c\"!\u0001(\u0011\u0005=\u0013V\"\u0001)\u000b\u0003E\u000bQa]2bY\u0006L!a\u0015)\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!*\u0001\nde\u0016\fG/\u001a'pO\u0012K'/Z2u_JLHc\u0001-aEB\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0003S>T\u0011!X\u0001\u0005U\u00064\u0018-\u0003\u0002`5\n!a)\u001b7f\u0011\u0015\t7\u00011\u0001Y\u0003\u0019awn\u001a#je\")1m\u0001a\u0001I\u0006QAn\\4ESJt\u0015-\\3\u0011\u0005\u0015dgB\u00014k!\t9\u0007+D\u0001i\u0015\tI\u0017*\u0001\u0004=e>|GOP\u0005\u0003WB\u000ba\u0001\u0015:fI\u00164\u0017BA7o\u0005\u0019\u0019FO]5oO*\u00111\u000eU\u0001\fY>\u001c7\u000eR1uC\u0012K'\u000f\u0006\u0002r}B\u0011!\u000f`\u0007\u0002g*\u0011A/^\u0001\u0005kRLGN\u0003\u0002wo\u000611/\u001a:wKJT!\u0001\u0013=\u000b\u0005eT\u0018AB1qC\u000eDWMC\u0001|\u0003\ry'oZ\u0005\u0003{N\u0014\u0001BR5mK2{7m\u001b\u0005\u0006\u007f\u0012\u0001\r\u0001W\u0001\bI\u0006$\u0018\rR5s\u0003IA\u0017m\u001d#jM\u001a,'/\u001a8u\u0019><G)\u001b:\u0015\t\u0005\u0015\u00111\u0002\t\u0004\u001f\u0006\u001d\u0011bAA\u0005!\n9!i\\8mK\u0006t\u0007bBA\u0007\u000b\u0001\u0007\u0011qB\u0001\u0007G>tg-[4\u0011\t\u0005E\u0011QC\u0007\u0003\u0003'Q!A^$\n\t\u0005]\u00111\u0003\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0006\u0003\u0002\u001c\u0005\u001d2C\u0002\u0004O\u0003;\tI\u0004E\u0003L\u0003?\t\u0019#C\u0002\u0002\"\u0015\u00131BU1gi6\u000bg.Y4feB!\u0011QEA\u0014\u0019\u0001!q!!\u000b\u0007\u0005\u0004\tYCA\u0001U#\u0011\ti#a\r\u0011\u0007=\u000by#C\u0002\u00022A\u0013qAT8uQ&tw\rE\u0002P\u0003kI1!a\u000eQ\u0005\r\te.\u001f\t\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011qH$\u0002\u000bU$\u0018\u000e\\:\n\t\u0005\r\u0013Q\b\u0002\b\u0019><w-\u001b8h\u0003%\u0019G.^:uKJLE-\u0001\nnKR\fG-\u0019;b\u0019><G)\u001b:Vk&$\u0007\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=s/\u0001\u0004d_6lwN\\\u0005\u0005\u0003'\niE\u0001\u0003Vk&$\u0017!B:fe\u0012,\u0007CBA-\u0003C\n\u0019#\u0004\u0002\u0002\\)!\u0011QLA0\u00035\u0019XM]5bY&T\u0018\r^5p]*\u0019\u0011qJ;\n\t\u0005\r\u00141\f\u0002\f%\u0016\u001cwN\u001d3TKJ$W-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005-\u0013\u0011N\u0005\u0005\u0003W\niE\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u000fQ|\u0007/[2JI\u0006!A/[7f!\u0011\t\u0019(a\u001e\u000e\u0005\u0005U$\u0002BA \u0003\u001bJA!!\u001f\u0002v\t!A+[7f\u0003\u001diW\r\u001e:jGN\u0004B!a \u0002\u00046\u0011\u0011\u0011\u0011\u0006\u0005\u0003w\ni%\u0003\u0003\u0002\u0006\u0006\u0005%aB'fiJL7m]\u0001\u0015Kb$XM\u001d8bY.\u0013\u0016M\u001a;NKR\u0014\u0018nY:\u0011\t\u0005-\u0015qR\u0007\u0003\u0003\u001bS!AR<\n\t\u0005E\u0015Q\u0012\u0002\u0015\u000bb$XM\u001d8bY.\u0013\u0016M\u001a;NKR\u0014\u0018nY:\u0002'QD'/Z1e\u001d\u0006lW\r\u0015:fM&Dx\n\u001d;\u0011\t=\u000b9\nZ\u0005\u0004\u00033\u0003&AB(qi&|g.\u0001\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3\u0016\u0005\u0005}\u0005CBAQ\u0003S\u000bi+\u0004\u0002\u0002$*!\u0011QUAT\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003irKA!a+\u0002$\n\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\u0011\u0005=\u0016\u0011WA[\u0003\u0003l!!a*\n\t\u0005M\u0016q\u0015\u0002\u0004\u001b\u0006\u0004\b\u0003BA\\\u0003{k!!!/\u000b\u0007\u0005mF,\u0001\u0003mC:<\u0017\u0002BA`\u0003s\u0013q!\u00138uK\u001e,'\u000f\u0005\u0003\u0002D\u0006%WBAAc\u0015\r\t9\rX\u0001\u0004]\u0016$\u0018\u0002BAf\u0003\u000b\u0014\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u0003u\u0019wN\u001c;s_2dWM])v_J,XNV8uKJ\u001ch)\u001e;ve\u0016\u0004\u0013\u0001\u00052p_R\u001cHO]1q'\u0016\u0014h/\u001a:t!\u0019\ty+a5\u0002B&!\u0011Q[AT\u0005)\u0019u\u000e\u001c7fGRLwN\\\u0001\u000fY>\u001c\u0017\r\u001c'jgR,g.\u001a:t!\u0011\tY)a7\n\t\u0005u\u0017Q\u0012\u0002\n\u000b:$\u0007o\\5oiN\f\u0011CZ1uC24\u0015-\u001e7u\u0011\u0006tG\r\\3s!\u0011\t\u0019/!;\u000e\u0005\u0005\u0015(bAAtk\u0006)a-Y;mi&!\u00111^As\u000511\u0015-\u001e7u\u0011\u0006tG\r\\3s\u0003I!\u0018.\u001a:PE*,7\r^*u_J,w\n\u001d;\u0011\r\u0005=\u0016\u0011_A{\u0013\u0011\t\u00190a*\u0003\u0011=\u0003H/[8oC2\u0004B!a>\u0003\u00025\u0011\u0011\u0011 \u0006\u0005\u0003w\fi0A\u0003ti>\u0014XMC\u0002\u0002\u0000\u001e\u000bA\u0001^5fe&!!1AA}\u0005=!\u0016.\u001a:PE*,7\r^*u_J,G\u0003\tB\u0004\u0005\u0013\u0011YA!\u0004\u0003\u0010\tE!1\u0003B\u000b\u0005/\u0011IBa\u0007\u0003\u001e\t}!\u0011\u0005B\u0012\u0005K\u0001Ba\u0013\u0004\u0002$!1\u0011QI\fA\u0002\u0011Dq!!\u0004\u0018\u0001\u0004\ty\u0001C\u0004\u0002H]\u0001\r!!\u0013\t\u000f\u0005Us\u00031\u0001\u0002X!9\u0011QM\fA\u0002\u0005\u001d\u0004bBA7/\u0001\u0007\u0011\u0011\n\u0005\b\u0003_:\u0002\u0019AA9\u0011\u001d\tYh\u0006a\u0001\u0003{Bq!a\"\u0018\u0001\u0004\tI\tC\u0004\u0002\u0014^\u0001\r!!&\t\u000f\u0005mu\u00031\u0001\u0002 \"9\u0011qZ\fA\u0002\u0005E\u0007bBAl/\u0001\u0007\u0011\u0011\u001c\u0005\b\u0003?<\u0002\u0019AAq\u0011\u001d\tio\u0006a\u0001\u0003_\faa\u00197pg\u0016$WC\u0001B\u0016!\u0011\u0011iCa\r\u000e\u0005\t=\"\u0002\u0002B\u0019\u0003G\u000ba!\u0019;p[&\u001c\u0017\u0002\u0002B\u001b\u0005_\u0011Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017aB2m_N,G\rI\u0001\fCBLg+\u001a:tS>t7/\u0006\u0002\u0003>A!!q\bB#\u001b\t\u0011\tEC\u0002\u0003D]\fqa\u00197jK:$8/\u0003\u0003\u0003H\t\u0005#aC!qSZ+'o]5p]N\fA\"\u00199j-\u0016\u00148/[8og\u0002\n!B]1gi\u000e{gNZ5h+\t\u0011y\u0005\u0005\u0003\u0002\f\nE\u0013\u0002\u0002B*\u0003\u001b\u0013A\"U;peVl7i\u001c8gS\u001e\f1B]1gi\u000e{gNZ5hA\u0005\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e_\u000b\u0002I\u0006\tB\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u0011\u0002\u00151|wmQ8oi\u0016DH/\u0006\u0002\u0003bA!\u00111\u000fB2\u0013\u0011\u0011)'!\u001e\u0003\u00151{wmQ8oi\u0016DH/A\u0006m_\u001e\u001cuN\u001c;fqR\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\t\u0011i\u0007E\u0002s\u0005_J1A!\u001dt\u00059Y\u0015MZ6b'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!+\u0005A\u0016\u0001\u00033bi\u0006$\u0015N\u001d\u0011\u0002\u0017\u0011\fG/\u0019#je2{7m[\u000b\u0003\u0005{\u0002BaTALc\u0006aA-\u0019;b\t&\u0014Hj\\2lA\u0005i!/\u001a9mS\u000e\fG/\u001a3M_\u001e,\"A!\"\u0011\t\u0005-%qQ\u0005\u0005\u0005\u0013\u000biIA\u0007SKBd\u0017nY1uK\u0012dunZ\u0001\u000fe\u0016\u0004H.[2bi\u0016$Gj\\4!\u0003)qW\r^\"iC:tW\r\\\u000b\u0003\u0005#\u0003B!a#\u0003\u0014&!!QSAG\u0005MY\u0015MZ6b\u001d\u0016$xo\u001c:l\u0007\"\fgN\\3m\u0003-qW\r^\"iC:tW\r\u001c\u0011\u0002\u001f\u0015D\b/\u001b:bi&|g\u000eV5nKJ,\"A!(\u0011\t\t}%QU\u0007\u0003\u0005CS1Aa)t\u0003\u0015!\u0018.\\3s\u0013\u0011\u00119K!)\u0003\u0017MK8\u000f^3n)&lWM]\u0001\u0011Kb\u0004\u0018N]1uS>tG+[7fe\u0002\n\u0011#\u001a=qSJ\fG/[8o'\u0016\u0014h/[2f+\t\u0011y\u000bE\u0002L\u0005cK1Aa-F\u0005q!\u0016.\\5oO^CW-\u001a7FqBL'/\u0019;j_:\u001cVM\u001d<jG\u0016\f!#\u001a=qSJ\fG/[8o'\u0016\u0014h/[2fA\u000511\r\\5f]R,\"Aa/\u0011\r\u0005-%QXA\u0012\u0013\u0011\u0011y,!$\u0003\u001f-\u000bgm[1SC\u001a$8\t\\5f]R\fqa\u00197jK:$\b%\u0001\u0007dY&,g\u000e\u001e#sSZ,'/\u0006\u0002\u0003HB1\u00111\u0012Be\u0003GIAAa3\u0002\u000e\n)2*\u00194lCJ\u000bg\r^\"mS\u0016tG\u000f\u0012:jm\u0016\u0014\u0018!D2mS\u0016tG\u000f\u0012:jm\u0016\u0014\b%\u0001\u0005fq\u0016\u001cW\u000f^8s+\t\u0011\u0019\u000eE\u0003P\u0003/\u0013)\u000e\u0005\u0003\u0003X\n\rXB\u0001Bm\u0015\u0011\t)Ka7\u000b\u0007!\u0013iN\u0003\u0003\u0003`\n\u0005\u0018!C2p]\u001adW/\u001a8u\u0015\u0005Y\u0016\u0002\u0002Bs\u00053\u0014Q\"\u0012<f]R,\u00050Z2vi>\u0014\u0018\u0001D3yK\u000e,Ho\u001c:`I\u0015\fH\u0003\u0002Bv\u0005c\u00042a\u0014Bw\u0013\r\u0011y\u000f\u0015\u0002\u0005+:LG\u000fC\u0005\u0003tV\n\t\u00111\u0001\u0003T\u0006\u0019\u0001\u0010J\u0019\u0002\u0013\u0015DXmY;u_J\u0004\u0013aB:uCJ$X\u000f\u001d\u000b\u0003\u0005W\f\u0001b\u001d5vi\u0012|wO\\\u0001\te\u0016<\u0017n\u001d;feR!!1^B\u0001\u0011\u001d\u0019\u0019!\u000fa\u0001\u0007\u000b\t\u0001\u0002\\5ti\u0016tWM\u001d\t\u0007\u0007\u000f\u0019i!a\t\u000f\t\u0005-5\u0011B\u0005\u0005\u0007\u0017\ti)\u0001\u0006SC\u001a$8\t\\5f]RLAaa\u0004\u0004\u0012\tAA*[:uK:,'O\u0003\u0003\u0004\f\u00055\u0015!\u00045b]\u0012dWMU3rk\u0016\u001cH\u000f\u0006\u0006\u0004\u0018\r\u00152QGB \u0007\u0007\u0002b!!)\u0002*\u000ee\u0001\u0003BB\u000e\u0007Ci!a!\b\u000b\t\r}\u0011QJ\u0001\taJ|Go\\2pY&!11EB\u000f\u0005)\t\u0005/['fgN\fw-\u001a\u0005\b\u0007OQ\u0004\u0019AB\u0015\u0003\u001d\u0019wN\u001c;fqR\u0004Baa\u000b\u000425\u00111Q\u0006\u0006\u0005\u0007_\ti%\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0019\u0019d!\f\u0003\u001dI+\u0017/^3ti\u000e{g\u000e^3yi\"91q\u0007\u001eA\u0002\re\u0012A\u00025fC\u0012,'\u000f\u0005\u0003\u0004,\rm\u0012\u0002BB\u001f\u0007[\u0011QBU3rk\u0016\u001cH\u000fS3bI\u0016\u0014\bbBB!u\u0001\u00071\u0011D\u0001\be\u0016\fX/Z:u\u0011\u001d\u0019)E\u000fa\u0001\u0007\u000f\nQb\u0019:fCR,G\rV5nK6\u001b\bcA(\u0004J%\u001911\n)\u0003\t1{gnZ\u0001\u001e[\u0006L(-\u001a\"vS2$'+\u00194u':\f\u0007o\u001d5pi6\u000bg.Y4feR\u00111\u0011\u000b\t\u0006\u001f\u0006]51\u000b\t\u0005\u0007+\u001aI&\u0004\u0002\u0004X)\u0019a)!@\n\t\rm3q\u000b\u0002\u0015\u0017J\u000bg\r^*oCB\u001c\bn\u001c;NC:\fw-\u001a:\u0002\u001f\t,\u0018\u000e\u001c3SC\u001a$8\t\\5f]R$\"Aa/\u0002'\t,\u0018\u000e\u001c3OKR<xN]6DQ\u0006tg.\u001a7\u0015\u0005\tE\u0015!D2sK\u0006$X\rR1uC\u0012K'\u000fF\u0001Y\u0003A\u0011W/\u001b7e\u001b\u0016$\u0018\rZ1uC2{w\r\u0006\u0002\u0004nA\u00191ja\u001c\n\u0007\rETI\u0001\tLC\u001a\\\u0017-T3uC\u0012\fG/\u0019'pO\u0006\u0011\"-^5mI:+Go^8sW\u000ec\u0017.\u001a8u)\t\u00199\bE\u0004P\u0007s\u001aih!#\n\u0007\rm\u0004K\u0001\u0004UkBdWM\r\t\u0005\u0007\u007f\u001a))\u0004\u0002\u0004\u0002*!11QA'\u0003\u001dqW\r^<pe.LAaa\"\u0004\u0002\naA*[:uK:,'OT1nKB!!qHBF\u0013\u0011\u0019iI!\u0011\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u00039aW-\u00193fe\u0006sG-\u00129pG\",\"aa%\u0011\t\u0005-5QS\u0005\u0005\u0007/\u000biI\u0001\bMK\u0006$WM]!oI\u0016\u0003xn\u00195\u0002\u0013Y|G/\u001a:O_\u0012,GCBBO\u0007K\u001by\u000bE\u0003P\u0003/\u001by\n\u0005\u0003\u0002L\r\u0005\u0016\u0002BBR\u0003\u001b\u0012AAT8eK\"91q\u0015\"A\u0002\r%\u0016AA5e!\ry51V\u0005\u0004\u0007[\u0003&aA%oi\"911\u0001\"A\u0002\ru\u0014a\u0003:fG>\u0014HmU3sI\u0016,\"!a\u0016")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final String clusterId;
    private final KafkaConfig config;
    private final Uuid metadataLogDirUuid;
    private final RecordSerde<T> serde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final ExternalKRaftMetrics externalKRaftMetrics;
    private final CompletableFuture<Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture;
    private final Collection<InetSocketAddress> bootstrapServers;
    private final Endpoints localListeners;
    private final Optional<TierObjectStore> tierObjectStoreOpt;
    private final AtomicBoolean closed;
    private final ApiVersions apiVersions;
    private final QuorumConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final Option<FileLock> dataDirLock;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final KafkaRaftClientDriver<T> clientDriver;
    private Option<EventExecutor> executor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        KafkaRaftManager kafkaRaftManager = this;
        synchronized (kafkaRaftManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompletableFuture<Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private QuorumConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    private Option<FileLock> dataDirLock() {
        return this.dataDirLock;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private KafkaRaftClientDriver<T> clientDriver() {
        return this.clientDriver;
    }

    private Option<EventExecutor> executor() {
        return this.executor;
    }

    private void executor_$eq(Option<EventExecutor> x$1) {
        this.executor = x$1;
    }

    public void startup() {
        ((KafkaRaftClient)this.client()).initialize(this.controllerQuorumVotersFuture().get(), new FileQuorumStateStore(new File(this.dataDir(), "quorum-state")), this.metrics, this.externalKRaftMetrics);
        this.netChannel().start();
        this.clientDriver().start();
    }

    public void shutdown() {
        if (!this.closed().getAndSet(true)) {
            CoreUtils$.MODULE$.swallow(() -> this.expirationService().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
            Utils.closeQuietly(this.expirationTimer(), "expiration timer");
            CoreUtils$.MODULE$.swallow(() -> this.clientDriver().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
            Utils.closeQuietly(this.client(), "client");
            CoreUtils$.MODULE$.swallow(() -> this.scheduler().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
            Utils.closeQuietly(this.netChannel(), "net channel");
            Utils.closeQuietly(this.replicatedLog(), "replicated log");
            CoreUtils$.MODULE$.swallow(() -> this.dataDirLock().foreach((Function1<FileLock, Object> & Serializable)x$2 -> {
                x$2.destroy();
                return BoxedUnit.UNIT;
            }), this, CoreUtils$.MODULE$.swallow$default$3());
            CoreUtils$.MODULE$.swallow(() -> this.executor().foreach((Function1<EventExecutor, CompletableFuture> & Serializable)x$3 -> x$3.shutdown()), this, CoreUtils$.MODULE$.swallow$default$3());
            return;
        }
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        ((KafkaRaftClient)this.client()).register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestContext context, RequestHeader header, ApiMessage request, long createdTimeMs) {
        return this.clientDriver().handleRequest(context, header, request, createdTimeMs);
    }

    private Option<KRaftSnapshotManager> maybeBuildRaftSnapshotManager() {
        if (!Predef$.MODULE$.Boolean2boolean(this.config.confluentConfig().clusterMetadataSnapshotTierUploadEnableFlag())) {
            return None$.MODULE$;
        }
        if (!this.config.processRoles().contains(ProcessRole.ControllerRole)) {
            return None$.MODULE$;
        }
        if (!this.tierObjectStoreOpt.isPresent()) {
            throw new ConfigException("tier.enable is set to " + this.config.confluentConfig().tierEnable() + ", should be set to true");
        }
        Function<TopicIdPartition, Optional<Path>> topicIdPath = tpId -> {
            TopicIdPartition topicIdPartition = tpId;
            TopicIdPartition topicIdPartition2 = new TopicIdPartition(KafkaRaftServer$.MODULE$.MetadataTopicId(), KafkaRaftServer$.MODULE$.MetadataPartition());
            if (!(topicIdPartition != null ? !((Object)topicIdPartition).equals(topicIdPartition2) : topicIdPartition2 != null)) {
                return Optional.of(new File($this.config.metadataLogDir(), MergedLog$.MODULE$.logDirName($this.topicPartition)).toPath());
            }
            return Optional.empty();
        };
        int pendingTasksCapacity = 1024;
        this.executor_$eq(new Some<EventExecutor>(new DefaultEventExecutor(Executors.defaultThreadFactory(), pendingTasksCapacity)));
        return new Some<KRaftSnapshotManager>(KRaftSnapshotManager.create(this.executor().get(), this.tierObjectStoreOpt.get(), new KRaftSnapshotMetrics(this.metrics), this.logContext(), topicIdPath, this.clusterId, this.config.nodeId(), () -> $this.config.confluentConfig().clusterMetadataSnapshotTierDeleteEnableFlag(), () -> $this.config.confluentConfig().clusterMetadataSnapshotTierDeleteRetentionMs(), this.time));
    }

    private KafkaRaftClient<T> buildRaftClient() {
        ObjectRef<$colon$colon<Nothing$>> tracers = ObjectRef.create(new $colon$colon<Nothing$>((Nothing$)((Object)KRaftDurabilityAuditor$.MODULE$), Nil$.MODULE$));
        this.maybeBuildRaftSnapshotManager().foreach((Function1<KRaftSnapshotManager, Object> & Serializable)snapshotTracer -> {
            KafkaRaftManager.$anonfun$buildRaftClient$1(tracers, snapshotTracer);
            return BoxedUnit.UNIT;
        });
        return new KafkaRaftClient<T>(OptionalInt.of(this.config.nodeId()), this.metadataLogDirUuid, this.recordSerde(), this.netChannel(), this.replicatedLog(), this.time, this.expirationService(), this.logContext(), this.config.processRoles().contains(ProcessRole.ControllerRole), this.clusterId, this.bootstrapServers, this.localListeners, Feature.KRAFT_VERSION.supportedVersionRange(), this.raftConfig(), new CompositeRaftTracer(CollectionConverters$.MODULE$.SeqHasAsJava((List)tracers.elem).asJava(), this.logContext()));
    }

    private KafkaNetworkChannel buildNetworkChannel() {
        Tuple2<ListenerName, NetworkClient> tuple2 = this.buildNetworkClient();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListenerName listenerName = tuple2._1();
        NetworkClient netClient = tuple2._2();
        Tuple2<ListenerName, NetworkClient> tuple22 = new Tuple2<ListenerName, NetworkClient>(listenerName, netClient);
        ListenerName listenerName2 = tuple22._1();
        NetworkClient netClient2 = tuple22._2();
        return new KafkaNetworkChannel(this.time, listenerName2, netClient2, this.config.quorumConfig().requestTimeoutMs(), this.threadNamePrefix());
    }

    private File createDataDir() {
        String logDirName = MergedLog$.MODULE$.logDirName(this.topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, this.metrics, this.scheduler(), MetadataLogConfig$.MODULE$.apply(this.config, 0x800000, 0x800000), x$5 -> ((KafkaRaftClient)this.client()).traceLogStartOffsetChange(), x$6 -> ((KafkaRaftClient)this.client()).traceLogSnapshotGeneration());
    }

    private Tuple2<ListenerName, NetworkClient> buildNetworkClient() {
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        SecurityProtocol controllerSecurityProtocol = (SecurityProtocol)((Object)this.config.effectiveListenerSecurityProtocolMap().getOrElse(controllerListenerName, (Function0<SecurityProtocol> & Serializable)() -> SecurityProtocol.forName(controllerListenerName.value())));
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder(controllerSecurityProtocol, JaasContext.Type.SERVER, this.config, controllerListenerName, this.config.saslMechanismControllerProtocol(), this.time, this.logContext());
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, CollectionConverters$.MODULE$.MapHasAsJava(Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = "raft-client-" + this.config.nodeId();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        NetworkClient networkClient = new NetworkClient((Selectable)selector, new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, Int$.MODULE$.int2long(reconnectBackoffMs), Int$.MODULE$.int2long(reconnectBackoffMsMs), -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), this.config.quorumConfig().requestTimeoutMs(), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext(), MetadataRecoveryStrategy.NONE);
        return new Tuple2<ListenerName, NetworkClient>(controllerListenerName, networkClient);
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return ((KafkaRaftClient)this.client()).leaderAndEpoch();
    }

    @Override
    public Option<Node> voterNode(int id, ListenerName listener) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(((KafkaRaftClient)this.client()).voterNode(id, listener)));
    }

    @Override
    public RecordSerde<T> recordSerde() {
        return this.serde;
    }

    public static final /* synthetic */ void $anonfun$buildRaftClient$1(ObjectRef tracers$1, KRaftSnapshotManager snapshotTracer) {
        KRaftSnapshotManager kRaftSnapshotManager = snapshotTracer;
        tracers$1.elem = ((List)tracers$1.elem).$colon$colon(kRaftSnapshotManager);
    }

    public KafkaRaftManager(String clusterId, KafkaConfig config, Uuid metadataLogDirUuid, RecordSerde<T> serde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, ExternalKRaftMetrics externalKRaftMetrics, Option<String> threadNamePrefixOpt, CompletableFuture<Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture, Collection<InetSocketAddress> bootstrapServers, Endpoints localListeners, FaultHandler fatalFaultHandler, Optional<TierObjectStore> tierObjectStoreOpt) {
        this.clusterId = clusterId;
        this.config = config;
        this.metadataLogDirUuid = metadataLogDirUuid;
        this.serde = serde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.externalKRaftMetrics = externalKRaftMetrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.bootstrapServers = bootstrapServers;
        this.localListeners = localListeners;
        this.tierObjectStoreOpt = tierObjectStoreOpt;
        Logging.$init$(this);
        this.closed = new AtomicBoolean(false);
        this.apiVersions = new ApiVersions();
        this.raftConfig = new QuorumConfig(config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0<String> & Serializable)() -> "kafka-raft");
        this.logContext = new LogContext("[RaftManager id=" + config.nodeId() + "] ");
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, true, this.threadNamePrefix() + "-scheduler", false);
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        boolean differentMetadataLogDir = KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$hasDifferentLogDir(config);
        Set<ProcessRole> set = config.processRoles();
        Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProcessRole[]{ProcessRole.ControllerRole}));
        boolean isOnlyController = !(set != null ? !set.equals(object) : object != null);
        this.dataDirLock = differentMetadataLogDir || isOnlyController ? new Some<FileLock>(KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$lockDataDir(new File(config.metadataLogDir()))) : None$.MODULE$;
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor");
        this.expirationService = new TimingWheelExpirationService(this.expirationTimer());
        this.client = this.buildRaftClient();
        this.clientDriver = new KafkaRaftClientDriver(this.client(), this.threadNamePrefix(), fatalFaultHandler, this.logContext());
        this.executor = None$.MODULE$;
    }
}

