/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import kafka.restore.RestoreConfig;
import kafka.restore.configmap.NodeConfig;
import kafka.restore.messages.KafkaFenceRequest;
import kafka.restore.messages.KafkaFetchFtpsRequest;
import kafka.restore.messages.KafkaForceRestoreRequest;
import kafka.restore.messages.KafkaPreConditionCheckRequest;
import kafka.restore.messages.KafkaRequest;
import kafka.restore.messages.KafkaUnfreezeRequest;
import kafka.restore.messages.KafkaValidateLogRangeRequest;
import kafka.restore.schedulers.Constants;
import kafka.tier.store.S3VersionInformation;
import kafka.tier.store.VersionInformation;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerUtil.class);

    public static HttpPost buildKafkaHttpRequest(KafkaRequest kafkaRequest) throws UnsupportedEncodingException, URISyntaxException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("topic_name", kafkaRequest.getTopic());
        attributes.put("partition", String.valueOf(kafkaRequest.getPartition()));
        String path = null;
        if (kafkaRequest instanceof KafkaFenceRequest) {
            path = "/v1/restore/fence";
        } else if (kafkaRequest instanceof KafkaForceRestoreRequest) {
            KafkaForceRestoreRequest req = (KafkaForceRestoreRequest)kafkaRequest;
            attributes.put("log_start_offset", String.valueOf(req.getLogStartOffset()));
            attributes.put("log_end_offset", String.valueOf(req.getLogEndOffset()));
            attributes.put("content_hash", req.getContentHash());
            attributes.put("checksum_algorithm", String.valueOf(req.getChecksumAlgorithmId()));
            path = "/v1/restore/restore";
        } else if (kafkaRequest instanceof KafkaUnfreezeRequest) {
            path = "/v1/restore/unfreeze";
        } else if (kafkaRequest instanceof KafkaValidateLogRangeRequest) {
            KafkaValidateLogRangeRequest req = (KafkaValidateLogRangeRequest)kafkaRequest;
            attributes.put("log_start_offset", String.valueOf(req.getLogStartOffset()));
            attributes.put("log_end_offset", String.valueOf(req.getLogEndOffset()));
            path = "/v1/restore/validate-log-range";
        } else if (kafkaRequest instanceof KafkaFetchFtpsRequest) {
            path = "/v1/restore/ftps";
        } else if (kafkaRequest instanceof KafkaPreConditionCheckRequest) {
            path = "/v1/restore/pre-checks";
        } else {
            throw new IllegalArgumentException("KafkaRequest type not support: " + kafkaRequest.getClass().getName());
        }
        return SchedulerUtil.buildKafkaHttpRequest(kafkaRequest.getBroker(), path, attributes);
    }

    public static HttpPost buildKafkaHttpRequest(NodeConfig broker, String path, Map<String, String> attributes) throws URISyntaxException, UnsupportedEncodingException {
        URI uri = new URIBuilder(SchedulerUtil.getBrokerUrl(broker) + path).build();
        HttpPost post = new HttpPost(uri);
        post.addHeader("topic_partition", attributes.get("topic_name") + "-" + attributes.get("partition"));
        StringBuilder body = new StringBuilder();
        if (attributes.size() > 0) {
            body.append("{");
            attributes.forEach((k, v) -> body.append("\"").append((String)k).append("\": \"").append((String)v).append("\","));
            body.deleteCharAt(body.length() - 1);
            body.append("}");
        }
        LOGGER.debug("build http request with uri: " + uri.toString() + ", body: " + body.toString());
        StringEntity params = new StringEntity(body.toString());
        post.addHeader("content-type", "application/x-www-form-urlencoded");
        post.setEntity(params);
        return post;
    }

    public static String getBrokerUrl(NodeConfig broker) {
        return "http://" + broker.getHost() + ":" + RestoreConfig.kafkaInternalRestServerPort;
    }

    public static int getOptimalPoolSizeForKafka(double availableCores) {
        return (int)Math.max(1L, Math.round(availableCores * 101.0));
    }

    public static CloseableHttpClient buildHttpClient(PoolingHttpClientConnectionManager connectionManager) {
        return HttpClients.custom().setConnectionManager(connectionManager).addInterceptorLast((request, context) -> context.setAttribute("topic_partition", request.getFirstHeader("topic_partition").getValue())).addInterceptorLast((response, context) -> {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                Object topicPartition = context.getAttribute("topic_partition");
                String errorMessage = String.format("[%s]: Received non-successful status code %s in response.", topicPartition, statusCode);
                LOGGER.error(errorMessage + " throws IOException to trigger retry.");
                throw new IOException(errorMessage);
            }
        }).setRetryHandler((exception, executionCount, context) -> {
            Object topicPartition = context.getAttribute("topic_partition");
            if (executionCount < 10) {
                long delayMS = Constants.HTTP_RETRY_INTERVAL_IN_MS * (long)executionCount;
                try {
                    LOGGER.info(String.format("[%s]: httpclient retry #%s, sleeping for %s ms before retry.", topicPartition, executionCount, delayMS), (Throwable)exception);
                    Thread.sleep(delayMS);
                    return true;
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.error(String.format("[%s]: KafkaConnectionPool was interrupted while waiting to retry HTTP request. Giving up on retrying request.", topicPartition), (Throwable)interruptedException);
                    return false;
                }
            }
            LOGGER.error("[{}]: exhaust max http retries: {}", topicPartition, (Object)10);
            return false;
        }).build();
    }

    public static void saveHttpResponseToFile(HttpResponse httpResponse, String filePath) throws IOException {
        int inByte;
        InputStream is = httpResponse.getEntity().getContent();
        File destFile = new File(filePath);
        Files.deleteIfExists(destFile.toPath());
        destFile.createNewFile();
        FileOutputStream fos = new FileOutputStream(destFile);
        while ((inByte = is.read()) != -1) {
            fos.write(inByte);
        }
        is.close();
        fos.close();
    }

    public static synchronized String getThreadPoolExecutorStatus(String prefix, ThreadPoolExecutor executor) {
        return String.format("[%s] [%d/%d] Active: %d, Completed: %d, Task: %d, isShutdown: %s, isTerminated: %s, QueueSize: %s", prefix, executor.getPoolSize(), executor.getCorePoolSize(), executor.getActiveCount(), executor.getCompletedTaskCount(), executor.getTaskCount(), executor.isShutdown(), executor.isTerminated(), executor.getQueue().size());
    }

    public static String getLastLiveVersionId(String object, List<VersionInformation> vList) {
        String errorMessage = "no version found from object store for " + object;
        if (vList == null) {
            LOGGER.warn(errorMessage);
            return null;
        }
        for (VersionInformation v : vList) {
            if (v instanceof S3VersionInformation) {
                S3VersionInformation s3v = (S3VersionInformation)v;
                if (s3v.isDeleteMarker()) continue;
                return v.getVersionId();
            }
            return v.getVersionId();
        }
        LOGGER.warn(errorMessage);
        return null;
    }
}

