/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.BrokerBlockingSender;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.network.BrokerEndPoint;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.ScalaRunTime$;

public final class BrokerBlockingSender$ {
    public static final BrokerBlockingSender$ MODULE$ = new BrokerBlockingSender$();

    public BrokerBlockingSender apply(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, Metrics metrics, Time time, int fetcherId, String clientId, LogContext logContext, Map<String, String> extraMetricTags) {
        int socketTimeout = Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketTimeoutMs());
        Tuple2<NetworkClient, Option<Reconfigurable>> tuple2 = this.createNetworkClientAndReconfigurableChannelBuilder(sourceBroker, brokerConfig, metrics, time, fetcherId, clientId, logContext, extraMetricTags, this.createNetworkClientAndReconfigurableChannelBuilder$default$9());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        NetworkClient networkClient = tuple2._1();
        Option<Reconfigurable> reconfigurableChannelBuilder = tuple2._2();
        Tuple2<NetworkClient, Option<Reconfigurable>> tuple22 = new Tuple2<NetworkClient, Option<Reconfigurable>>(networkClient, reconfigurableChannelBuilder);
        NetworkClient networkClient2 = tuple22._1();
        Option<Reconfigurable> reconfigurableChannelBuilder2 = tuple22._2();
        return new BrokerBlockingSender(sourceBroker, brokerConfig, socketTimeout, time, fetcherId, networkClient2, reconfigurableChannelBuilder2);
    }

    public Map<String, String> apply$default$8() {
        return (Map)Map$.MODULE$.empty();
    }

    public Tuple2<NetworkClient, Option<Reconfigurable>> createNetworkClientAndReconfigurableChannelBuilder(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, Metrics metrics, Time time, int fetcherId, String clientId, LogContext logContext, Map<String, String> extraMetricTags, String metricGrpPrefix) {
        Option option;
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder(brokerConfig.interBrokerSecurityProtocol(), JaasContext.Type.SERVER, brokerConfig, brokerConfig.interBrokerListenerName(), brokerConfig.saslMechanismInterBrokerProtocol(), time, logContext);
        ChannelBuilder channelBuilder2 = channelBuilder;
        if (channelBuilder2 instanceof Reconfigurable) {
            ChannelBuilder channelBuilder3 = channelBuilder2;
            brokerConfig.addReconfigurable((Reconfigurable)((Object)channelBuilder3));
            option = new Some<ChannelBuilder>(channelBuilder3);
        } else {
            option = None$.MODULE$;
        }
        None$ reconfigurableChannelBuilder = option;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(brokerConfig.connectionsMaxIdleMs()), metrics, time, metricGrpPrefix, CollectionConverters$.MODULE$.MapHasAsJava((Map)extraMetricTags.$plus$plus((IterableOnce)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("broker-id"), Integer.toString(sourceBroker.id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("fetcher-id"), Integer.toString(fetcherId))})))).asJava(), false, channelBuilder, logContext);
        NetworkClient networkClient = new NetworkClient((Selectable)selector, new ManualMetadataUpdater(), clientId, 1, 0L, 0L, -1, Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(brokerConfig.requestTimeoutMs()), Predef$.MODULE$.Long2long(brokerConfig.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(brokerConfig.connectionSetupTimeoutMaxMs()), time, false, new ApiVersions(), logContext, MetadataRecoveryStrategy.NONE);
        return new Tuple2<NetworkClient, Option<Reconfigurable>>(networkClient, reconfigurableChannelBuilder);
    }

    public Map<String, String> createNetworkClientAndReconfigurableChannelBuilder$default$8() {
        return (Map)Map$.MODULE$.empty();
    }

    public String createNetworkClientAndReconfigurableChannelBuilder$default$9() {
        return "replica-fetcher";
    }

    private BrokerBlockingSender$() {
    }
}

