/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.conflux.concurrent.CxCompletableFutureUtil;
import io.confluent.k2.kafka.AssignmentContext;
import io.confluent.k2.kafka.K2MetadataStore;
import io.confluent.k2.kafka.K2Node;
import io.confluent.k2.kafka.K2Stack;
import io.confluent.k2.kafka.K2TopicMetadata;
import io.confluent.k2.kafka.image.publisher.K2MetadataPublisher;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.common.TenantHelpers;
import kafka.server.metadata.K2MetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.ConfluentPartitionsPerTopicListener;
import org.apache.kafka.server.immutable.ImmutableSet;
import org.apache.kafka.server.multitenant.LogicalClusterMetadata;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.apache.kafka.server.util.KafkaScheduler;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\t]f\u0001B\u001b7\u0001mB\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\t+\u0002\u0011\t\u0011)A\u0005-\"A\u0011\r\u0001B\u0001B\u0003%!\r\u0003\u0005i\u0001\t\u0005\t\u0015!\u0003j\u0011!a\u0007A!A!\u0002\u0013i\u0007\u0002\u0003;\u0001\u0005\u0003\u0005\u000b\u0011B;\t\u0011u\u0004!\u0011!Q\u0001\nyDq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002\"\u0001!\t&a\t\t\u000f\u0005m\u0002\u0001\"\u0003\u0002>!I\u0011q\b\u0001C\u0002\u0013%\u0011\u0011\t\u0005\b\u0003\u0007\u0002\u0001\u0015!\u0003j\u0011%\t)\u0005\u0001b\u0001\n\u0013\t\t\u0005C\u0004\u0002H\u0001\u0001\u000b\u0011B5\t\u0013\u0005%\u0003\u00011A\u0005\n\u0005-\u0003\"CA>\u0001\u0001\u0007I\u0011BA?\u0011!\tY\u0007\u0001Q!\n\u00055\u0003\"CAJ\u0001\t\u0007I\u0011BAK\u0011!\tI\u000b\u0001Q\u0001\n\u0005]\u0005\"CAV\u0001\u0001\u0007I\u0011BA!\u0011%\ti\u000b\u0001a\u0001\n\u0013\ty\u000bC\u0004\u00024\u0002\u0001\u000b\u0015B5\t\u0013\u0005U\u0006\u00011A\u0005\n\u0005\u0005\u0003\"CA\\\u0001\u0001\u0007I\u0011BA]\u0011\u001d\ti\f\u0001Q!\n%D\u0011\"a0\u0001\u0001\u0004%I!!1\t\u0013\u0005U\u0007\u00011A\u0005\n\u0005]\u0007\u0002CAn\u0001\u0001\u0006K!a1\u0006\r\u0005u\u0007\u0001AAp\u000b\u0019\t)\u0010\u0001\u0001\u0002x\"I!1\u0001\u0001A\u0002\u0013%!Q\u0001\u0005\n\u0005\u001b\u0001\u0001\u0019!C\u0005\u0005\u001fA\u0001Ba\u0005\u0001A\u0003&!q\u0001\u0005\n\u0005+\u0001\u0001\u0019!C\u0005\u0003\u0003B\u0011Ba\u0006\u0001\u0001\u0004%IA!\u0007\t\u000f\tu\u0001\u0001)Q\u0005S\"9!q\u0004\u0001\u0005\n\t\u0005\u0002\"\u0003B\u0016\u0001\t\u0007I\u0011\u0002B\u0017\u0011!\u0011)\u0004\u0001Q\u0001\n\t=\u0002b\u0002B\u001c\u0001\u0011\u0005!\u0011\b\u0005\b\u0005?\u0002A\u0011\u0001B1\u0011!\u0011\u0019\u0007\u0001C\u0001m\t\u0015\u0004b\u0002B5\u0001\u0011%!1\u000e\u0005\b\u0005w\u0002A\u0011\u0002B1\u0011\u001d\u0011i\b\u0001C\u0005\u0005\u007fBqA!\"\u0001\t\u0013\t\t\rC\u0004\u0003\b\u0002!IA!#\t\u000f\t=\u0005\u0001\"\u0003\u0003\u0006!9!\u0011\u0013\u0001\u0005\n\t\u0005\u0004b\u0002BJ\u0001\u0011%!Q\u0013\u0005\b\u0005G\u0003A\u0011\u0002BS\u0011\u001d\u0011\t\f\u0001C\u0005\u0005g\u0013\u0001d\u0013\u001aNKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a)paVd\u0017\r^8s\u0015\t9\u0004(\u0001\u0004tKJ4XM\u001d\u0006\u0002s\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001=\u0005B\u0011Q\bQ\u0007\u0002})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B}\t1\u0011I\\=SK\u001a\u0004\"a\u0011$\u000e\u0003\u0011S!!\u0012\u001d\u0002\u000bU$\u0018\u000e\\:\n\u0005\u001d#%a\u0002'pO\u001eLgnZ\u0001\u000fW\u000647.Y*dQ\u0016$W\u000f\\3s!\tQ5+D\u0001L\u0015\taU*\u0001\u0003vi&d'BA\u001cO\u0015\tItJ\u0003\u0002Q#\u00061\u0011\r]1dQ\u0016T\u0011AU\u0001\u0004_J<\u0017B\u0001+L\u00059Y\u0015MZ6b'\u000eDW\rZ;mKJ\fQa\u001d;bG.\u0004\"aV0\u000e\u0003aS!!O-\u000b\u0005i[\u0016AA63\u0015\taV,A\u0005d_:4G.^3oi*\ta,\u0001\u0002j_&\u0011\u0001\r\u0017\u0002\b\u0017J\u001aF/Y2l\u0003=Y''T3uC\u0012\fG/Y\"bG\",\u0007CA2g\u001b\u0005!'BA37\u0003!iW\r^1eCR\f\u0017BA4e\u0005=Y%'T3uC\u0012\fG/Y\"bG\",\u0017a\u0005:fMJ,7\u000f\u001b)fe&|G-T5mY&\u001c\bCA\u001fk\u0013\tYgH\u0001\u0003M_:<\u0017\u0001\u0002;j[\u0016\u0004\"A\u001c:\u000e\u0003=T!!\u00129\u000b\u0005Et\u0015AB2p[6|g.\u0003\u0002t_\n!A+[7f\u0003\r\u001awN\u001c4mk\u0016tG\u000fU1si&$\u0018n\u001c8t!\u0016\u0014Hk\u001c9jG2K7\u000f^3oKJ\u00042!\u0010<y\u0013\t9hH\u0001\u0004PaRLwN\u001c\t\u0003snl\u0011A\u001f\u0006\u0003K:K!\u0001 >\u0003G\r{gN\u001a7vK:$\b+\u0019:uSRLwN\\:QKJ$v\u000e]5d\u0019&\u001cH/\u001a8fe\u0006\u0019R.\u001e7uSR+g.\u00198u\u001b\u0016$\u0018\rZ1uCB\u0019QH^@\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002N\u0003-iW\u000f\u001c;ji\u0016t\u0017M\u001c;\n\t\u0005%\u00111\u0001\u0002\u0014\u001bVdG/\u001b+f]\u0006tG/T3uC\u0012\fG/Y\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005=\u00111CA\u000b\u0003/\tI\"a\u0007\u0002\u001e\u0005}\u0001cAA\t\u00015\ta\u0007C\u0003I\u0011\u0001\u0007\u0011\nC\u0003V\u0011\u0001\u0007a\u000bC\u0003b\u0011\u0001\u0007!\rC\u0003i\u0011\u0001\u0007\u0011\u000eC\u0003m\u0011\u0001\u0007Q\u000eC\u0003u\u0011\u0001\u0007Q\u000fC\u0003~\u0011\u0001\u0007a0\u0001\u0006m_\u001e<WM\u001d(b[\u0016,\"!!\n\u0011\t\u0005\u001d\u0012Q\u0007\b\u0005\u0003S\t\t\u0004E\u0002\u0002,yj!!!\f\u000b\u0007\u0005=\"(\u0001\u0004=e>|GOP\u0005\u0004\u0003gq\u0014A\u0002)sK\u0012,g-\u0003\u0003\u00028\u0005e\"AB*ue&twMC\u0002\u00024y\n1cY;se\u0016tG\u000fS5SKN\u001cEn\\2l\u001bN$\u0012![\u0001\u0013\u0007\"+5iS0F-\u0016\u0013\u0016lX'J\u00192K5+F\u0001j\u0003M\u0019\u0005*R\"L?\u00163VIU-`\u001b&cE*S*!\u00039i\u0015JT0C\u0003\u000e[uJ\u0012$`\u001bN\u000bq\"T%O?\n\u000b5iS(G\r~k5\u000bI\u0001\u001dWJjU\r^1eCR\f7)Y2iKV\u0003H-\u0019;fe\u001a+H/\u001e:f+\t\ti\u0005\u0005\u0003>m\u0006=\u0003\u0007BA)\u0003O\u0002b!a\u0015\u0002`\u0005\rTBAA+\u0015\u0011\t9&!\u0017\u0002\u0015\r|gnY;se\u0016tGOC\u0002M\u00037R!!!\u0018\u0002\t)\fg/Y\u0005\u0005\u0003C\n)FA\bTG\",G-\u001e7fI\u001a+H/\u001e:f!\u0011\t)'a\u001a\r\u0001\u0011Y\u0011\u0011N\t\u0002\u0002\u0003\u0005)\u0011AA7\u0005\ryF%M\u0001\u001eWJjU\r^1eCR\f7)Y2iKV\u0003H-\u0019;fe\u001a+H/\u001e:fAE!\u0011qNA;!\ri\u0014\u0011O\u0005\u0004\u0003gr$a\u0002(pi\"Lgn\u001a\t\u0004{\u0005]\u0014bAA=}\t\u0019\u0011I\\=\u0002A-\u0014T*\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0006\u000fZ1uKJ4U\u000f^;sK~#S-\u001d\u000b\u0005\u0003\u007f\n)\tE\u0002>\u0003\u0003K1!a!?\u0005\u0011)f.\u001b;\t\u0013\u0005\u001d\u0005#!AA\u0002\u0005%\u0015a\u0001=%cA!QH^AFa\u0011\ti)!%\u0011\r\u0005M\u0013qLAH!\u0011\t)'!%\u0005\u0019\u0005%\u0014QQA\u0001\u0002\u0003\u0015\t!!\u001c\u0002I%t\u0017\u000e^5bY6+G/\u00193bi\u0006\u001c\u0015m\u00195f!>\u0004X\u000f\\1uS>tg)\u001e;ve\u0016,\"!a&\u0011\r\u0005M\u0013\u0011TAO\u0013\u0011\tY*!\u0016\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0003\u0002 \u0006\u0015VBAAQ\u0015\u0011\t\u0019+a\u0017\u0002\t1\fgnZ\u0005\u0005\u0003O\u000b\tK\u0001\u0003W_&$\u0017!J5oSRL\u0017\r\\'fi\u0006$\u0017\r^1DC\u000eDW\rU8qk2\fG/[8o\rV$XO]3!\u0003aqW\r\u001f;Q_B,H.\u0019;f\u0011&\u0014Vm]\"m_\u000e\\Wj]\u0001\u001d]\u0016DH\u000fU8qk2\fG/\u001a%j%\u0016\u001c8\t\\8dW6\u001bx\fJ3r)\u0011\ty(!-\t\u0011\u0005\u001dU#!AA\u0002%\f\u0011D\\3yiB{\u0007/\u001e7bi\u0016D\u0015NU3t\u00072|7m['tA\u0005iA.Y:u\u0005\u0006\u001c7n\u001c4g\u001bN\f\u0011\u0003\\1ti\n\u000b7m[8gM6\u001bx\fJ3r)\u0011\ty(a/\t\u0011\u0005\u001d\u0005$!AA\u0002%\fa\u0002\\1ti\n\u000b7m[8gM6\u001b\b%\u0001\tmSN$Hk\u001c9jGN4U\u000f^;sKV\u0011\u00111\u0019\t\u0005{Y\f)\r\u0005\u0004\u0002T\u0005e\u0015q\u0019\t\u0007\u0003\u0013\fY-a4\u000e\u0005\u0005e\u0013\u0002BAg\u00033\u0012A\u0001T5tiB\u0019q+!5\n\u0007\u0005M\u0007LA\bLeQ{\u0007/[2NKR\fG-\u0019;b\u0003Qa\u0017n\u001d;U_BL7m\u001d$viV\u0014Xm\u0018\u0013fcR!\u0011qPAm\u0011%\t9iGA\u0001\u0002\u0004\t\u0019-A\tmSN$Hk\u001c9jGN4U\u000f^;sK\u0002\u0012A\u0003U1si&$\u0018n\u001c8BgNLwM\\7f]R\u001c\b\u0003CAe\u0003C\f)/!<\n\t\u0005\r\u0018\u0011\f\u0002\u0004\u001b\u0006\u0004\b\u0003BAt\u0003Sl\u0011\u0001]\u0005\u0004\u0003W\u0004(\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o!\u0019\tI-a3\u0002pB\u0019q+!=\n\u0007\u0005M\bL\u0001\u0004Le9{G-\u001a\u0002\u0011)>\u0004\u0018nY!tg&<g.\\3oiN\u0004\u0002\"!3\u0002b\u0006e\u0018q \t\u0005\u0003O\fY0C\u0002\u0002~B\u0014A!V;jIB\u0019!\u0011A\u000f\u000e\u0003\u0001\t\u0001#Y:tS\u001etW.\u001a8u\rV$XO]3\u0016\u0005\t\u001d\u0001\u0003B\u001fw\u0005\u0013\u0001b!a\u0015\u0002\u001a\n-\u0001c\u0001B\u0001=\u0005!\u0012m]:jO:lWM\u001c;GkR,(/Z0%KF$B!a \u0003\u0012!I\u0011q\u0011\u0011\u0002\u0002\u0003\u0007!qA\u0001\u0012CN\u001c\u0018n\u001a8nK:$h)\u001e;ve\u0016\u0004\u0013a\u00057bgRdun\u001a%j%\u0016\u001c8\t\\8dW6\u001b\u0018a\u00067bgRdun\u001a%j%\u0016\u001c8\t\\8dW6\u001bx\fJ3r)\u0011\tyHa\u0007\t\u0011\u0005\u001d5%!AA\u0002%\fA\u0003\\1ti2{w\rS5SKN\u001cEn\\2l\u001bN\u0004\u0013A\u00047pO\u00163XM]=NS2d\u0017n\u001d\u000b\u0007\u0003\u007f\u0012\u0019Ca\n\t\r\t\u0015R\u00051\u0001j\u0003U\tG/T8ti>s7-Z#wKJLX*\u001b7mSNDqA!\u000b&\u0001\u0004\t)#A\u0004nKN\u001c\u0018mZ3\u0002\u0011\u0015DXmY;u_J,\"Aa\f\u0011\t\u0005M#\u0011G\u0005\u0005\u0005g\t)FA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003%)\u00070Z2vi>\u0014\b%A\u0004ti\u0006\u0014H/\u001e9\u0015\t\u0005]%1\b\u0005\b\u0005{A\u0003\u0019\u0001B \u0003Q!wn\u001e8tiJ,\u0017-\\\"p[B|g.\u001a8ugB1!\u0011\tB&\u0005\u001frAAa\u0011\u0003H9!\u00111\u0006B#\u0013\u0005y\u0014b\u0001B%}\u00059\u0001/Y2lC\u001e,\u0017\u0002BAg\u0005\u001bR1A!\u0013?!\u0011\u0011\tFa\u0017\u000e\u0005\tM#\u0002\u0002B+\u0005/\n\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0007\te\u0003,A\u0003j[\u0006<W-\u0003\u0003\u0003^\tM#aE&3\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u0014\u0018!B2m_N,GCAA@\u0003]!w\u000eU8qk2\fG/Z'fi\u0006$\u0017\r^1DC\u000eDW\r\u0006\u0003\u0002\u0000\t\u001d\u0004b\u0002B\u001fU\u0001\u0007!qH\u0001\u0018G>l\u0007/\u001e;f)>\u0004\u0018nY!tg&<g.\\3oiN$bA!\u0003\u0003n\tE\u0004b\u0002B8W\u0001\u0007\u0011qY\u0001\r_:d\u0017N\\3U_BL7m\u001d\u0005\b\u0005gZ\u0003\u0019\u0001B;\u0003\t)\u0007\u0010\u0005\u0003\u0002T\t]\u0014\u0002\u0002B=\u0003+\u0012\u0001\"\u0012=fGV$xN]\u0001\u0012g\u0016$hj\u001c;iS:<'+\u001e8oS:<\u0017AG:fi\u0006sG\rT8h\u0019&\u001cH\u000fV8qS\u000e\u001c(+\u001e8oS:<G\u0003BA@\u0005\u0003CqAa!.\u0001\u0004\t)-\u0001\u0004gkR,(/Z\u0001\u0015O\u0016$(+\u001e8oS:<G*[:u)>\u0004\u0018nY:\u00025M,G/\u00118e\u0019><\u0017i]:jO:lWM\u001c;Sk:t\u0017N\\4\u0015\r\u0005}$1\u0012BG\u0011\u001d\u0011\u0019i\fa\u0001\u0005\u0013AqA!\u000b0\u0001\u0004\t)#\u0001\u000bhKR\u0014VO\u001c8j]\u001e\f5o]5h]6,g\u000e^\u0001 g\u0016$\u0018I\u001c3M_\u001etU\r\u001f;Sk:$\u0016.\\3Va>t7+^2dKN\u001c\u0018!\t7pO\u0006sGMU3uef<\u0016\u000e\u001e5CC\u000e\\wN\u001a4Va>tg)Y5mkJ,GCBA@\u0005/\u0013I\nC\u0004\u0003*I\u0002\r!!\n\t\u000f\tm%\u00071\u0001\u0003\u001e\u0006IA\u000f\u001b:po\u0006\u0014G.\u001a\t\u0005\u0005\u0003\u0012y*\u0003\u0003\u0003\"\n5#!\u0003+ie><\u0018M\u00197f\u0003Y\u0019\b\u000f\\5u\u001f:d\u0017N\\3B]\u0012$U\r\\3uS:<G\u0003\u0002BT\u0005[\u0003r!\u0010BU\u0003\u000f\f9-C\u0002\u0003,z\u0012a\u0001V;qY\u0016\u0014\u0004b\u0002BXg\u0001\u0007\u0011qY\u0001\nC2dGk\u001c9jGN\fq&\\1zE\u0016\u001cVM\u001c3Gk2dW\u000b\u001d3bi\u0016$v\u000eU1si&$\u0018n\u001c8t!\u0016\u0014Hk\u001c9jG2K7\u000f^3oKJ$B!a \u00036\"9!q\u000e\u001bA\u0002\u0005\u001d\u0007")
public class K2MetadataCachePopulator
implements Logging {
    private final KafkaScheduler kafkaScheduler;
    private final K2Stack stack;
    private final K2MetadataCache k2MetadataCache;
    private final long refreshPeriodMillis;
    private final Time time;
    private final Option<ConfluentPartitionsPerTopicListener> confluentPartitionsPerTopicListener;
    private final Option<MultiTenantMetadata> multiTenantMetadata;
    private final long CHECK_EVERY_MILLIS;
    private final long MIN_BACKOFF_MS;
    private Option<ScheduledFuture<?>> k2MetadataCacheUpdaterFuture;
    private final CompletableFuture<Void> initialMetadataCachePopulationFuture;
    private long nextPopulateHiResClockMs;
    private long lastBackoffMs;
    private Option<CompletableFuture<java.util.List<K2TopicMetadata>>> listTopicsFuture;
    private Option<CompletableFuture<Map<Uuid, Map<TopicIdPartition, java.util.List<K2Node>>>>> assignmentFuture;
    private long lastLogHiResClockMs;
    private final ExecutorService executor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        K2MetadataCachePopulator k2MetadataCachePopulator = this;
        synchronized (k2MetadataCachePopulator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return this.getClass().getName();
    }

    private long currentHiResClockMs() {
        return this.time.hiResClockMs();
    }

    private long CHECK_EVERY_MILLIS() {
        return this.CHECK_EVERY_MILLIS;
    }

    private long MIN_BACKOFF_MS() {
        return this.MIN_BACKOFF_MS;
    }

    private Option<ScheduledFuture<?>> k2MetadataCacheUpdaterFuture() {
        return this.k2MetadataCacheUpdaterFuture;
    }

    private void k2MetadataCacheUpdaterFuture_$eq(Option<ScheduledFuture<?>> x$1) {
        this.k2MetadataCacheUpdaterFuture = x$1;
    }

    private CompletableFuture<Void> initialMetadataCachePopulationFuture() {
        return this.initialMetadataCachePopulationFuture;
    }

    private long nextPopulateHiResClockMs() {
        return this.nextPopulateHiResClockMs;
    }

    private void nextPopulateHiResClockMs_$eq(long x$1) {
        this.nextPopulateHiResClockMs = x$1;
    }

    private long lastBackoffMs() {
        return this.lastBackoffMs;
    }

    private void lastBackoffMs_$eq(long x$1) {
        this.lastBackoffMs = x$1;
    }

    private Option<CompletableFuture<java.util.List<K2TopicMetadata>>> listTopicsFuture() {
        return this.listTopicsFuture;
    }

    private void listTopicsFuture_$eq(Option<CompletableFuture<java.util.List<K2TopicMetadata>>> x$1) {
        this.listTopicsFuture = x$1;
    }

    private Option<CompletableFuture<Map<Uuid, Map<TopicIdPartition, java.util.List<K2Node>>>>> assignmentFuture() {
        return this.assignmentFuture;
    }

    private void assignmentFuture_$eq(Option<CompletableFuture<Map<Uuid, Map<TopicIdPartition, java.util.List<K2Node>>>>> x$1) {
        this.assignmentFuture = x$1;
    }

    private long lastLogHiResClockMs() {
        return this.lastLogHiResClockMs;
    }

    private void lastLogHiResClockMs_$eq(long x$1) {
        this.lastLogHiResClockMs = x$1;
    }

    private void logEveryMillis(long atMostOnceEveryMillis, String message) {
        long nowHiResClockMs = this.time.hiResClockMs();
        if (nowHiResClockMs - this.lastLogHiResClockMs() > atMostOnceEveryMillis) {
            this.lastLogHiResClockMs_$eq(nowHiResClockMs);
            this.info((Function0<String> & Serializable)() -> message);
            return;
        }
    }

    private ExecutorService executor() {
        return this.executor;
    }

    public synchronized CompletableFuture<Void> startup(List<K2MetadataPublisher> downstreamComponents) {
        this.k2MetadataCacheUpdaterFuture_$eq(new Some(this.kafkaScheduler.schedule("k2metadatacacheupdater", () -> this.doPopulateMetadataCache(downstreamComponents), 0L, this.CHECK_EVERY_MILLIS())));
        return this.initialMetadataCachePopulationFuture();
    }

    public void close() {
        K2MetadataCachePopulator k2MetadataCachePopulator = this;
        synchronized (k2MetadataCachePopulator) {
            this.k2MetadataCacheUpdaterFuture().foreach((Function1<ScheduledFuture, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.cancel(true)));
            this.initialMetadataCachePopulationFuture().cancel(true);
            this.executor().shutdownNow();
        }
    }

    public synchronized void doPopulateMetadataCache(List<K2MetadataPublisher> downstreamComponents) {
        long nextRunHiResClockMs;
        boolean beforeNextRunTime;
        boolean somethingRunning;
        boolean bl = somethingRunning = this.getRunningListTopics().nonEmpty() || this.getRunningAssignment().nonEmpty();
        if (somethingRunning) {
            this.logEveryMillis(5000L, "Skipping (an update is already running)");
            return;
        }
        long nowHiResClockMs = this.currentHiResClockMs();
        boolean bl2 = beforeNextRunTime = nowHiResClockMs < (nextRunHiResClockMs = this.nextPopulateHiResClockMs());
        if (beforeNextRunTime) {
            long nextRunInMs = nextRunHiResClockMs - nowHiResClockMs;
            if (this.lastBackoffMs() > 0L) {
                this.logEveryMillis(1000L, "Skipping (we are backing off due to an error, expect next run no sooner than " + nextRunInMs + " ms from now)");
            } else {
                this.logEveryMillis(5000L, "Skipping (refreshPeriodMillis=" + this.refreshPeriodMillis + " has not yet elapsed since the last update successfully completed, expect next run no sooner than " + nextRunInMs + " ms from now)");
            }
            return;
        }
        try {
            CompletableFuture<java.util.List<K2TopicMetadata>> listTopicsFuture = CxCompletableFutureUtil.toCompletableFuture(this.stack.topicMetadata().listTopics(K2MetadataStore.Filter.NONE), this.executor());
            this.setAndLogListTopicsRunning(listTopicsFuture);
        }
        catch (Throwable t) {
            this.logAndRetryWithBackoffUponFailure("Error submitting query of topic metadata store for all topics", t);
            return;
        }
        this.getRunningListTopics().foreach((Function1<CompletableFuture, CompletableFuture> & Serializable)x$2 -> x$2.whenCompleteAsync((allTopics, throwable) -> {
            K2MetadataCachePopulator k2MetadataCachePopulator = this;
            synchronized (k2MetadataCachePopulator) {
                if (throwable != null) {
                    this.logAndRetryWithBackoffUponFailure("Error querying topic metadata store for all topics", (Throwable)throwable);
                } else {
                    ObjectRef<Object> onlineTopics = ObjectRef.create(null);
                    ObjectRef<Object> deletingTopics = ObjectRef.create(null);
                    BooleanRef assignmentSubmissionFailed = BooleanRef.create(false);
                    this.liftedTree1$1((java.util.List)allTopics, onlineTopics, deletingTopics, assignmentSubmissionFailed);
                    if (!assignmentSubmissionFailed.elem) {
                        this.getRunningAssignment().foreach((Function1<CompletableFuture, CompletableFuture> & Serializable)x$3 -> x$3.whenCompleteAsync((assignment, throwable) -> {
                            K2MetadataCachePopulator k2MetadataCachePopulator = this;
                            synchronized (k2MetadataCachePopulator) {
                                if (throwable != null) {
                                    this.logAndRetryWithBackoffUponFailure("Error generating assignments for " + ((java.util.List)onlineTopics$1.elem).size() + " online topics", (Throwable)throwable);
                                } else {
                                    this.liftedTree2$1((Map)assignment, deletingTopics, onlineTopics, downstreamComponents);
                                }
                            }
                        }, (Executor)this.executor()));
                    }
                }
            }
        }, (Executor)this.executor()));
    }

    private CompletableFuture<Map<Uuid, Map<TopicIdPartition, java.util.List<K2Node>>>> computeTopicAssignments(java.util.List<K2TopicMetadata> onlineTopics, Executor ex) {
        CompletableFuture<Map<Uuid, Map<TopicIdPartition, java.util.List<K2Node>>>> combinedPromise = new CompletableFuture<Map<Uuid, Map<TopicIdPartition, java.util.List<K2Node>>>>();
        java.util.List<Object> assignments = onlineTopics.stream().collect(Collectors.groupingBy(topic -> {
            if (this.isHealthcheckTopic$1((K2TopicMetadata)topic)) {
                return AssignmentContext.HEALTH_CHECK;
            }
            return AssignmentContext.DEFAULT;
        })).entrySet().stream().map(entry -> CxCompletableFutureUtil.toCompletableFuture($this.stack.partitionMapper((AssignmentContext)((Object)((Object)entry.getKey()))).assignments((Collection)entry.getValue()), ex)).collect(Collectors.toList());
        CompletableFuture.allOf((CompletableFuture[])assignments.toArray((Object[])new CompletableFuture[0])).whenCompleteAsync((x$6, t) -> {
            if (t != null) {
                combinedPromise.completeExceptionally((Throwable)t);
                return;
            }
            combinedPromise.complete(assignments.stream().flatMap(x$7 -> ((Map)x$7.get()).entrySet().stream()).collect(Collectors.toMap(x$8 -> (Uuid)x$8.getKey(), x$9 -> (Map)x$9.getValue())));
        }, ex);
        return combinedPromise;
    }

    private void setNothingRunning() {
        this.listTopicsFuture_$eq(None$.MODULE$);
        this.assignmentFuture_$eq(None$.MODULE$);
    }

    private void setAndLogListTopicsRunning(CompletableFuture<java.util.List<K2TopicMetadata>> future) {
        if (this.lastBackoffMs() > 0L) {
            this.info((Function0<String> & Serializable)() -> "Querying topic metadata store for all topics (backoff of at least " + this.lastBackoffMs() + " ms has elapsed since the last update failure)");
        } else {
            this.info((Function0<String> & Serializable)() -> "Querying topic metadata store for all topics (refreshPeriodMillis=" + $this.refreshPeriodMillis + " has elapsed since the last update successfully completed)");
        }
        this.listTopicsFuture_$eq(new Some<CompletableFuture<java.util.List<K2TopicMetadata>>>(future));
        this.assignmentFuture_$eq(None$.MODULE$);
    }

    private Option<CompletableFuture<java.util.List<K2TopicMetadata>>> getRunningListTopics() {
        return this.listTopicsFuture();
    }

    private void setAndLogAssignmentRunning(CompletableFuture<Map<Uuid, Map<TopicIdPartition, java.util.List<K2Node>>>> future, String message) {
        this.info((Function0<String> & Serializable)() -> message);
        this.assignmentFuture_$eq(new Some<CompletableFuture<Map<Uuid, Map<TopicIdPartition, java.util.List<K2Node>>>>>(future));
        this.listTopicsFuture_$eq(None$.MODULE$);
    }

    private Option<CompletableFuture<Map<Uuid, Map<TopicIdPartition, java.util.List<K2Node>>>>> getRunningAssignment() {
        return this.assignmentFuture();
    }

    private void setAndLogNextRunTimeUponSuccess() {
        this.info((Function0<String> & Serializable)() -> "K2 Metadata Cache update complete, next update in " + $this.refreshPeriodMillis + " ms");
        this.nextPopulateHiResClockMs_$eq(this.currentHiResClockMs() + this.refreshPeriodMillis);
        this.lastBackoffMs_$eq(0L);
        this.setNothingRunning();
    }

    private void logAndRetryWithBackoffUponFailure(String message, Throwable throwable) {
        long backoffMs = Math.max(this.refreshPeriodMillis, Math.min(this.MIN_BACKOFF_MS(), this.lastBackoffMs() * 2L));
        this.error((Function0<String> & Serializable)() -> message + "; backing off for " + backoffMs + " ms", (Function0<Throwable> & Serializable)() -> throwable);
        this.nextPopulateHiResClockMs_$eq(this.currentHiResClockMs() + backoffMs);
        this.lastBackoffMs_$eq(backoffMs);
        this.setNothingRunning();
    }

    private Tuple2<java.util.List<K2TopicMetadata>, java.util.List<K2TopicMetadata>> splitOnlineAndDeleting(java.util.List<K2TopicMetadata> allTopics) {
        ArrayList onlineTopics = new ArrayList();
        ArrayList deletingTopics = new ArrayList();
        ArrayList unknownStateTopics = new ArrayList();
        allTopics.forEach(topic -> {
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState = topic.k2TopicLifecycleState();
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState2 = K2TopicMetadata.K2TopicLifecycleState.DELETING;
            if (!(k2TopicLifecycleState != null ? !((Object)((Object)k2TopicLifecycleState)).equals((Object)k2TopicLifecycleState2) : k2TopicLifecycleState2 != null)) {
                deletingTopics.add(topic);
                return;
            }
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState3 = topic.k2TopicLifecycleState();
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState4 = K2TopicMetadata.K2TopicLifecycleState.ONLINE;
            if (!(k2TopicLifecycleState3 != null ? !((Object)((Object)k2TopicLifecycleState3)).equals((Object)k2TopicLifecycleState4) : k2TopicLifecycleState4 != null)) {
                onlineTopics.add(topic);
                return;
            }
            unknownStateTopics.add(topic);
        });
        this.info((Function0<String> & Serializable)() -> "Updating K2 metadata cache with all online topics from queried topics with size = " + onlineTopics.size());
        if (unknownStateTopics.size() > 0) {
            this.error((Function0<String> & Serializable)() -> "There are " + unknownStateTopics.size() + " topics in an unknown state!  This should not happen.  The topics are: " + unknownStateTopics);
        }
        if (onlineTopics.size() < 20) {
            this.info((Function0<String> & Serializable)() -> "Updating K2 metadata cache with online topics=" + onlineTopics + " and deletingTopics=" + deletingTopics);
        } else if (this.isTraceEnabled()) {
            this.trace((Function0<String> & Serializable)() -> "Updating K2 metadata cache with online topics=" + onlineTopics + " and deletingTopics=" + deletingTopics);
        } else {
            this.info((Function0<String> & Serializable)() -> "Updating K2 metadata cache with " + onlineTopics.size() + " online topics and deletingTopics=" + deletingTopics);
        }
        return new Tuple2<java.util.List<K2TopicMetadata>, java.util.List<K2TopicMetadata>>(onlineTopics, deletingTopics);
    }

    private void maybeSendFullUpdateToPartitionsPerTopicListener(java.util.List<K2TopicMetadata> onlineTopics) {
        this.confluentPartitionsPerTopicListener.foreach((Function1<ConfluentPartitionsPerTopicListener, Object> & Serializable)listener -> {
            K2MetadataCachePopulator.$anonfun$maybeSendFullUpdateToPartitionsPerTopicListener$1(this, onlineTopics, listener);
            return BoxedUnit.UNIT;
        });
    }

    private final /* synthetic */ void liftedTree1$1(java.util.List allTopics$1, ObjectRef onlineTopics$1, ObjectRef deletingTopics$1, BooleanRef assignmentSubmissionFailed$1) {
        try {
            Tuple2<java.util.List<K2TopicMetadata>, java.util.List<K2TopicMetadata>> tuple = this.splitOnlineAndDeleting(allTopics$1);
            onlineTopics$1.elem = tuple._1();
            deletingTopics$1.elem = tuple._2();
            this.setAndLogAssignmentRunning(this.computeTopicAssignments((java.util.List)onlineTopics$1.elem, this.executor()), "Generating assignments for " + ((java.util.List)onlineTopics$1.elem).size() + " online topics");
        }
        catch (Throwable t) {
            this.logAndRetryWithBackoffUponFailure("Error submitting request to generate assignments for " + ((java.util.List)onlineTopics$1.elem).size() + " online topics", t);
            assignmentSubmissionFailed$1.elem = true;
        }
    }

    private final /* synthetic */ void liftedTree2$1(Map assignment$1, ObjectRef deletingTopics$1, ObjectRef onlineTopics$1, List downstreamComponents$2) {
        try {
            if (this.isDebugEnabled()) {
                this.debug((Function0<String> & Serializable)() -> "Generated partition mappings: " + assignment$1);
            }
            ObjectRef immutableDeletingTopics = ObjectRef.create(ImmutableSet.empty());
            ((java.util.List)deletingTopics$1.elem).forEach(topic -> {
                immutableDeletingTopics$1.elem = ((ImmutableSet)immutableDeletingTopics$1.elem).added(topic);
            });
            this.k2MetadataCache.setTopicsAndAssignments((java.util.List)onlineTopics$1.elem, assignment$1, (ImmutableSet)immutableDeletingTopics.elem);
            this.info((Function0<String> & Serializable)() -> "Updated K2 metadata cache with " + $this.k2MetadataCache.topicIdsToNames().size() + " online topics plus assignments; notifying downstream components: " + ((AbstractIterable)downstreamComponents$2.map((Function1<K2MetadataPublisher, String> & Serializable)x -> x.getClass().getSimpleName())).mkString("[", ", ", "]"));
            downstreamComponents$2.foreach((Function1<K2MetadataPublisher, Object> & Serializable)x$4 -> {
                x$4.onK2MetadataUpdate(this.k2MetadataCache.k2TopicsImageAndVersion());
                return BoxedUnit.UNIT;
            });
            this.maybeSendFullUpdateToPartitionsPerTopicListener((java.util.List)onlineTopics$1.elem);
            this.initialMetadataCachePopulationFuture().complete(null);
            this.setAndLogNextRunTimeUponSuccess();
        }
        catch (Throwable throwable) {
            this.logAndRetryWithBackoffUponFailure("Error updating topic assignments", throwable);
        }
    }

    private final boolean isHealthcheckTopic$1(K2TopicMetadata topic) {
        return BoxesRunTime.unboxToBoolean(this.multiTenantMetadata.flatMap((Function1<MultiTenantMetadata, Option> & Serializable)mt -> Option$.MODULE$.when(mt.isUp(), (Function0<Option> & Serializable)() -> Option$.MODULE$.apply(TenantHelpers.NAME_TO_TENANT_CALLBACK_NO_DELIMITER.apply(topic.topicName())).flatMap((Function1<String, Option> & Serializable)logicalClusterId -> Option$.MODULE$.apply(mt.metadata((String)logicalClusterId))).map((Function1<LogicalClusterMetadata, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.isHealthcheckLogicalCluster()))).flatten($less$colon$less$.MODULE$.refl())).getOrElse(() -> false));
    }

    public static final /* synthetic */ void $anonfun$maybeSendFullUpdateToPartitionsPerTopicListener$1(K2MetadataCachePopulator $this, java.util.List onlineTopics$3, ConfluentPartitionsPerTopicListener listener) {
        Stream<AbstractMap.SimpleEntry> stream = onlineTopics$3.stream().map(tm -> new AbstractMap.SimpleEntry<String, Integer>(tm.topicName(), Predef$.MODULE$.int2Integer(tm.numPartitions())));
        Iterator<Map.Entry<String, Integer>> topicNamesAndNumberOfPartitionsIterator = stream.iterator();
        listener.fullUpdate(topicNamesAndNumberOfPartitionsIterator, Collections.emptyMap(), Collections.emptySet());
        $this.info((Function0<String> & Serializable)() -> "Sent full update to PartitionsPerTopicListener for " + $this.k2MetadataCache.topicIdsToNames().size() + " online topics");
    }

    public K2MetadataCachePopulator(KafkaScheduler kafkaScheduler, K2Stack stack, K2MetadataCache k2MetadataCache, long refreshPeriodMillis, Time time, Option<ConfluentPartitionsPerTopicListener> confluentPartitionsPerTopicListener, Option<MultiTenantMetadata> multiTenantMetadata) {
        this.kafkaScheduler = kafkaScheduler;
        this.stack = stack;
        this.k2MetadataCache = k2MetadataCache;
        this.refreshPeriodMillis = refreshPeriodMillis;
        this.time = time;
        this.confluentPartitionsPerTopicListener = confluentPartitionsPerTopicListener;
        this.multiTenantMetadata = multiTenantMetadata;
        Logging.$init$(this);
        this.logIdent_$eq("[" + this.getClass().getSimpleName() + " brokerId=" + k2MetadataCache.brokerId() + "] ");
        this.CHECK_EVERY_MILLIS = 100L;
        this.MIN_BACKOFF_MS = 32L;
        this.k2MetadataCacheUpdaterFuture = None$.MODULE$;
        this.initialMetadataCachePopulationFuture = new CompletableFuture();
        this.nextPopulateHiResClockMs = Long.MIN_VALUE;
        this.lastBackoffMs = 0L;
        this.listTopicsFuture = None$.MODULE$;
        this.assignmentFuture = None$.MODULE$;
        this.lastLogHiResClockMs = Long.MIN_VALUE;
        this.executor = Executors.newSingleThreadExecutor();
    }
}

