/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import kafka.cluster.Partition;
import kafka.server.AbstractFetcherThread;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierOffsetInfo;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.network.BrokerEndPoint;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\t\u0005b\u0001B\u0010!\u0001\u0015B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u001d1\u0006A1A\u0005\n]Caa\u0017\u0001!\u0002\u0013A\u0006b\u0002/\u0001\u0005\u0004%I!\u0018\u0005\u0007M\u0002\u0001\u000b\u0011\u00020\t\u000f\u001d\u0004!\u0019!C\u0005;\"1\u0001\u000e\u0001Q\u0001\nyCq!\u001b\u0001A\u0002\u0013%!\u000eC\u0004u\u0001\u0001\u0007I\u0011B;\t\rm\u0004\u0001\u0015)\u0003l\u0011\u0015a\b\u0001\"\u0011~\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bAq!a\u0002\u0001\t\u0003\n)\u0001C\u0004\u0002\n\u0001!\t%a\u0003\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010!9\u0011Q\b\u0001\u0005B\u0005}\u0002bBA*\u0001\u0011\u0005\u0013Q\u000b\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\tY\u0007\u0001C!\u0003[Bq!a\u001d\u0001\t\u0003\n)\bC\u0004\u00022\u0002!\t%a-\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\"9\u0011Q\u001d\u0001\u0005\n\u0005\u001d\bb\u0002B\u0001\u0001\u0011%!1\u0001\u0005\b\u0005\u000f\u0001A\u0011\tB\u0005\u0011\u001d\u0011i\u0001\u0001C!\u0005\u001f\u00111\u0003T8dC2dU-\u00193fe\u0016sG\rU8j]RT!!\t\u0012\u0002\rM,'O^3s\u0015\u0005\u0019\u0013!B6bM.\f7\u0001A\n\u0005\u0001\u0019b\u0003\u0007\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VM\u001a\t\u0003[9j\u0011\u0001I\u0005\u0003_\u0001\u0012a\u0002T3bI\u0016\u0014XI\u001c3Q_&tG\u000f\u0005\u00022i5\t!G\u0003\u00024E\u0005)Q\u000f^5mg&\u0011QG\r\u0002\b\u0019><w-\u001b8h\u00031\u0019x.\u001e:dK\n\u0013xn[3s!\tA\u0014)D\u0001:\u0015\tQ4(A\u0004oKR<xN]6\u000b\u0005\u0005b$BA\u0012>\u0015\tqt(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0001\u0006\u0019qN]4\n\u0005\tK$A\u0004\"s_.,'/\u00128e!>Lg\u000e^\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003[\u0015K!A\u0012\u0011\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\ti\u0013*\u0003\u0002KA\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018!B9v_R\f\u0007CA\u0017N\u0013\tq\u0005E\u0001\u0007SKBd\u0017nY1Rk>$\u0018-\u0001\u0004=S:LGO\u0010\u000b\u0006#J\u001bF+\u0016\t\u0003[\u0001AQAN\u0003A\u0002]BQaQ\u0003A\u0002\u0011CQaR\u0003A\u0002!CQaS\u0003A\u00021\u000b\u0011B]3qY&\u001c\u0017-\u00133\u0016\u0003a\u0003\"aJ-\n\u0005iC#aA%oi\u0006Q!/\u001a9mS\u000e\f\u0017\n\u001a\u0011\u0002\u00115\f\u0007PQ=uKN,\u0012A\u0018\t\u0003?\u0012l\u0011\u0001\u0019\u0006\u0003C\n\fA\u0001\\1oO*\t1-\u0001\u0003kCZ\f\u0017BA3a\u0005\u001dIe\u000e^3hKJ\f\u0011\"\\1y\u0005f$Xm\u001d\u0011\u0002\u0013\u0019,Go\u00195TSj,\u0017A\u00034fi\u000eD7+\u001b>fA\u0005\u0019\u0012N\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]V\t1\u000eE\u0002(Y:L!!\u001c\u0015\u0003\r=\u0003H/[8o!\ty'/D\u0001q\u0015\t\tH(\u0001\u0004d_6lwN\\\u0005\u0003gB\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\fj]B\u0013xn\u001a:fgN\u0004\u0016M\u001d;ji&|gn\u0018\u0013fcR\u0011a/\u001f\t\u0003O]L!\u0001\u001f\u0015\u0003\tUs\u0017\u000e\u001e\u0005\bu6\t\t\u00111\u0001l\u0003\rAH%M\u0001\u0015S:\u0004&o\\4sKN\u001c\b+\u0019:uSRLwN\u001c\u0011\u00029%\u001cHK];oG\u0006$\u0018n\u001c8P]\u001a+Go\u00195TkB\u0004xN\u001d;fIV\ta\u0010\u0005\u0002(\u007f&\u0019\u0011\u0011\u0001\u0015\u0003\u000f\t{w\u000e\\3b]\u0006i\u0011N\\5uS\u0006$Xm\u00117pg\u0016$\u0012A^\u0001\u0006G2|7/Z\u0001\u000fEJ|7.\u001a:F]\u0012\u0004v.\u001b8u)\u00059\u0014!\u00024fi\u000eDG\u0003BA\t\u0003K\u0001r!a\u0005\u0002\u001a9\fi\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003\u0015\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001c\u0005U!aA'baB!\u0011qDA\u0011\u001b\u0005\u0001\u0011bAA\u0012]\tIa)\u001a;dQ\u0012\u000bG/\u0019\u0005\b\u0003O\u0019\u0002\u0019AA\u0015\u000311W\r^2i%\u0016\fX/Z:u!\u0011\tY#a\u000e\u000f\t\u00055\u00121G\u0007\u0003\u0003_Q1!!\rq\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\u001b\u0003_\tABR3uG\"\u0014V-];fgRLA!!\u000f\u0002<\t9!)^5mI\u0016\u0014(\u0002BA\u001b\u0003_\t1CZ3uG\",\u0015M\u001d7jKN$xJ\u001a4tKR$b!!\u0011\u0002L\u0005=\u0003\u0003BA\"\u0003\u000fj!!!\u0012\u000b\u0005E\\\u0014\u0002BA%\u0003\u000b\u0012ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007\u000e\u0003\u0004\u0002NQ\u0001\rA\\\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\t\t\u0006\u0006a\u00011\u0006\u00112-\u001e:sK:$H*Z1eKJ,\u0005o\\2i\u0003y1W\r^2i)&,'/T1uKJL\u0017\r\\5{CRLwN\u001c+be\u001e,G\u000f\u0006\u0004\u0002X\u0005u\u0013q\f\t\u0004[\u0005e\u0013bAA.A\tqA+[3s\u001f\u001a47/\u001a;J]\u001a|\u0007BBA'+\u0001\u0007a\u000e\u0003\u0004\u0002bU\u0001\r\u0001W\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007.A\tgKR\u001c\u0007\u000eT1uKN$xJ\u001a4tKR$b!!\u0011\u0002h\u0005%\u0004BBA'-\u0001\u0007a\u000e\u0003\u0004\u0002RY\u0001\r\u0001W\u0001\u0019M\u0016$8\r[#be2LWm\u001d;M_\u000e\fGn\u00144gg\u0016$HCBA!\u0003_\n\t\b\u0003\u0004\u0002N]\u0001\rA\u001c\u0005\u0007\u0003#:\u0002\u0019\u0001-\u0002)\u0019,Go\u00195Fa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;t)\u0011\t9(!*\u0011\u000f\u0005M\u0011\u0011\u00048\u0002zA!\u00111PAP\u001d\u0011\ti(!'\u000f\t\u0005}\u0014Q\u0013\b\u0005\u0003\u0003\u000b\u0019J\u0004\u0003\u0002\u0004\u0006Ee\u0002BAC\u0003\u001fsA!a\"\u0002\u000e6\u0011\u0011\u0011\u0012\u0006\u0004\u0003\u0017#\u0013A\u0002\u001fs_>$h(C\u0001A\u0013\tqt(\u0003\u0002${%\u0011\u0011\u000fP\u0005\u0004\u0003/\u0003\u0018aB7fgN\fw-Z\u0005\u0005\u00037\u000bi*\u0001\u0011PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fgB|gn]3ECR\f'bAALa&!\u0011\u0011UAR\u00059)\u0005o\\2i\u000b:$wJ\u001a4tKRTA!a'\u0002\u001e\"9\u0011q\u0015\rA\u0002\u0005%\u0016A\u00039beRLG/[8ogB9\u00111CA\r]\u0006-\u0006\u0003BA\u0010\u0003[K1!a,/\u0005%)\u0005o\\2i\t\u0006$\u0018-\u0001\u0006ck&dGMR3uG\"$B!!.\u0002LB1\u0011qWA_\u0003\u0007t1!LA]\u0013\r\tY\fI\u0001\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0013\u0011\ty,!1\u0003)I+7/\u001e7u/&$\b\u000eU1si&$\u0018n\u001c8t\u0015\r\tY\f\t\t\u0005O1\f)\r\u0005\u0003\u00028\u0006\u001d\u0017\u0002BAe\u0003\u0003\u0014ABU3qY&\u001c\u0017MR3uG\"Dq!a*\u001a\u0001\u0004\ti\rE\u0004\u0002\u0014\u0005ea.a4\u0011\u00075\n\t.C\u0002\u0002T\u0002\u00121\u0003U1si&$\u0018n\u001c8GKR\u001c\u0007n\u0015;bi\u0016\fac]3mK\u000e$\b+\u0019:uSRLwN\u001c+p\r\u0016$8\r\u001b\u000b\u0005\u00033\f\t\u000f\u0005\u0003(Y\u0006m\u0007CB\u0014\u0002^:\fy-C\u0002\u0002`\"\u0012a\u0001V;qY\u0016\u0014\u0004bBAr5\u0001\u0007\u0011QZ\u0001\ra\u0006\u0014H/\u001b;j_:l\u0015\r]\u0001\u0017EVLG\u000e\u001a$fi\u000eDgi\u001c:QCJ$\u0018\u000e^5p]R1\u0011\u0011^A}\u0003{\u0004b!a;\u0002>\u0006Uh\u0002BAw\u0003ssA!a<\u0002t:!\u0011qQAy\u0013\u0005\u0019\u0013BA\u0011#!\u00119C.a>\u0011\t\u0005-\u0018q\u0019\u0005\u0007\u0003w\\\u0002\u0019\u00018\u0002\u0005Q\u0004\bbBA\u00007\u0001\u0007\u0011qZ\u0001\u000bM\u0016$8\r[*uCR,\u0017A\u00058fqR\u0014V-\u00193z!\u0006\u0014H/\u001b;j_:$B!!7\u0003\u0006!9\u00111\u001d\u000fA\u0002\u00055\u0017aD5t%\u0016\fG-\u001f$pe\u001a+Go\u00195\u0015\u0007y\u0014Y\u0001\u0003\u0004\u0002|v\u0001\rA\\\u0001\ti>\u001cFO]5oOR\u0011!\u0011\u0003\t\u0005\u0005'\u0011YB\u0004\u0003\u0003\u0016\t]\u0001cAADQ%\u0019!\u0011\u0004\u0015\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011iBa\b\u0003\rM#(/\u001b8h\u0015\r\u0011I\u0002\u000b")
public class LocalLeaderEndPoint
implements LeaderEndPoint,
Logging {
    private final BrokerEndPoint sourceBroker;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Option<TopicPartition> inProgressPartition;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LocalLeaderEndPoint localLeaderEndPoint = this;
        synchronized (localLeaderEndPoint) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private Option<TopicPartition> inProgressPartition() {
        return this.inProgressPartition;
    }

    private void inProgressPartition_$eq(Option<TopicPartition> x$1) {
        this.inProgressPartition = x$1;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return false;
    }

    @Override
    public void initiateClose() {
    }

    @Override
    public void close() {
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.sourceBroker;
    }

    @Override
    public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
        ObjectRef<Object> partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        HashMap topicNames = new HashMap();
        request.data().topics().forEach(topic -> topicNames.put(topic.topicId(), topic.topic()));
        ArrayBuffer partitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        request.data().topics().forEach(topic -> {
            String name = request.version() < 13 ? topic.topic() : (String)topicNames.apply(topic.topicId());
            topic.partitions().forEach(partition -> partitions.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new TopicIdPartition(topic.topicId(), partition.partition(), name)), new FullPartitionFetchMetadata(topic.topicId(), partition.fetchOffset(), partition.logStartOffset(), partition.partitionMaxBytes(), RequestUtils.getLeaderEpoch(partition.currentLeaderEpoch()), RequestUtils.getLeaderEpoch(partition.lastFetchedEpoch()), -1L))));
        });
        FetchParams fetchParams = new FetchParams(request.version(), -3, -1L, 0L, request.minBytes(), request.maxBytes(), FetchIsolation.LOG_END, Optional.empty());
        this.replicaManager.fetchMessages(fetchParams, partitions, QuotaFactory.UNBOUNDED_QUOTA, (Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>)(Function1<Seq, Object> & Serializable)responsePartitionData -> {
            LocalLeaderEndPoint.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        }, false);
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException("Failed to fetch data for partitions " + ((IterableOnceOps)partitions.map((Function1<Tuple2, TopicIdPartition> & Serializable)x$1 -> (TopicIdPartition)x$1._1())).mkString(","));
        }
        return ((Seq)partitionData.elem).toMap($less$colon$less$.MODULE$.refl());
    }

    @Override
    public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        Partition partition = this.replicaManager.getPartitionOrException(topicPartition);
        long logStartOffset = partition.localLogOrException().logStartOffset();
        OptionalInt epoch = partition.localLogOrException().leaderEpochCache().epochForOffset(logStartOffset);
        return new OffsetAndEpoch(logStartOffset, epoch.orElseGet(() -> 0));
    }

    @Override
    public TierOffsetInfo fetchTierMaterializationTarget(TopicPartition topicPartition, int leaderEpoch) {
        throw new UnsupportedOperationException("Local leader endpoint does not support tiered partitions");
    }

    @Override
    public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        Partition partition = this.replicaManager.getPartitionOrException(topicPartition);
        long logEndOffset = partition.localLogOrException().logEndOffset();
        OptionalInt epoch = partition.localLogOrException().leaderEpochCache().epochForOffset(logEndOffset);
        return new OffsetAndEpoch(logEndOffset, epoch.orElseGet(() -> 0));
    }

    @Override
    public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        throw new UnsupportedOperationException("Fetching earliest local offset is not supported in Local Leader Endpoint.");
    }

    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        return (Map)partitions.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> tuple22;
                TopicPartition tp = (TopicPartition)tuple2._1();
                OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData = (OffsetForLeaderEpochRequestData.OffsetForLeaderPartition)tuple2._2();
                try {
                    OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset;
                    if (epochData.leaderEpoch() == -1) {
                        epochEndOffset = new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.NONE.code());
                    } else {
                        Partition partition = $this.replicaManager.getPartitionOrException(tp);
                        epochEndOffset = partition.lastOffsetForLeaderEpoch(RequestUtils.getLeaderEpoch(epochData.currentLeaderEpoch()), epochData.leaderEpoch(), false);
                    }
                    OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = epochEndOffset;
                    tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), endOffset);
                }
                catch (Throwable t) {
                    this.warn((Function0<String> & Serializable)() -> "Error when getting EpochEndOffset for " + tp, (Function0<Throwable> & Serializable)() -> t);
                    tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.forException(t).code()));
                }
                return tuple22;
            }
            throw new MatchError(tuple2);
        });
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitions) {
        Some some;
        Tuple2 tuple2;
        if (this.quota.isQuotaExceeded()) {
            return new AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>>(None$.MODULE$, (Map)scala.collection.Map$.MODULE$.empty());
        }
        Option<Tuple2<TopicPartition, PartitionFetchState>> option = this.selectPartitionToFetch(partitions);
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
            return this.buildFetchForPartition(tp, fetchState);
        }
        if (None$.MODULE$.equals(option)) {
            return new AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>>(None$.MODULE$, (Map)scala.collection.Map$.MODULE$.empty());
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    private Option<Tuple2<TopicPartition, PartitionFetchState>> selectPartitionToFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        Option option;
        Object object = new Object();
        try {
            void var3_3;
            this.inProgressPartition().foreach((Function1<TopicPartition, Object> & Serializable)tp -> {
                LocalLeaderEndPoint.$anonfun$selectPartitionToFetch$1(partitionMap, object, tp);
                return BoxedUnit.UNIT;
            });
            this.inProgressPartition_$eq(None$.MODULE$);
            Option<Tuple2<TopicPartition, PartitionFetchState>> nextPartitionOpt = this.nextReadyPartition(partitionMap);
            nextPartitionOpt.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
                LocalLeaderEndPoint.$anonfun$selectPartitionToFetch$4(this, partitionMap, x0$1);
                return BoxedUnit.UNIT;
            });
            option = var3_3;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetchForPartition(TopicPartition tp, PartitionFetchState fetchState) {
        Option option;
        Object object;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Map partitionsWithError = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        try {
            long logStartOffset = this.replicaManager.futureLocalLogOrException(tp).logStartOffset();
            Optional<Integer> lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(fetchState.lastFetchedEpoch().map((Function1<Object, Integer> & Serializable)x$3 -> LocalLeaderEndPoint.$anonfun$buildFetchForPartition$1(BoxesRunTime.unboxToInt(x$3))))) : Optional.empty();
            Uuid topicId = (Uuid)fetchState.topicId().getOrElse((Function0<Uuid> & Serializable)() -> Uuid.ZERO_UUID);
            object = requestMap.put(tp, new FetchRequest.PartitionData(topicId, fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), OptionConverters.RichOption$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOption(fetchState.replicationSessionId().map((Function1<Object, Long> & Serializable)x$4 -> LocalLeaderEndPoint.$anonfun$buildFetchForPartition$3(BoxesRunTime.unboxToLong(x$4))))), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
        }
        catch (KafkaStorageException e) {
            this.debug((Function0<String> & Serializable)() -> "Failed to build fetch for " + tp, (Function0<Throwable>)(Function0<KafkaStorageException> & Serializable)() -> e);
            object = partitionsWithError.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), Errors.KAFKA_STORAGE_ERROR));
        }
        if (requestMap.isEmpty()) {
            option = None$.MODULE$;
        } else {
            short version = fetchState.topicId().isEmpty() ? (short)12 : (short)ApiKeys.FETCH.latestVersion();
            FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica(version, this.replicaId(), -1L, 0, 0, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
            option = new Some<AbstractFetcherThread.ReplicaFetch>(new AbstractFetcherThread.ReplicaFetch(requestMap, requestBuilder));
        }
        None$ fetchRequestOpt = option;
        return new AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>>(fetchRequestOpt, partitionsWithError);
    }

    private Option<Tuple2<TopicPartition, PartitionFetchState>> nextReadyPartition(Map<TopicPartition, PartitionFetchState> partitionMap) {
        return ((IterableOnceOps)partitionMap.filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(LocalLeaderEndPoint.$anonfun$nextReadyPartition$1(x0$1)))).reduceLeftOption((Function2<Tuple2, Tuple2, Tuple2> & Serializable)(left, right) -> {
            block3: {
                block2: {
                    if (StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic()), ((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() >= ((TopicPartition)right._1()).partition()) break block3;
                }
                return left;
            }
            return right;
        });
    }

    @Override
    public boolean isReadyForFetch(TopicPartition tp) {
        return true;
    }

    public String toString() {
        return "LocalLeaderEndPoint";
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicIdPartition tp = (TopicIdPartition)tuple2._1();
                FetchPartitionData data = (FetchPartitionData)tuple2._2();
                List abortedTransactions = data.abortedTransactions.orElse(null);
                long lastStableOffset = data.lastStableOffset.orElse(-1L);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp.topicPartition()), new FetchResponseData.PartitionData().setPartitionIndex(tp.topicPartition().partition()).setErrorCode(data.error.code()).setHighWatermark(data.highWatermark).setLastStableOffset(lastStableOffset).setLogStartOffset(data.logStartOffset).setAbortedTransactions(abortedTransactions).setRecords(data.records));
            }
            throw new MatchError(tuple2);
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$1(Map partitionMap$1, Object nonLocalReturnKey1$1, TopicPartition tp) {
        Option fetchStateOpt = partitionMap$1.get(tp);
        fetchStateOpt.filter((Function1<PartitionFetchState, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.isReadyForFetch())).foreach((Function1<PartitionFetchState, Nothing$> & Serializable)fetchState -> {
            throw new NonLocalReturnControl<Some<Tuple2<TopicPartition, PartitionFetchState>>>(nonLocalReturnKey1$1, new Some<Tuple2<TopicPartition, PartitionFetchState>>(new Tuple2<TopicPartition, PartitionFetchState>(tp, (PartitionFetchState)fetchState)));
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$4(LocalLeaderEndPoint $this, Map partitionMap$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
            $this.inProgressPartition_$eq(new Some<TopicPartition>(tp));
            $this.info((Function0<String> & Serializable)() -> "Beginning/resuming copy of partition " + tp + " from offset " + fetchState.fetchOffset() + ". Including this partition, there are " + partitionMap$1.size() + " remaining partitions to copy by this thread.");
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ Integer $anonfun$buildFetchForPartition$1(int x$3) {
        return BoxesRunTime.boxToInteger(x$3);
    }

    public static final /* synthetic */ Long $anonfun$buildFetchForPartition$3(long x$4) {
        return BoxesRunTime.boxToLong(x$4);
    }

    public static final /* synthetic */ boolean $anonfun$nextReadyPartition$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
            return partitionFetchState.isReadyForFetch();
        }
        throw new MatchError(tuple2);
    }

    public LocalLeaderEndPoint(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaManager, ReplicaQuota quota) {
        this.sourceBroker = sourceBroker;
        this.replicaManager = replicaManager;
        this.quota = quota;
        Logging.$init$(this);
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.inProgressPartition = None$.MODULE$;
    }
}

