/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkAggregator$;
import kafka.server.link.ClusterLinkAggregator$ClusterLinkAggregator$;
import kafka.server.link.ClusterLinkAggregator$PartitionMirrorState$;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.PeriodicAggregation;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.requests.ReportClusterLinkStatusRequest;
import org.apache.kafka.common.requests.ReportClusterLinkStatusResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.MirrorTopic;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rMd\u0001B\"E\u0001-C\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tG\u0002\u0011\t\u0011)A\u0005I\"Aq\r\u0001B\u0001B\u0003%\u0001\u000e\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003p\u0011!Y\bA!A!\u0002\u0013a\bBCA\u0001\u0001\t\u0005\t\u0015!\u0003\u0002\u0004!Q\u0011\u0011\u0002\u0001\u0003\u0002\u0003\u0006I!a\u0003\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!I\u0011Q\u0005\u0001C\u0002\u0013%\u0011q\u0005\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002\f!I\u00111\u0006\u0001C\u0002\u0013%\u0011Q\u0006\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u00020!I\u0011q\t\u0001C\u0002\u0013%\u0011\u0011\n\u0005\t\u0005_\u0001\u0001\u0015!\u0003\u0002L!I!\u0011\u0007\u0001C\u0002\u0013%!1\u0007\u0005\t\u0005\u001f\u0002\u0001\u0015!\u0003\u00036!I!\u0011\u000b\u0001C\u0002\u0013%!1\u000b\u0005\t\u00057\u0002\u0001\u0015!\u0003\u0003V!I!Q\f\u0001C\u0002\u0013%!q\f\u0005\t\u0005[\u0002\u0001\u0015!\u0003\u0003b!9!q\u000e\u0001\u0005B\tE\u0004b\u0002BO\u0001\u0011\u0005#q\u0014\u0005\b\u0005O\u0003A\u0011\tBU\u0011\u001d\u0011\t\f\u0001C\u0005\u0005SCqAa-\u0001\t\u0003\u0012I\u000bC\u0004\u00036\u0002!\tA!+\t\u000f\t]\u0006\u0001\"\u0003\u0003:\"9!Q\u0019\u0001\u0005\n\t\u001d\u0007b\u0002Bo\u0001\u0011%!q\u001c\u0005\b\u0005w\u0004A\u0011\u0002B\u007f\u0011\u001d\u0019\t\u0001\u0001C\u0005\u0007\u0007Aqa!\u0003\u0001\t\u0003\u0011\u0019C\u0002\u0004\u0002Z\u0001\u0001\u00151\f\u0005\u000b\u0003w\n#Q3A\u0005\u0002\u0005u\u0004BCAWC\tE\t\u0015!\u0003\u0002\u0000!Q\u0011qV\u0011\u0003\u0016\u0004%\t!a\n\t\u0015\u0005E\u0016E!E!\u0002\u0013\tY\u0001C\u0004\u0002\u0012\u0005\"\t!a-\t\u0013\u0005e\u0016%!A\u0005\u0002\u0005m\u0006\"CAaCE\u0005I\u0011AAb\u0011%\tI.II\u0001\n\u0003\tY\u000eC\u0005\u0002`\u0006\n\t\u0011\"\u0011\u0002b\"I\u00111_\u0011\u0002\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003k\f\u0013\u0011!C\u0001\u0003oD\u0011Ba\u0001\"\u0003\u0003%\tE!\u0002\t\u0013\t=\u0011%!A\u0005\u0002\tE\u0001\"\u0003B\u000eC\u0005\u0005I\u0011\tB\u000f\u0011%\u0011\t#IA\u0001\n\u0003\u0012\u0019\u0003C\u0005\u0003&\u0005\n\t\u0011\"\u0011\u0003(!I!\u0011F\u0011\u0002\u0002\u0013\u0005#1F\u0004\n\u0007\u0017\u0001\u0011\u0011!E\u0001\u0007\u001b1\u0011\"!\u0017\u0001\u0003\u0003E\taa\u0004\t\u000f\u0005EA\u0007\"\u0001\u0004(!I!Q\u0005\u001b\u0002\u0002\u0013\u0015#q\u0005\u0005\n\u0007S!\u0014\u0011!CA\u0007WA\u0011b!\r5\u0003\u0003%\tia\r\b\u000f\r\u0015\u0003\u0001#\u0001\u0004H\u001911\t\u0001E\u0001\u0007\u0013Bq!!\u0005;\t\u0003\u0019Y\u0005C\u0005\u0004Ni\u0012\r\u0011\"\u0003\u0004P!A11\r\u001e!\u0002\u0013\u0019\t\u0006C\u0004\u0004fi\"\taa\u001a\b\u0013\r\u0015C)!A\t\u0002\r-d\u0001C\"E\u0003\u0003E\ta!\u001c\t\u000f\u0005E\u0001\t\"\u0001\u0004p!I1\u0011\u000f!\u0012\u0002\u0013\u0005\u00111\u001c\u0002\u0016\u00072,8\u000f^3s\u0019&t7.Q4he\u0016<\u0017\r^8s\u0015\t)e)\u0001\u0003mS:\\'BA$I\u0003\u0019\u0019XM\u001d<fe*\t\u0011*A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001a%+\u0017\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M;fB\u0001+V\u001b\u0005!\u0015B\u0001,E\u0003I\u0019E.^:uKJd\u0015N\\6GC\u000e$xN]=\n\u0005\rC&B\u0001,E!\tQV,D\u0001\\\u0015\ta\u0006*A\u0003vi&d7/\u0003\u0002_7\n9Aj\\4hS:<\u0017aD2mkN$XM\u001d'j].$\u0015\r^1\u0011\u0005Q\u000b\u0017B\u00012E\u0005=\u0019E.^:uKJd\u0015N\\6ECR\f\u0017!C:dQ\u0016$W\u000f\\3s!\t!V-\u0003\u0002g\t\n!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJ\fQ\"\\3uC\u0012\fG/Y\"bG\",\u0007CA5m\u001b\u0005Q'BA6G\u0003!iW\r^1eCR\f\u0017BA7k\u0005IY%+\u00194u\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\tQLW.\u001a\t\u0003afl\u0011!\u001d\u0006\u00039JT!a\u001d;\u0002\r\r|W.\\8o\u0015\tIUO\u0003\u0002wo\u00061\u0011\r]1dQ\u0016T\u0011\u0001_\u0001\u0004_J<\u0017B\u0001>r\u0005\u0011!\u0016.\\3\u0002\u000bE,x\u000e^1\u0011\u0005utX\"\u0001$\n\u0005}4%aF\"mkN$XM\u001d'j].\u0014V-];fgR\fVo\u001c;b\u0003\u001diW\r\u001e:jGN\u00042\u0001VA\u0003\u0013\r\t9\u0001\u0012\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/A\u000bti\u0006$X-\u0012=qSJLH)\u001e:bi&|g.T:\u0011\u00075\u000bi!C\u0002\u0002\u00109\u00131!\u00138u\u0003\u0019a\u0014N\\5u}Q\u0001\u0012QCA\f\u00033\tY\"!\b\u0002 \u0005\u0005\u00121\u0005\t\u0003)\u0002AQa\u0018\u0005A\u0002\u0001DQa\u0019\u0005A\u0002\u0011DQa\u001a\u0005A\u0002!DQA\u001c\u0005A\u0002=DQa\u001f\u0005A\u0002qDq!!\u0001\t\u0001\u0004\t\u0019\u0001C\u0005\u0002\n!\u0001\n\u00111\u0001\u0002\f\u0005ARO\\6o_^t\u0007+\u001e2mSNDWM\u001d\"s_.,'/\u00133\u0016\u0005\u0005-\u0011!G;oW:|wO\u001c)vE2L7\u000f[3s\u0005J|7.\u001a:JI\u0002\nAC\u0019:pW\u0016\u0014H*Y:u%\u0016\u0004xN\u001d;US6,WCAA\u0018!!\t\t$a\u000f\u0002\f\u0005}RBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002:9\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti$a\r\u0003\u000fQ\u0013\u0018.Z'baB\u0019Q*!\u0011\n\u0007\u0005\rcJ\u0001\u0003M_:<\u0017!\u00062s_.,'\u000fT1tiJ+\u0007o\u001c:u)&lW\rI\u0001\u000f[&\u0014(o\u001c:Ti\u0006$X-T1q+\t\tY\u0005\u0005\u0005\u00022\u0005m\u0012QJA+!\u0011\ty%!\u0015\u000e\u0003IL1!a\u0015s\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u00042!a\u0016\"\u001b\u0005\u0001!\u0001\u0006)beRLG/[8o\u001b&\u0014(o\u001c:Ti\u0006$Xm\u0005\u0004\"\u0019\u0006u\u00131\r\t\u0004\u001b\u0006}\u0013bAA1\u001d\n9\u0001K]8ek\u000e$\b\u0003BA3\u0003krA!a\u001a\u0002r9!\u0011\u0011NA8\u001b\t\tYGC\u0002\u0002n)\u000ba\u0001\u0010:p_Rt\u0014\"A(\n\u0007\u0005Md*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0014\u0011\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0003gr\u0015!B:uCR,WCAA@!\u0011\t\t)a*\u000f\t\u0005\r\u0015\u0011\u0015\b\u0005\u0003\u000b\u000bYJ\u0004\u0003\u0002\b\u0006]e\u0002BAE\u0003+sA!a#\u0002\u0014:!\u0011QRAI\u001d\u0011\tI'a$\n\u0003aL!A^<\n\u0005%+\u0018BA:u\u0013\r\tIJ]\u0001\be\u0016\u0004H.[2b\u0013\u0011\ti*a(\u0002\u001bI+\u0007\u000f\\5dCN#\u0018\r^;t\u0015\r\tIJ]\u0005\u0005\u0003G\u000b)+\u0001\u0006NSJ\u0014xN]%oM>TA!!(\u0002 &!\u0011\u0011VAV\u0005\u0015\u0019F/\u0019;f\u0015\u0011\t\u0019+!*\u0002\rM$\u0018\r^3!\u0003E\u0001XO\u00197jg\",'O\u0011:pW\u0016\u0014\u0018\nZ\u0001\u0013aV\u0014G.[:iKJ\u0014%o\\6fe&#\u0007\u0005\u0006\u0004\u0002V\u0005U\u0016q\u0017\u0005\b\u0003w2\u0003\u0019AA@\u0011\u001d\tyK\na\u0001\u0003\u0017\tAaY8qsR1\u0011QKA_\u0003\u007fC\u0011\"a\u001f(!\u0003\u0005\r!a \t\u0013\u0005=v\u0005%AA\u0002\u0005-\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000bTC!a \u0002H.\u0012\u0011\u0011\u001a\t\u0005\u0003\u0017\f).\u0004\u0002\u0002N*!\u0011qZAi\u0003%)hn\u00195fG.,GMC\u0002\u0002T:\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t9.!4\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005u'\u0006BA\u0006\u0003\u000f\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAr!\u0011\t)/a<\u000e\u0005\u0005\u001d(\u0002BAu\u0003W\fA\u0001\\1oO*\u0011\u0011Q^\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002r\u0006\u001d(AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005e\u0018q \t\u0004\u001b\u0006m\u0018bAA\u007f\u001d\n\u0019\u0011I\\=\t\u0013\t\u0005A&!AA\u0002\u0005-\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\bA1!\u0011\u0002B\u0006\u0003sl!!a\u000e\n\t\t5\u0011q\u0007\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u0014\te\u0001cA'\u0003\u0016%\u0019!q\u0003(\u0003\u000f\t{w\u000e\\3b]\"I!\u0011\u0001\u0018\u0002\u0002\u0003\u0007\u0011\u0011`\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002d\n}\u0001\"\u0003B\u0001_\u0005\u0005\t\u0019AA\u0006\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0006\u0003!!xn\u0015;sS:<GCAAr\u0003\u0019)\u0017/^1mgR!!1\u0003B\u0017\u0011%\u0011\tAMA\u0001\u0002\u0004\tI0A\bnSJ\u0014xN]*uCR,W*\u00199!\u0003Ii\u0017N\u001d:peN#\u0018\r^3D_VtG/\u001a:\u0016\u0005\tU\u0002\u0003CA\u0019\u0003w\u00119D!\u0010\u0011\t\u0005\u0005%\u0011H\u0005\u0005\u0005w\tYKA\u0007Ti\u0006$XmQ1uK\u001e|'/\u001f\t\u0005\u0005\u007f\u0011Y%\u0004\u0002\u0003B)!!1\tB#\u0003\u0019\tGo\\7jG*!\u0011Q\u0007B$\u0015\u0011\u0011I%a;\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005\u001b\u0012\tEA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\u0014[&\u0014(o\u001c:Ti\u0006$XmQ8v]R,'\u000fI\u0001\u0014a\u0016\u0014\u0018n\u001c3jG\u0006;wM]3hCRLwN\\\u000b\u0003\u0005+\u00022\u0001\u0016B,\u0013\r\u0011I\u0006\u0012\u0002\u0014!\u0016\u0014\u0018n\u001c3jG\u0006;wM]3hCRLwN\\\u0001\u0015a\u0016\u0014\u0018n\u001c3jG\u0006;wM]3hCRLwN\u001c\u0011\u0002\t1|7m[\u000b\u0003\u0005C\u0002BAa\u0019\u0003j5\u0011!Q\r\u0006\u0005\u0005O\u0012)%A\u0003m_\u000e\\7/\u0003\u0003\u0003l\t\u0015$!\u0004*fK:$(/\u00198u\u0019>\u001c7.A\u0003m_\u000e\\\u0007%\u0001\u000biC:$G.\u001a)vE2L7\u000f\u001b*fcV,7\u000f\u001e\u000b\u0007\u0005g\u0012IIa#\u0011\t\tU$1\u0011\b\u0005\u0005o\u0012iH\u0004\u0003\u0002\b\ne\u0014b\u0001B>e\u0006A!/Z9vKN$8/\u0003\u0003\u0003\u0000\t\u0005\u0015a\b*fa>\u0014Ho\u00117vgR,'\u000fT5oWN#\u0018\r^;t%\u0016\u001c\bo\u001c8tK*\u0019!1\u0010:\n\t\t\u0015%q\u0011\u0002\u000e!V\u0014G.[:i%\u0016\u001cX\u000f\u001c;\u000b\t\t}$\u0011\u0011\u0005\b\u0003_+\u0002\u0019AA\u0006\u0011\u001d\u0011i)\u0006a\u0001\u0005\u001f\u000b\u0011\u0002\\5oWN#\u0018\r^3\u0011\t\tE%q\u0013\b\u0005\u0005o\u0012\u0019*\u0003\u0003\u0003\u0016\n\u0005\u0015A\b*fa>\u0014Ho\u00117vgR,'\u000fT5oWN#\u0018\r^;t%\u0016\fX/Z:u\u0013\u0011\u0011IJa'\u0003-\rcWo\u001d;fe2Kgn['jeJ|'o\u0015;bi\u0016TAA!&\u0003\u0002\u0006\tR.\u001b:s_J\u001cF/\u0019;f\u0007>,h\u000e^:\u0015\u0005\t\u0005\u0006\u0003\u0003B\u0005\u0005G\u00139$a\u0003\n\t\t\u0015\u0016q\u0007\u0002\u0004\u001b\u0006\u0004\u0018aB:uCJ$X\u000f\u001d\u000b\u0003\u0005W\u00032!\u0014BW\u0013\r\u0011yK\u0014\u0002\u0005+:LG/\u0001\u000fsK\u001a\u0014Xm\u001d5QCJ$\u0018\u000e^5p]\u001a\u0013x.\\'fi\u0006$\u0015\r^1\u0002\u0011MDW\u000f\u001e3po:\fqA]3ge\u0016\u001c\b.\u0001\tsK\u001a\u0014Xm\u001d5QCJ$\u0018\u000e^5p]R!!1\u0016B^\u0011\u001d\u0011il\u0007a\u0001\u0005\u007f\u000bq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0007\u0005\u0013\u0011\t-!\u0014\n\t\t\r\u0017q\u0007\u0002\u0004'\u0016$\u0018aG;qI\u0006$X\rU1si&$\u0018n\u001c8Ge>lW*\u001a;b\t\u0006$\u0018\r\u0006\u0004\u0003,\n%'Q\u001a\u0005\b\u0005\u0017d\u0002\u0019AA\u0006\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\u000f\t=G\u00041\u0001\u0003R\u0006QAo\u001c9jG&k\u0017mZ3\u0011\t\tM'\u0011\\\u0007\u0003\u0005+T1Aa6u\u0003\u0015IW.Y4f\u0013\u0011\u0011YN!6\u0003\u0015Q{\u0007/[2J[\u0006<W-A\bva\u0012\fG/\u001a)beRLG/[8o))\u0011YK!9\u0003t\nU(q\u001f\u0005\b\u0005Gl\u0002\u0019\u0001Bs\u0003%!x\u000e]5d\u001d\u0006lW\r\u0005\u0003\u0003h\n=h\u0002\u0002Bu\u0005W\u00042!!\u001bO\u0013\r\u0011iOT\u0001\u0007!J,G-\u001a4\n\t\u0005E(\u0011\u001f\u0006\u0004\u0005[t\u0005b\u0002Bf;\u0001\u0007\u00111\u0002\u0005\b\u0003wj\u0002\u0019AA@\u0011\u001d\u0011I0\ba\u0001\u0003\u0017\t1\u0002];cY&\u001c\b.\u001a:JI\u0006aAo\u001c9jGN\u0014\u0015\u0010T5oWV\u0011!q \t\t\u0005\u0013\u0011\u0019K!:\u0003R\u0006y!/Z7pm\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0003,\u000e\u0015\u0001bBB\u0004?\u0001\u0007\u0011QJ\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0003-\u0019\u0017\r^3h_JL8+^7\u0002)A\u000b'\u000f^5uS>tW*\u001b:s_J\u001cF/\u0019;f!\r\t9\u0006N\n\u0006i\rE1Q\u0004\t\u000b\u0007'\u0019I\"a \u0002\f\u0005USBAB\u000b\u0015\r\u00199BT\u0001\beVtG/[7f\u0013\u0011\u0019Yb!\u0006\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0004 \r\u0015RBAB\u0011\u0015\u0011\u0019\u0019#a;\u0002\u0005%|\u0017\u0002BA<\u0007C!\"a!\u0004\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005U3QFB\u0018\u0011\u001d\tYh\u000ea\u0001\u0003\u007fBq!a,8\u0001\u0004\tY!A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\rU2\u0011\t\t\u0006\u001b\u000e]21H\u0005\u0004\u0007sq%AB(qi&|g\u000eE\u0004N\u0007{\ty(a\u0003\n\u0007\r}bJ\u0001\u0004UkBdWM\r\u0005\n\u0007\u0007B\u0014\u0011!a\u0001\u0003+\n1\u0001\u001f\u00131\u0003U\u0019E.^:uKJd\u0015N\\6BO\u001e\u0014XmZ1u_J\u00042!a\u0016;'\tQD\n\u0006\u0002\u0004H\u0005A1\u000f^1uK6\u000b\u0007/\u0006\u0002\u0004RAA!\u0011\u0002BR\u0007'\ny\b\u0005\u0003\u0004V\r}c\u0002BB,\u00077j!a!\u0017\u000b\u0005-$\u0018\u0002BB/\u00073\n1\"T5se>\u0014Hk\u001c9jG&!\u0011\u0011VB1\u0015\u0011\u0019if!\u0017\u0002\u0013M$\u0018\r^3NCB\u0004\u0013!\u0005;p\u001b&\u0014(o\u001c:J]\u001a|7\u000b^1uKR!\u0011qPB5\u0011\u001d\tYH\u0010a\u0001\u0007'\u0002\"\u0001\u0016!\u0014\u0005\u0001cECAB6\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%o\u0001")
public class ClusterLinkAggregator
implements ClusterLinkFactory.ClusterLinkAggregator,
Logging {
    private volatile ClusterLinkAggregator$PartitionMirrorState$ PartitionMirrorState$module;
    private volatile ClusterLinkAggregator$ClusterLinkAggregator$ ClusterLinkAggregator$module;
    private final ClusterLinkData clusterLinkData;
    private final KRaftMetadataCache metadataCache;
    private final int stateExpiryDurationMs;
    private final int unknownPublisherBrokerId;
    private final TrieMap<Object, Object> brokerLastReportTime;
    private final TrieMap<TopicPartition, PartitionMirrorState> mirrorStateMap;
    private final TrieMap<ReplicaStatus.MirrorInfo.StateCategory, AtomicInteger> mirrorStateCounter;
    private final PeriodicAggregation periodicAggregation;
    private final ReentrantLock lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$7() {
        return ClusterLinkAggregator$.MODULE$.$lessinit$greater$default$7();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ClusterLinkAggregator$PartitionMirrorState$ PartitionMirrorState() {
        if (this.PartitionMirrorState$module == null) {
            this.PartitionMirrorState$lzycompute$1();
        }
        return this.PartitionMirrorState$module;
    }

    public ClusterLinkAggregator$ClusterLinkAggregator$ ClusterLinkAggregator() {
        if (this.ClusterLinkAggregator$module == null) {
            this.ClusterLinkAggregator$lzycompute$1();
        }
        return this.ClusterLinkAggregator$module;
    }

    private Logger logger$lzycompute() {
        ClusterLinkAggregator clusterLinkAggregator = this;
        synchronized (clusterLinkAggregator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int unknownPublisherBrokerId() {
        return this.unknownPublisherBrokerId;
    }

    private TrieMap<Object, Object> brokerLastReportTime() {
        return this.brokerLastReportTime;
    }

    private TrieMap<TopicPartition, PartitionMirrorState> mirrorStateMap() {
        return this.mirrorStateMap;
    }

    private TrieMap<ReplicaStatus.MirrorInfo.StateCategory, AtomicInteger> mirrorStateCounter() {
        return this.mirrorStateCounter;
    }

    private PeriodicAggregation periodicAggregation() {
        return this.periodicAggregation;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    @Override
    public ReportClusterLinkStatusResponse.PublishResult handlePublishRequest(int publisherBrokerId, ReportClusterLinkStatusRequest.ClusterLinkMirrorState linkState) {
        ReportClusterLinkStatusResponse.PublishResult publishResult;
        this.trace((Function0<String> & Serializable)() -> "Start updating mirror states with linkStates: " + linkState + " and publisherBrokerId: " + publisherBrokerId + ".");
        String string = linkState.linkName();
        String string2 = this.clusterLinkData.linkName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.debug((Function0<String> & Serializable)() -> "Mirror states for link " + linkState.linkName() + " reported for link aggregator of " + $this.clusterLinkData.linkName() + ".");
            return ReportClusterLinkStatusResponse.PublishResult.LINK_NOT_AVAILABLE;
        }
        long currentTime = Instant.now().toEpochMilli();
        long existingTime = BoxesRunTime.unboxToLong(this.brokerLastReportTime().getOrElse(BoxesRunTime.boxToInteger(publisherBrokerId), () -> 0L));
        this.brokerLastReportTime().update(BoxesRunTime.boxToInteger(publisherBrokerId), BoxesRunTime.boxToLong(Math.max(existingTime, currentTime)));
        try {
            linkState.partitionStates().forEach(mirrorState -> this.updatePartition(mirrorState.topicName(), mirrorState.partitionId(), mirrorState.state(), publisherBrokerId));
            publishResult = ReportClusterLinkStatusResponse.PublishResult.SUCCESS;
        }
        catch (Throwable throwable) {
            this.error((Function0<String> & Serializable)() -> "Failed to publish MirrorState for " + linkState.linkName() + " from " + publisherBrokerId + ".", (Function0<Throwable> & Serializable)() -> throwable);
            publishResult = ReportClusterLinkStatusResponse.PublishResult.FAILED;
        }
        return publishResult;
    }

    @Override
    public Map<ReplicaStatus.MirrorInfo.StateCategory, Object> mirrorStateCounts() {
        return (Map)((MapOps)this.mirrorStateCounter().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ClusterLinkAggregator.$anonfun$mirrorStateCounts$1(x0$1)))).map((Function1<Tuple2, Tuple2> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                ReplicaStatus.MirrorInfo.StateCategory category = (ReplicaStatus.MirrorInfo.StateCategory)((Object)((Object)tuple2._1()));
                AtomicInteger number = (AtomicInteger)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(category), BoxesRunTime.boxToInteger(number.intValue()));
            }
            throw new MatchError(tuple2);
        });
    }

    @Override
    public void startup() {
        this.info((Function0<String> & Serializable)() -> "Starting ClusterLinkAggregator for cluster link " + $this.clusterLinkData.linkName());
        this.refreshPartitionFromMetaData();
        this.periodicAggregation().startup();
        this.info((Function0<String> & Serializable)() -> "Startup of ClusterLinkAggregator for cluster link " + $this.clusterLinkData.linkName() + " is complete");
    }

    private void refreshPartitionFromMetaData() {
        ((IterableOnceOps)this.topicsByLink().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ClusterLinkAggregator.$anonfun$refreshPartitionFromMetaData$1(x0$1)))).foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
            ClusterLinkAggregator.$anonfun$refreshPartitionFromMetaData$2(this, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void shutdown() {
        this.periodicAggregation().shutdown();
        this.lock().lock();
        try {
            this.brokerLastReportTime().clear();
            this.mirrorStateMap().clear();
            this.mirrorStateCounter().values().foreach((Function1<AtomicInteger, Object> & Serializable)value -> {
                value.set(0);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            this.lock().unlock();
        }
    }

    public void refresh() {
        this.trace((Function0<String> & Serializable)() -> "Current states are " + this.mirrorStateMap() + " and " + this.brokerLastReportTime() + ".");
        this.refreshPartitionFromMetaData();
        this.refreshPartition(this.mirrorStateMap().keySet());
    }

    private void refreshPartition(Set<TopicPartition> topicPartitions) {
        Map<String, TopicImage> topicImages = this.topicsByLink();
        topicPartitions.foreach((Function1<TopicPartition, Object> & Serializable)topicPartition -> {
            ClusterLinkAggregator.$anonfun$refreshPartition$1(this, topicImages, topicPartition);
            return BoxedUnit.UNIT;
        });
    }

    private void updatePartitionFromMetaData(int partitionId, TopicImage topicImage) {
        ReplicaStatus.MirrorInfo.State state;
        this.debug((Function0<String> & Serializable)() -> "Update mirror state from metadata for partition: " + topicImage.name() + "-" + partitionId + " with state: " + topicImage.mirrorTopic() + ".");
        Option<MirrorTopic> option = OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(topicImage.mirrorTopic()));
        if (option instanceof Some) {
            Some some = (Some)option;
            MirrorTopic value = (MirrorTopic)some.value();
            state = this.ClusterLinkAggregator().toMirrorInfoState(value.mirrorState());
        } else if (None$.MODULE$.equals(option)) {
            state = ReplicaStatus.MirrorInfo.State.UNKNOWN;
        } else {
            throw new MatchError(option);
        }
        ReplicaStatus.MirrorInfo.State state2 = state;
        this.updatePartition(topicImage.name(), partitionId, state2, this.unknownPublisherBrokerId());
    }

    private void updatePartition(String topicName, int partitionId, ReplicaStatus.MirrorInfo.State state, int publisherId) {
        block7: {
            this.lock().lock();
            try {
                boolean bl = false;
                Some some = null;
                Option<PartitionMirrorState> option = this.mirrorStateMap().put(new TopicPartition(topicName, partitionId), new PartitionMirrorState(this, state, publisherId));
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    PartitionMirrorState value = (PartitionMirrorState)some.value();
                    ReplicaStatus.MirrorInfo.State state2 = state;
                    ReplicaStatus.MirrorInfo.State state3 = value.state();
                    if (state2 == null ? state3 != null : !((Object)((Object)state2)).equals((Object)state3)) {
                        this.mirrorStateCounter().apply(value.state().category()).decrementAndGet();
                        this.mirrorStateCounter().apply(state.category()).incrementAndGet();
                        break block7;
                    }
                }
                if (bl) {
                    break block7;
                }
                if (None$.MODULE$.equals(option)) {
                    this.mirrorStateCounter().apply(state.category()).incrementAndGet();
                    break block7;
                }
                throw new MatchError(option);
            }
            finally {
                this.lock().unlock();
            }
        }
    }

    private Map<String, TopicImage> topicsByLink() {
        return this.metadataCache.getTopicsByLink(this.clusterLinkData.linkId());
    }

    private void removePartition(TopicPartition topicPartition) {
        block5: {
            this.lock().lock();
            try {
                Option<PartitionMirrorState> option = this.mirrorStateMap().remove(topicPartition);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    PartitionMirrorState value = (PartitionMirrorState)some.value();
                    this.mirrorStateCounter().apply(value.state().category()).decrementAndGet();
                    break block5;
                }
                if (None$.MODULE$.equals(option)) {
                    break block5;
                }
                throw new MatchError(option);
            }
            finally {
                this.lock().unlock();
            }
        }
    }

    public int categorySum() {
        return BoxesRunTime.unboxToInt(((IterableOnceOps)this.mirrorStateCounter().values().map((Function1<AtomicInteger, Object> & Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1.intValue()))).sum(Numeric.IntIsIntegral$.MODULE$));
    }

    private final void PartitionMirrorState$lzycompute$1() {
        ClusterLinkAggregator clusterLinkAggregator = this;
        synchronized (clusterLinkAggregator) {
            if (this.PartitionMirrorState$module == null) {
                this.PartitionMirrorState$module = new ClusterLinkAggregator$PartitionMirrorState$(this);
            }
        }
    }

    private final void ClusterLinkAggregator$lzycompute$1() {
        ClusterLinkAggregator clusterLinkAggregator = this;
        synchronized (clusterLinkAggregator) {
            if (this.ClusterLinkAggregator$module == null) {
                this.ClusterLinkAggregator$module = new ClusterLinkAggregator$ClusterLinkAggregator$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$mirrorStateCounts$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ReplicaStatus.MirrorInfo.StateCategory category;
            ReplicaStatus.MirrorInfo.StateCategory stateCategory = category = (ReplicaStatus.MirrorInfo.StateCategory)((Object)tuple2._1());
            ReplicaStatus.MirrorInfo.StateCategory stateCategory2 = ReplicaStatus.MirrorInfo.StateCategory.NOT_APPLICABLE;
            return stateCategory == null ? stateCategory2 != null : !((Object)((Object)stateCategory)).equals((Object)stateCategory2);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$refreshPartitionFromMetaData$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicImage topicImage = (TopicImage)tuple2._2();
            return topicImage.mirrorTopic().isPresent();
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$refreshPartitionFromMetaData$2(ClusterLinkAggregator $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            TopicImage topicImage = (TopicImage)tuple2._2();
            topicImage.partitions().keySet().forEach(partitionId -> {
                Option<PartitionMirrorState> option = $this.mirrorStateMap().get(new TopicPartition(topicImage.name(), Predef$.MODULE$.Integer2int((Integer)partitionId)));
                if (option instanceof Some) {
                    return;
                }
                if (None$.MODULE$.equals(option)) {
                    $this.updatePartitionFromMetaData(Predef$.MODULE$.Integer2int((Integer)partitionId), topicImage);
                    return;
                }
                throw new MatchError(option);
            });
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$refreshPartition$1(ClusterLinkAggregator $this, Map topicImages$1, TopicPartition topicPartition) {
        Option option = topicImages$1.get(topicPartition.topic());
        if (option instanceof Some) {
            long l;
            Some some = (Some)option;
            TopicImage topicImage = (TopicImage)some.value();
            int publisherBrokerId = $this.mirrorStateMap().apply(topicPartition).publisherBrokerId();
            Option<Object> option2 = $this.brokerLastReportTime().get(BoxesRunTime.boxToInteger(publisherBrokerId));
            if (option2 instanceof Some) {
                long value;
                Some some2 = (Some)option2;
                l = value = BoxesRunTime.unboxToLong(some2.value());
            } else if (None$.MODULE$.equals(option2)) {
                $this.debug((Function0<String> & Serializable)() -> "BrokerReportTime missing for BrokerId " + publisherBrokerId + ".");
                l = 0L;
            } else {
                throw new MatchError(option2);
            }
            long outdated = l;
            if (outdated < Instant.now().toEpochMilli() - (long)$this.stateExpiryDurationMs) {
                $this.debug((Function0<String> & Serializable)() -> "Mirror states expired for topicPartition: " + topicPartition + ".");
                $this.updatePartitionFromMetaData(topicPartition.partition(), topicImage);
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.removePartition(topicPartition);
            return;
        }
        throw new MatchError(option);
    }

    public ClusterLinkAggregator(ClusterLinkData clusterLinkData, ClusterLinkScheduler scheduler, KRaftMetadataCache metadataCache, Time time, ClusterLinkRequestQuota quota, ClusterLinkMetrics metrics, int stateExpiryDurationMs) {
        this.clusterLinkData = clusterLinkData;
        this.metadataCache = metadataCache;
        this.stateExpiryDurationMs = stateExpiryDurationMs;
        Logging.$init$(this);
        this.unknownPublisherBrokerId = -1;
        this.brokerLastReportTime = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.mirrorStateMap = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.mirrorStateCounter = (TrieMap)TrieMap$.MODULE$.apply((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ReplicaStatus.MirrorInfo.StateCategory.values()), (Function1<ReplicaStatus.MirrorInfo.StateCategory, Tuple2> & Serializable)value -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(value), new AtomicInteger(0)), ClassTag$.MODULE$.apply(Tuple2.class))));
        this.periodicAggregation = new PeriodicAggregation(scheduler, stateExpiryDurationMs, this, time, quota, metrics);
        this.lock = new ReentrantLock();
    }

    public class PartitionMirrorState
    implements Product,
    Serializable {
        private final ReplicaStatus.MirrorInfo.State state;
        private final int publisherBrokerId;
        public final /* synthetic */ ClusterLinkAggregator $outer;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        public ReplicaStatus.MirrorInfo.State state() {
            return this.state;
        }

        public int publisherBrokerId() {
            return this.publisherBrokerId;
        }

        public PartitionMirrorState copy(ReplicaStatus.MirrorInfo.State state, int publisherBrokerId) {
            return new PartitionMirrorState(this.kafka$server$link$ClusterLinkAggregator$PartitionMirrorState$$$outer(), state, publisherBrokerId);
        }

        public ReplicaStatus.MirrorInfo.State copy$default$1() {
            return this.state();
        }

        public int copy$default$2() {
            return this.publisherBrokerId();
        }

        @Override
        public String productPrefix() {
            return "PartitionMirrorState";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.state();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger(this.publisherBrokerId());
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof PartitionMirrorState;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "state";
                }
                case 1: {
                    return "publisherBrokerId";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash((Object)this.state()));
            n = Statics.mix(n, this.publisherBrokerId());
            return Statics.finalizeHash(n, 2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PartitionMirrorState)) return false;
            if (((PartitionMirrorState)object).kafka$server$link$ClusterLinkAggregator$PartitionMirrorState$$$outer() != this.kafka$server$link$ClusterLinkAggregator$PartitionMirrorState$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            PartitionMirrorState partitionMirrorState = (PartitionMirrorState)x$1;
            if (this.publisherBrokerId() != partitionMirrorState.publisherBrokerId()) return false;
            ReplicaStatus.MirrorInfo.State state = this.state();
            ReplicaStatus.MirrorInfo.State state2 = partitionMirrorState.state();
            if (state == null) {
                if (state2 != null) {
                    return false;
                }
            } else if (!((Object)((Object)state)).equals((Object)state2)) return false;
            if (!partitionMirrorState.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClusterLinkAggregator kafka$server$link$ClusterLinkAggregator$PartitionMirrorState$$$outer() {
            return this.$outer;
        }

        public PartitionMirrorState(ClusterLinkAggregator $outer, ReplicaStatus.MirrorInfo.State state, int publisherBrokerId) {
            this.state = state;
            this.publisherBrokerId = publisherBrokerId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$(this);
        }
    }
}

